/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTerminationPolicyTypesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeTerminationPolicyTypesResponse.Builder, DescribeTerminationPolicyTypesResponse> {
    private static final SdkField<List<String>> TERMINATION_POLICY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTerminationPolicyTypesResponse::terminationPolicyTypes))
            .setter(setter(Builder::terminationPolicyTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicyTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TERMINATION_POLICY_TYPES_FIELD));

    private final List<String> terminationPolicyTypes;

    private DescribeTerminationPolicyTypesResponse(BuilderImpl builder) {
        super(builder);
        this.terminationPolicyTypes = builder.terminationPolicyTypes;
    }

    /**
     * <p>
     * The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
     * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>,
     * <code>Default</code>, <code>OldestLaunchTemplate</code>, and <code>AllocationStrategy</code>. Currently, the
     * <code>OldestLaunchTemplate</code> and <code>AllocationStrategy</code> policies are only supported for Auto
     * Scaling groups with <a>MixedInstancesPolicy</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
     *         <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
     *         <code>ClosestToNextInstanceHour</code>, <code>Default</code>, <code>OldestLaunchTemplate</code>, and
     *         <code>AllocationStrategy</code>. Currently, the <code>OldestLaunchTemplate</code> and
     *         <code>AllocationStrategy</code> policies are only supported for Auto Scaling groups with
     *         <a>MixedInstancesPolicy</a>.
     */
    public List<String> terminationPolicyTypes() {
        return terminationPolicyTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(terminationPolicyTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTerminationPolicyTypesResponse)) {
            return false;
        }
        DescribeTerminationPolicyTypesResponse other = (DescribeTerminationPolicyTypesResponse) obj;
        return Objects.equals(terminationPolicyTypes(), other.terminationPolicyTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTerminationPolicyTypesResponse").add("TerminationPolicyTypes", terminationPolicyTypes())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminationPolicyTypes":
            return Optional.ofNullable(clazz.cast(terminationPolicyTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTerminationPolicyTypesResponse, T> g) {
        return obj -> g.apply((DescribeTerminationPolicyTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTerminationPolicyTypesResponse> {
        /**
         * <p>
         * The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
         * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>,
         * <code>Default</code>, <code>OldestLaunchTemplate</code>, and <code>AllocationStrategy</code>. Currently, the
         * <code>OldestLaunchTemplate</code> and <code>AllocationStrategy</code> policies are only supported for Auto
         * Scaling groups with <a>MixedInstancesPolicy</a>.
         * </p>
         * 
         * @param terminationPolicyTypes
         *        The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
         *        <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
         *        <code>ClosestToNextInstanceHour</code>, <code>Default</code>, <code>OldestLaunchTemplate</code>, and
         *        <code>AllocationStrategy</code>. Currently, the <code>OldestLaunchTemplate</code> and
         *        <code>AllocationStrategy</code> policies are only supported for Auto Scaling groups with
         *        <a>MixedInstancesPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicyTypes(Collection<String> terminationPolicyTypes);

        /**
         * <p>
         * The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
         * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>,
         * <code>Default</code>, <code>OldestLaunchTemplate</code>, and <code>AllocationStrategy</code>. Currently, the
         * <code>OldestLaunchTemplate</code> and <code>AllocationStrategy</code> policies are only supported for Auto
         * Scaling groups with <a>MixedInstancesPolicy</a>.
         * </p>
         * 
         * @param terminationPolicyTypes
         *        The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
         *        <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
         *        <code>ClosestToNextInstanceHour</code>, <code>Default</code>, <code>OldestLaunchTemplate</code>, and
         *        <code>AllocationStrategy</code>. Currently, the <code>OldestLaunchTemplate</code> and
         *        <code>AllocationStrategy</code> policies are only supported for Auto Scaling groups with
         *        <a>MixedInstancesPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicyTypes(String... terminationPolicyTypes);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<String> terminationPolicyTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTerminationPolicyTypesResponse model) {
            super(model);
            terminationPolicyTypes(model.terminationPolicyTypes);
        }

        public final Collection<String> getTerminationPolicyTypes() {
            return terminationPolicyTypes;
        }

        @Override
        public final Builder terminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicyTypes(String... terminationPolicyTypes) {
            terminationPolicyTypes(Arrays.asList(terminationPolicyTypes));
            return this;
        }

        public final void setTerminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
        }

        @Override
        public DescribeTerminationPolicyTypesResponse build() {
            return new DescribeTerminationPolicyTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
