/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a policy adjustment type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdjustmentType implements SdkPojo, Serializable, ToCopyableBuilder<AdjustmentType.Builder, AdjustmentType> {
    private static final SdkField<String> ADJUSTMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AdjustmentType::adjustmentType)).setter(setter(Builder::adjustmentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjustmentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADJUSTMENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adjustmentType;

    private AdjustmentType(BuilderImpl builder) {
        this.adjustmentType = builder.adjustmentType;
    }

    /**
     * <p>
     * The policy adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
     * <code>PercentChangeInCapacity</code>.
     * </p>
     * 
     * @return The policy adjustment type. The valid values are <code>ChangeInCapacity</code>,
     *         <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.
     */
    public String adjustmentType() {
        return adjustmentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adjustmentType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdjustmentType)) {
            return false;
        }
        AdjustmentType other = (AdjustmentType) obj;
        return Objects.equals(adjustmentType(), other.adjustmentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AdjustmentType").add("AdjustmentType", adjustmentType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdjustmentType":
            return Optional.ofNullable(clazz.cast(adjustmentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdjustmentType, T> g) {
        return obj -> g.apply((AdjustmentType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdjustmentType> {
        /**
         * <p>
         * The policy adjustment type. The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>,
         * and <code>PercentChangeInCapacity</code>.
         * </p>
         * 
         * @param adjustmentType
         *        The policy adjustment type. The valid values are <code>ChangeInCapacity</code>,
         *        <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentType(String adjustmentType);
    }

    static final class BuilderImpl implements Builder {
        private String adjustmentType;

        private BuilderImpl() {
        }

        private BuilderImpl(AdjustmentType model) {
            adjustmentType(model.adjustmentType);
        }

        public final String getAdjustmentType() {
            return adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        @Override
        public AdjustmentType build() {
            return new AdjustmentType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
