/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScheduledActionsResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeScheduledActionsResponse.Builder, DescribeScheduledActionsResponse> {
    private static final SdkField<List<ScheduledUpdateGroupAction>> SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD = SdkField
            .<List<ScheduledUpdateGroupAction>> builder(MarshallingType.LIST)
            .getter(getter(DescribeScheduledActionsResponse::scheduledUpdateGroupActions))
            .setter(setter(Builder::scheduledUpdateGroupActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledUpdateGroupActions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledUpdateGroupAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledUpdateGroupAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeScheduledActionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions;

    private final String nextToken;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledUpdateGroupActions = builder.scheduledUpdateGroupActions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The scheduled actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The scheduled actions.
     */
    public List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions() {
        return scheduledUpdateGroupActions;
    }

    /**
     * <p>
     * A string that indicates that the response contains more items than can be returned in a single response. To
     * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set
     * of items. This value is null when there are no more items to return.
     * </p>
     * 
     * @return A string that indicates that the response contains more items than can be returned in a single response.
     *         To receive additional items, specify this string for the <code>NextToken</code> value when requesting the
     *         next set of items. This value is null when there are no more items to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledUpdateGroupActions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse) obj;
        return Objects.equals(scheduledUpdateGroupActions(), other.scheduledUpdateGroupActions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeScheduledActionsResponse")
                .add("ScheduledUpdateGroupActions", scheduledUpdateGroupActions()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledUpdateGroupActions":
            return Optional.ofNullable(clazz.cast(scheduledUpdateGroupActions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsResponse, T> g) {
        return obj -> g.apply((DescribeScheduledActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        /**
         * <p>
         * The scheduled actions.
         * </p>
         * 
         * @param scheduledUpdateGroupActions
         *        The scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions);

        /**
         * <p>
         * The scheduled actions.
         * </p>
         * 
         * @param scheduledUpdateGroupActions
         *        The scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction... scheduledUpdateGroupActions);

        /**
         * <p>
         * The scheduled actions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScheduledUpdateGroupAction>.Builder}
         * avoiding the need to create one manually via {@link List<ScheduledUpdateGroupAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledUpdateGroupAction>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #scheduledUpdateGroupActions(List<ScheduledUpdateGroupAction>)}.
         * 
         * @param scheduledUpdateGroupActions
         *        a consumer that will call methods on {@link List<ScheduledUpdateGroupAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledUpdateGroupActions(List<ScheduledUpdateGroupAction>)
         */
        Builder scheduledUpdateGroupActions(Consumer<ScheduledUpdateGroupAction.Builder>... scheduledUpdateGroupActions);

        /**
         * <p>
         * A string that indicates that the response contains more items than can be returned in a single response. To
         * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next
         * set of items. This value is null when there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        A string that indicates that the response contains more items than can be returned in a single
         *        response. To receive additional items, specify this string for the <code>NextToken</code> value when
         *        requesting the next set of items. This value is null when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            super(model);
            scheduledUpdateGroupActions(model.scheduledUpdateGroupActions);
            nextToken(model.nextToken);
        }

        public final Collection<ScheduledUpdateGroupAction.Builder> getScheduledUpdateGroupActions() {
            return scheduledUpdateGroupActions != null ? scheduledUpdateGroupActions.stream()
                    .map(ScheduledUpdateGroupAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copy(scheduledUpdateGroupActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction... scheduledUpdateGroupActions) {
            scheduledUpdateGroupActions(Arrays.asList(scheduledUpdateGroupActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(
                Consumer<ScheduledUpdateGroupAction.Builder>... scheduledUpdateGroupActions) {
            scheduledUpdateGroupActions(Stream.of(scheduledUpdateGroupActions)
                    .map(c -> ScheduledUpdateGroupAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledUpdateGroupActions(
                Collection<ScheduledUpdateGroupAction.BuilderImpl> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copyFromBuilder(scheduledUpdateGroupActions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
