/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScalingPlansRequest extends AutoScalingPlansRequest implements
        ToCopyableBuilder<DescribeScalingPlansRequest.Builder, DescribeScalingPlansRequest> {
    private static final SdkField<List<String>> SCALING_PLAN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ScalingPlanNames")
            .getter(getter(DescribeScalingPlansRequest::scalingPlanNames))
            .setter(setter(Builder::scalingPlanNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> SCALING_PLAN_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ScalingPlanVersion").getter(getter(DescribeScalingPlansRequest::scalingPlanVersion))
            .setter(setter(Builder::scalingPlanVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanVersion").build())
            .build();

    private static final SdkField<List<ApplicationSource>> APPLICATION_SOURCES_FIELD = SdkField
            .<List<ApplicationSource>> builder(MarshallingType.LIST)
            .memberName("ApplicationSources")
            .getter(getter(DescribeScalingPlansRequest::applicationSources))
            .setter(setter(Builder::applicationSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeScalingPlansRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeScalingPlansRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAMES_FIELD,
            SCALING_PLAN_VERSION_FIELD, APPLICATION_SOURCES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> scalingPlanNames;

    private final Long scalingPlanVersion;

    private final List<ApplicationSource> applicationSources;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeScalingPlansRequest(BuilderImpl builder) {
        super(builder);
        this.scalingPlanNames = builder.scalingPlanNames;
        this.scalingPlanVersion = builder.scalingPlanVersion;
        this.applicationSources = builder.applicationSources;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ScalingPlanNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasScalingPlanNames() {
        return scalingPlanNames != null && !(scalingPlanNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the scaling plans (up to 10). If you specify application sources, you cannot specify scaling plan
     * names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScalingPlanNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the scaling plans (up to 10). If you specify application sources, you cannot specify scaling
     *         plan names.
     */
    public final List<String> scalingPlanNames() {
        return scalingPlanNames;
    }

    /**
     * <p>
     * The version number of the scaling plan. Currently, the only valid value is <code>1</code>.
     * </p>
     * <note>
     * <p>
     * If you specify a scaling plan version, you must also specify a scaling plan name.
     * </p>
     * </note>
     * 
     * @return The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p> <note>
     *         <p>
     *         If you specify a scaling plan version, you must also specify a scaling plan name.
     *         </p>
     */
    public final Long scalingPlanVersion() {
        return scalingPlanVersion;
    }

    /**
     * Returns true if the ApplicationSources property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasApplicationSources() {
        return applicationSources != null && !(applicationSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify application
     * sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApplicationSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify
     *         application sources.
     */
    public final List<ApplicationSource> applicationSources() {
        return applicationSources;
    }

    /**
     * <p>
     * The maximum number of scalable resources to return. This value can be between 1 and 50. The default value is 50.
     * </p>
     * 
     * @return The maximum number of scalable resources to return. This value can be between 1 and 50. The default value
     *         is 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScalingPlanNames() ? scalingPlanNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scalingPlanVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationSources() ? applicationSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingPlansRequest)) {
            return false;
        }
        DescribeScalingPlansRequest other = (DescribeScalingPlansRequest) obj;
        return hasScalingPlanNames() == other.hasScalingPlanNames()
                && Objects.equals(scalingPlanNames(), other.scalingPlanNames())
                && Objects.equals(scalingPlanVersion(), other.scalingPlanVersion())
                && hasApplicationSources() == other.hasApplicationSources()
                && Objects.equals(applicationSources(), other.applicationSources())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScalingPlansRequest")
                .add("ScalingPlanNames", hasScalingPlanNames() ? scalingPlanNames() : null)
                .add("ScalingPlanVersion", scalingPlanVersion())
                .add("ApplicationSources", hasApplicationSources() ? applicationSources() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPlanNames":
            return Optional.ofNullable(clazz.cast(scalingPlanNames()));
        case "ScalingPlanVersion":
            return Optional.ofNullable(clazz.cast(scalingPlanVersion()));
        case "ApplicationSources":
            return Optional.ofNullable(clazz.cast(applicationSources()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingPlansRequest, T> g) {
        return obj -> g.apply((DescribeScalingPlansRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingPlansRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScalingPlansRequest> {
        /**
         * <p>
         * The names of the scaling plans (up to 10). If you specify application sources, you cannot specify scaling
         * plan names.
         * </p>
         * 
         * @param scalingPlanNames
         *        The names of the scaling plans (up to 10). If you specify application sources, you cannot specify
         *        scaling plan names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanNames(Collection<String> scalingPlanNames);

        /**
         * <p>
         * The names of the scaling plans (up to 10). If you specify application sources, you cannot specify scaling
         * plan names.
         * </p>
         * 
         * @param scalingPlanNames
         *        The names of the scaling plans (up to 10). If you specify application sources, you cannot specify
         *        scaling plan names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanNames(String... scalingPlanNames);

        /**
         * <p>
         * The version number of the scaling plan. Currently, the only valid value is <code>1</code>.
         * </p>
         * <note>
         * <p>
         * If you specify a scaling plan version, you must also specify a scaling plan name.
         * </p>
         * </note>
         * 
         * @param scalingPlanVersion
         *        The version number of the scaling plan. Currently, the only valid value is <code>1</code>.</p> <note>
         *        <p>
         *        If you specify a scaling plan version, you must also specify a scaling plan name.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanVersion(Long scalingPlanVersion);

        /**
         * <p>
         * The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify
         * application sources.
         * </p>
         * 
         * @param applicationSources
         *        The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify
         *        application sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSources(Collection<ApplicationSource> applicationSources);

        /**
         * <p>
         * The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify
         * application sources.
         * </p>
         * 
         * @param applicationSources
         *        The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify
         *        application sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSources(ApplicationSource... applicationSources);

        /**
         * <p>
         * The sources for the applications (up to 10). If you specify scaling plan names, you cannot specify
         * application sources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ApplicationSource>.Builder} avoiding the
         * need to create one manually via {@link List<ApplicationSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationSource>.Builder#build()} is called immediately
         * and its result is passed to {@link #applicationSources(List<ApplicationSource>)}.
         * 
         * @param applicationSources
         *        a consumer that will call methods on {@link List<ApplicationSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSources(List<ApplicationSource>)
         */
        Builder applicationSources(Consumer<ApplicationSource.Builder>... applicationSources);

        /**
         * <p>
         * The maximum number of scalable resources to return. This value can be between 1 and 50. The default value is
         * 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of scalable resources to return. This value can be between 1 and 50. The default
         *        value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingPlansRequest.BuilderImpl implements Builder {
        private List<String> scalingPlanNames = DefaultSdkAutoConstructList.getInstance();

        private Long scalingPlanVersion;

        private List<ApplicationSource> applicationSources = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingPlansRequest model) {
            super(model);
            scalingPlanNames(model.scalingPlanNames);
            scalingPlanVersion(model.scalingPlanVersion);
            applicationSources(model.applicationSources);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getScalingPlanNames() {
            if (scalingPlanNames instanceof SdkAutoConstructList) {
                return null;
            }
            return scalingPlanNames;
        }

        @Override
        public final Builder scalingPlanNames(Collection<String> scalingPlanNames) {
            this.scalingPlanNames = ScalingPlanNamesCopier.copy(scalingPlanNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPlanNames(String... scalingPlanNames) {
            scalingPlanNames(Arrays.asList(scalingPlanNames));
            return this;
        }

        public final void setScalingPlanNames(Collection<String> scalingPlanNames) {
            this.scalingPlanNames = ScalingPlanNamesCopier.copy(scalingPlanNames);
        }

        public final Long getScalingPlanVersion() {
            return scalingPlanVersion;
        }

        @Override
        public final Builder scalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
            return this;
        }

        public final void setScalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
        }

        public final List<ApplicationSource.Builder> getApplicationSources() {
            List<ApplicationSource.Builder> result = ApplicationSourcesCopier.copyToBuilder(this.applicationSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder applicationSources(Collection<ApplicationSource> applicationSources) {
            this.applicationSources = ApplicationSourcesCopier.copy(applicationSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSources(ApplicationSource... applicationSources) {
            applicationSources(Arrays.asList(applicationSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSources(Consumer<ApplicationSource.Builder>... applicationSources) {
            applicationSources(Stream.of(applicationSources).map(c -> ApplicationSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setApplicationSources(Collection<ApplicationSource.BuilderImpl> applicationSources) {
            this.applicationSources = ApplicationSourcesCopier.copyFromBuilder(applicationSources);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScalingPlansRequest build() {
            return new DescribeScalingPlansRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
