/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MetricStatistic {
    AVERAGE("Average"),
    MINIMUM("Minimum"),
    MAXIMUM("Maximum"),
    SAMPLE_COUNT("SampleCount"),
    SUM("Sum"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MetricStatistic(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricStatistic fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MetricStatistic.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricStatistic> knownValues() {
        return Stream.of(MetricStatistic.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

