/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanRequest;
import software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanResponse;
import software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanRequest;
import software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanResponse;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesResponse;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest;
import software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse;
import software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest;
import software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse;
import software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanRequest;
import software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanResponse;

/**
 * Service client for accessing AWS Auto Scaling Plans asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>AWS Auto Scaling</fullname>
 * <p>
 * Use AWS Auto Scaling to create scaling plans for your applications to automatically scale your scalable AWS
 * resources.
 * </p>
 * <p>
 * <b>API Summary</b>
 * </p>
 * <p>
 * You can use the AWS Auto Scaling service API to accomplish the following tasks:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Create and manage scaling plans
 * </p>
 * </li>
 * <li>
 * <p>
 * Define target tracking scaling policies to dynamically scale your resources based on utilization
 * </p>
 * </li>
 * <li>
 * <p>
 * Scale Amazon EC2 Auto Scaling groups using predictive scaling and dynamic scaling to scale your Amazon EC2 capacity
 * faster
 * </p>
 * </li>
 * <li>
 * <p>
 * Set minimum and maximum capacity limits
 * </p>
 * </li>
 * <li>
 * <p>
 * Retrieve information on existing scaling plans
 * </p>
 * </li>
 * <li>
 * <p>
 * Access current forecast data and historical forecast data for up to 56 days previous
 * </p>
 * </li>
 * </ul>
 * <p>
 * To learn more about AWS Auto Scaling, including information about granting IAM users required permissions for AWS
 * Auto Scaling actions, see the <a
 * href="https://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-aws-auto-scaling.html">AWS Auto Scaling User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AutoScalingPlansAsyncClient extends SdkClient {
    String SERVICE_NAME = "autoscaling-plans";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "autoscaling-plans";

    /**
     * Create a {@link AutoScalingPlansAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AutoScalingPlansAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AutoScalingPlansAsyncClient}.
     */
    static AutoScalingPlansAsyncClientBuilder builder() {
        return new DefaultAutoScalingPlansAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a scaling plan.
     * </p>
     *
     * @param createScalingPlanRequest
     * @return A Java Future containing the result of the CreateScalingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>LimitExceededException Your account exceeded a limit. This exception is thrown when a per-account
     *         resource limit is exceeded.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.CreateScalingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/CreateScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateScalingPlanResponse> createScalingPlan(CreateScalingPlanRequest createScalingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scaling plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScalingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateScalingPlanRequest#builder()}
     * </p>
     *
     * @param createScalingPlanRequest
     *        A {@link Consumer} that will call methods on {@link CreateScalingPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateScalingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>LimitExceededException Your account exceeded a limit. This exception is thrown when a per-account
     *         resource limit is exceeded.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.CreateScalingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/CreateScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateScalingPlanResponse> createScalingPlan(
            Consumer<CreateScalingPlanRequest.Builder> createScalingPlanRequest) {
        return createScalingPlan(CreateScalingPlanRequest.builder().applyMutation(createScalingPlanRequest).build());
    }

    /**
     * <p>
     * Deletes the specified scaling plan.
     * </p>
     * <p>
     * Deleting a scaling plan deletes the underlying <a>ScalingInstruction</a> for all of the scalable resources that
     * are covered by the plan.
     * </p>
     * <p>
     * If the plan has launched resources or has scaling activities in progress, you must delete those resources
     * separately.
     * </p>
     *
     * @param deleteScalingPlanRequest
     * @return A Java Future containing the result of the DeleteScalingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>ObjectNotFoundException The specified object could not be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.DeleteScalingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DeleteScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScalingPlanResponse> deleteScalingPlan(DeleteScalingPlanRequest deleteScalingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified scaling plan.
     * </p>
     * <p>
     * Deleting a scaling plan deletes the underlying <a>ScalingInstruction</a> for all of the scalable resources that
     * are covered by the plan.
     * </p>
     * <p>
     * If the plan has launched resources or has scaling activities in progress, you must delete those resources
     * separately.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScalingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteScalingPlanRequest#builder()}
     * </p>
     *
     * @param deleteScalingPlanRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScalingPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteScalingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>ObjectNotFoundException The specified object could not be found.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.DeleteScalingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DeleteScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScalingPlanResponse> deleteScalingPlan(
            Consumer<DeleteScalingPlanRequest.Builder> deleteScalingPlanRequest) {
        return deleteScalingPlan(DeleteScalingPlanRequest.builder().applyMutation(deleteScalingPlanRequest).build());
    }

    /**
     * <p>
     * Describes the scalable resources in the specified scaling plan.
     * </p>
     *
     * @param describeScalingPlanResourcesRequest
     * @return A Java Future containing the result of the DescribeScalingPlanResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>InvalidNextTokenException The token provided is not valid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.DescribeScalingPlanResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlanResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingPlanResourcesResponse> describeScalingPlanResources(
            DescribeScalingPlanResourcesRequest describeScalingPlanResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the scalable resources in the specified scaling plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingPlanResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeScalingPlanResourcesRequest#builder()}
     * </p>
     *
     * @param describeScalingPlanResourcesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalingPlanResourcesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeScalingPlanResources operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>InvalidNextTokenException The token provided is not valid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.DescribeScalingPlanResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlanResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingPlanResourcesResponse> describeScalingPlanResources(
            Consumer<DescribeScalingPlanResourcesRequest.Builder> describeScalingPlanResourcesRequest) {
        return describeScalingPlanResources(DescribeScalingPlanResourcesRequest.builder()
                .applyMutation(describeScalingPlanResourcesRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your scaling plans.
     * </p>
     *
     * @param describeScalingPlansRequest
     * @return A Java Future containing the result of the DescribeScalingPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>InvalidNextTokenException The token provided is not valid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.DescribeScalingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingPlansResponse> describeScalingPlans(
            DescribeScalingPlansRequest describeScalingPlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your scaling plans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingPlansRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeScalingPlansRequest#builder()}
     * </p>
     *
     * @param describeScalingPlansRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScalingPlansRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeScalingPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>InvalidNextTokenException The token provided is not valid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.DescribeScalingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingPlansResponse> describeScalingPlans(
            Consumer<DescribeScalingPlansRequest.Builder> describeScalingPlansRequest) {
        return describeScalingPlans(DescribeScalingPlansRequest.builder().applyMutation(describeScalingPlansRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your scaling plans.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeScalingPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>InvalidNextTokenException The token provided is not valid.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.DescribeScalingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingPlansResponse> describeScalingPlans() {
        return describeScalingPlans(DescribeScalingPlansRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the forecast data for a scalable resource.
     * </p>
     * <p>
     * Capacity forecasts are represented as predicted values, or data points, that are calculated using historical data
     * points from a specified CloudWatch load metric. Data points are available for up to 56 days.
     * </p>
     *
     * @param getScalingPlanResourceForecastDataRequest
     * @return A Java Future containing the result of the GetScalingPlanResourceForecastData operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.GetScalingPlanResourceForecastData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/GetScalingPlanResourceForecastData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetScalingPlanResourceForecastDataResponse> getScalingPlanResourceForecastData(
            GetScalingPlanResourceForecastDataRequest getScalingPlanResourceForecastDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the forecast data for a scalable resource.
     * </p>
     * <p>
     * Capacity forecasts are represented as predicted values, or data points, that are calculated using historical data
     * points from a specified CloudWatch load metric. Data points are available for up to 56 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetScalingPlanResourceForecastDataRequest.Builder}
     * avoiding the need to create one manually via {@link GetScalingPlanResourceForecastDataRequest#builder()}
     * </p>
     *
     * @param getScalingPlanResourceForecastDataRequest
     *        A {@link Consumer} that will call methods on {@link GetScalingPlanResourceForecastDataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetScalingPlanResourceForecastData operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.GetScalingPlanResourceForecastData
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/GetScalingPlanResourceForecastData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetScalingPlanResourceForecastDataResponse> getScalingPlanResourceForecastData(
            Consumer<GetScalingPlanResourceForecastDataRequest.Builder> getScalingPlanResourceForecastDataRequest) {
        return getScalingPlanResourceForecastData(GetScalingPlanResourceForecastDataRequest.builder()
                .applyMutation(getScalingPlanResourceForecastDataRequest).build());
    }

    /**
     * <p>
     * Updates the specified scaling plan.
     * </p>
     * <p>
     * You cannot update a scaling plan if it is in the process of being created, updated, or deleted.
     * </p>
     *
     * @param updateScalingPlanRequest
     * @return A Java Future containing the result of the UpdateScalingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>ObjectNotFoundException The specified object could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.UpdateScalingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/UpdateScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateScalingPlanResponse> updateScalingPlan(UpdateScalingPlanRequest updateScalingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified scaling plan.
     * </p>
     * <p>
     * You cannot update a scaling plan if it is in the process of being created, updated, or deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScalingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateScalingPlanRequest#builder()}
     * </p>
     *
     * @param updateScalingPlanRequest
     *        A {@link Consumer} that will call methods on {@link UpdateScalingPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateScalingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception was thrown for a validation issue. Review the parameters provided.</li>
     *         <li>ConcurrentUpdateException Concurrent updates caused an exception, for example, if you request an
     *         update to a scaling plan that already has a pending update.</li>
     *         <li>InternalServiceException The service encountered an internal error.</li>
     *         <li>ObjectNotFoundException The specified object could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AutoScalingPlansException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AutoScalingPlansAsyncClient.UpdateScalingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/UpdateScalingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateScalingPlanResponse> updateScalingPlan(
            Consumer<UpdateScalingPlanRequest.Builder> updateScalingPlanRequest) {
        return updateScalingPlan(UpdateScalingPlanRequest.builder().applyMutation(updateScalingPlanRequest).build());
    }
}
