/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScalingPlanResourceForecastDataRequest extends AutoScalingPlansRequest implements
        ToCopyableBuilder<GetScalingPlanResourceForecastDataRequest.Builder, GetScalingPlanResourceForecastDataRequest> {
    private static final SdkField<String> SCALING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalingPlanName").getter(getter(GetScalingPlanResourceForecastDataRequest::scalingPlanName))
            .setter(setter(Builder::scalingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanName").build()).build();

    private static final SdkField<Long> SCALING_PLAN_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ScalingPlanVersion").getter(getter(GetScalingPlanResourceForecastDataRequest::scalingPlanVersion))
            .setter(setter(Builder::scalingPlanVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanVersion").build())
            .build();

    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceNamespace").getter(getter(GetScalingPlanResourceForecastDataRequest::serviceNamespaceAsString))
            .setter(setter(Builder::serviceNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(GetScalingPlanResourceForecastDataRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalableDimension").getter(getter(GetScalingPlanResourceForecastDataRequest::scalableDimensionAsString))
            .setter(setter(Builder::scalableDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()).build();

    private static final SdkField<String> FORECAST_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastDataType").getter(getter(GetScalingPlanResourceForecastDataRequest::forecastDataTypeAsString))
            .setter(setter(Builder::forecastDataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastDataType").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetScalingPlanResourceForecastDataRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetScalingPlanResourceForecastDataRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAME_FIELD,
            SCALING_PLAN_VERSION_FIELD, SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD,
            FORECAST_DATA_TYPE_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private final String scalingPlanName;

    private final Long scalingPlanVersion;

    private final String serviceNamespace;

    private final String resourceId;

    private final String scalableDimension;

    private final String forecastDataType;

    private final Instant startTime;

    private final Instant endTime;

    private GetScalingPlanResourceForecastDataRequest(BuilderImpl builder) {
        super(builder);
        this.scalingPlanName = builder.scalingPlanName;
        this.scalingPlanVersion = builder.scalingPlanVersion;
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.forecastDataType = builder.forecastDataType;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The name of the scaling plan.
     * </p>
     * 
     * @return The name of the scaling plan.
     */
    public final String scalingPlanName() {
        return scalingPlanName;
    }

    /**
     * <p>
     * The version number of the scaling plan. Currently, the only valid value is <code>1</code>.
     * </p>
     * 
     * @return The version number of the scaling plan. Currently, the only valid value is <code>1</code>.
     */
    public final Long scalingPlanVersion() {
        return scalingPlanVersion;
    }

    /**
     * <p>
     * The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNamespace}
     * will return {@link ServiceNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceNamespaceAsString}.
     * </p>
     * 
     * @return The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
     * @see ServiceNamespace
     */
    public final ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(serviceNamespace);
    }

    /**
     * <p>
     * The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNamespace}
     * will return {@link ServiceNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceNamespaceAsString}.
     * </p>
     * 
     * @return The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
     * @see ServiceNamespace
     */
    public final String serviceNamespaceAsString() {
        return serviceNamespace;
    }

    /**
     * <p>
     * The ID of the resource. This string consists of a prefix (<code>autoScalingGroup</code>) followed by the name of
     * a specified Auto Scaling group (<code>my-asg</code>). Example: <code>autoScalingGroup/my-asg</code>.
     * </p>
     * 
     * @return The ID of the resource. This string consists of a prefix (<code>autoScalingGroup</code>) followed by the
     *         name of a specified Auto Scaling group (<code>my-asg</code>). Example:
     *         <code>autoScalingGroup/my-asg</code>.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The scalable dimension for the resource. The only valid value is
     * <code>autoscaling:autoScalingGroup:DesiredCapacity</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalableDimension}
     * will return {@link ScalableDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalableDimensionAsString}.
     * </p>
     * 
     * @return The scalable dimension for the resource. The only valid value is
     *         <code>autoscaling:autoScalingGroup:DesiredCapacity</code>.
     * @see ScalableDimension
     */
    public final ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(scalableDimension);
    }

    /**
     * <p>
     * The scalable dimension for the resource. The only valid value is
     * <code>autoscaling:autoScalingGroup:DesiredCapacity</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalableDimension}
     * will return {@link ScalableDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalableDimensionAsString}.
     * </p>
     * 
     * @return The scalable dimension for the resource. The only valid value is
     *         <code>autoscaling:autoScalingGroup:DesiredCapacity</code>.
     * @see ScalableDimension
     */
    public final String scalableDimensionAsString() {
        return scalableDimension;
    }

    /**
     * <p>
     * The type of forecast data to get.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LoadForecast</code>: The load metric forecast.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CapacityForecast</code>: The capacity forecast.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This data is
     * calculated as the larger of two values: the capacity forecast or the minimum capacity in the scaling instruction.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The calculation
     * used is determined by the predictive scaling maximum capacity behavior setting in the scaling instruction.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #forecastDataType}
     * will return {@link ForecastDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #forecastDataTypeAsString}.
     * </p>
     * 
     * @return The type of forecast data to get.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LoadForecast</code>: The load metric forecast.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CapacityForecast</code>: The capacity forecast.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This
     *         data is calculated as the larger of two values: the capacity forecast or the minimum capacity in the
     *         scaling instruction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The
     *         calculation used is determined by the predictive scaling maximum capacity behavior setting in the scaling
     *         instruction.
     *         </p>
     *         </li>
     * @see ForecastDataType
     */
    public final ForecastDataType forecastDataType() {
        return ForecastDataType.fromValue(forecastDataType);
    }

    /**
     * <p>
     * The type of forecast data to get.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LoadForecast</code>: The load metric forecast.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CapacityForecast</code>: The capacity forecast.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This data is
     * calculated as the larger of two values: the capacity forecast or the minimum capacity in the scaling instruction.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The calculation
     * used is determined by the predictive scaling maximum capacity behavior setting in the scaling instruction.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #forecastDataType}
     * will return {@link ForecastDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #forecastDataTypeAsString}.
     * </p>
     * 
     * @return The type of forecast data to get.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LoadForecast</code>: The load metric forecast.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CapacityForecast</code>: The capacity forecast.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This
     *         data is calculated as the larger of two values: the capacity forecast or the minimum capacity in the
     *         scaling instruction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The
     *         calculation used is determined by the predictive scaling maximum capacity behavior setting in the scaling
     *         instruction.
     *         </p>
     *         </li>
     * @see ForecastDataType
     */
    public final String forecastDataTypeAsString() {
        return forecastDataType;
    }

    /**
     * <p>
     * The inclusive start time of the time range for the forecast data to get. The date and time can be at most 56 days
     * before the current date and time.
     * </p>
     * 
     * @return The inclusive start time of the time range for the forecast data to get. The date and time can be at most
     *         56 days before the current date and time.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The exclusive end time of the time range for the forecast data to get. The maximum time duration between the
     * start and end time is seven days.
     * </p>
     * <p>
     * Although this parameter can accept a date and time that is more than two days in the future, the availability of
     * forecast data has limits. AWS Auto Scaling only issues forecasts for periods of two days in advance.
     * </p>
     * 
     * @return The exclusive end time of the time range for the forecast data to get. The maximum time duration between
     *         the start and end time is seven days. </p>
     *         <p>
     *         Although this parameter can accept a date and time that is more than two days in the future, the
     *         availability of forecast data has limits. AWS Auto Scaling only issues forecasts for periods of two days
     *         in advance.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scalingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingPlanVersion());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(forecastDataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScalingPlanResourceForecastDataRequest)) {
            return false;
        }
        GetScalingPlanResourceForecastDataRequest other = (GetScalingPlanResourceForecastDataRequest) obj;
        return Objects.equals(scalingPlanName(), other.scalingPlanName())
                && Objects.equals(scalingPlanVersion(), other.scalingPlanVersion())
                && Objects.equals(serviceNamespaceAsString(), other.serviceNamespaceAsString())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(scalableDimensionAsString(), other.scalableDimensionAsString())
                && Objects.equals(forecastDataTypeAsString(), other.forecastDataTypeAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetScalingPlanResourceForecastDataRequest").add("ScalingPlanName", scalingPlanName())
                .add("ScalingPlanVersion", scalingPlanVersion()).add("ServiceNamespace", serviceNamespaceAsString())
                .add("ResourceId", resourceId()).add("ScalableDimension", scalableDimensionAsString())
                .add("ForecastDataType", forecastDataTypeAsString()).add("StartTime", startTime()).add("EndTime", endTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalingPlanName":
            return Optional.ofNullable(clazz.cast(scalingPlanName()));
        case "ScalingPlanVersion":
            return Optional.ofNullable(clazz.cast(scalingPlanVersion()));
        case "ServiceNamespace":
            return Optional.ofNullable(clazz.cast(serviceNamespaceAsString()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ScalableDimension":
            return Optional.ofNullable(clazz.cast(scalableDimensionAsString()));
        case "ForecastDataType":
            return Optional.ofNullable(clazz.cast(forecastDataTypeAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetScalingPlanResourceForecastDataRequest, T> g) {
        return obj -> g.apply((GetScalingPlanResourceForecastDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingPlansRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetScalingPlanResourceForecastDataRequest> {
        /**
         * <p>
         * The name of the scaling plan.
         * </p>
         * 
         * @param scalingPlanName
         *        The name of the scaling plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanName(String scalingPlanName);

        /**
         * <p>
         * The version number of the scaling plan. Currently, the only valid value is <code>1</code>.
         * </p>
         * 
         * @param scalingPlanVersion
         *        The version number of the scaling plan. Currently, the only valid value is <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPlanVersion(Long scalingPlanVersion);

        /**
         * <p>
         * The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
         * @see ServiceNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNamespace
         */
        Builder serviceNamespace(String serviceNamespace);

        /**
         * <p>
         * The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the AWS service. The only valid value is <code>autoscaling</code>.
         * @see ServiceNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNamespace
         */
        Builder serviceNamespace(ServiceNamespace serviceNamespace);

        /**
         * <p>
         * The ID of the resource. This string consists of a prefix (<code>autoScalingGroup</code>) followed by the name
         * of a specified Auto Scaling group (<code>my-asg</code>). Example: <code>autoScalingGroup/my-asg</code>.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource. This string consists of a prefix (<code>autoScalingGroup</code>) followed by
         *        the name of a specified Auto Scaling group (<code>my-asg</code>). Example:
         *        <code>autoScalingGroup/my-asg</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The scalable dimension for the resource. The only valid value is
         * <code>autoscaling:autoScalingGroup:DesiredCapacity</code>.
         * </p>
         * 
         * @param scalableDimension
         *        The scalable dimension for the resource. The only valid value is
         *        <code>autoscaling:autoScalingGroup:DesiredCapacity</code>.
         * @see ScalableDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalableDimension
         */
        Builder scalableDimension(String scalableDimension);

        /**
         * <p>
         * The scalable dimension for the resource. The only valid value is
         * <code>autoscaling:autoScalingGroup:DesiredCapacity</code>.
         * </p>
         * 
         * @param scalableDimension
         *        The scalable dimension for the resource. The only valid value is
         *        <code>autoscaling:autoScalingGroup:DesiredCapacity</code>.
         * @see ScalableDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalableDimension
         */
        Builder scalableDimension(ScalableDimension scalableDimension);

        /**
         * <p>
         * The type of forecast data to get.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LoadForecast</code>: The load metric forecast.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityForecast</code>: The capacity forecast.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This data is
         * calculated as the larger of two values: the capacity forecast or the minimum capacity in the scaling
         * instruction.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The
         * calculation used is determined by the predictive scaling maximum capacity behavior setting in the scaling
         * instruction.
         * </p>
         * </li>
         * </ul>
         * 
         * @param forecastDataType
         *        The type of forecast data to get.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LoadForecast</code>: The load metric forecast.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CapacityForecast</code>: The capacity forecast.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This
         *        data is calculated as the larger of two values: the capacity forecast or the minimum capacity in the
         *        scaling instruction.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The
         *        calculation used is determined by the predictive scaling maximum capacity behavior setting in the
         *        scaling instruction.
         *        </p>
         *        </li>
         * @see ForecastDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForecastDataType
         */
        Builder forecastDataType(String forecastDataType);

        /**
         * <p>
         * The type of forecast data to get.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LoadForecast</code>: The load metric forecast.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityForecast</code>: The capacity forecast.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This data is
         * calculated as the larger of two values: the capacity forecast or the minimum capacity in the scaling
         * instruction.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The
         * calculation used is determined by the predictive scaling maximum capacity behavior setting in the scaling
         * instruction.
         * </p>
         * </li>
         * </ul>
         * 
         * @param forecastDataType
         *        The type of forecast data to get.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LoadForecast</code>: The load metric forecast.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CapacityForecast</code>: The capacity forecast.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActionMinCapacity</code>: The minimum capacity for each scheduled scaling action. This
         *        data is calculated as the larger of two values: the capacity forecast or the minimum capacity in the
         *        scaling instruction.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActionMaxCapacity</code>: The maximum capacity for each scheduled scaling action. The
         *        calculation used is determined by the predictive scaling maximum capacity behavior setting in the
         *        scaling instruction.
         *        </p>
         *        </li>
         * @see ForecastDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForecastDataType
         */
        Builder forecastDataType(ForecastDataType forecastDataType);

        /**
         * <p>
         * The inclusive start time of the time range for the forecast data to get. The date and time can be at most 56
         * days before the current date and time.
         * </p>
         * 
         * @param startTime
         *        The inclusive start time of the time range for the forecast data to get. The date and time can be at
         *        most 56 days before the current date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The exclusive end time of the time range for the forecast data to get. The maximum time duration between the
         * start and end time is seven days.
         * </p>
         * <p>
         * Although this parameter can accept a date and time that is more than two days in the future, the availability
         * of forecast data has limits. AWS Auto Scaling only issues forecasts for periods of two days in advance.
         * </p>
         * 
         * @param endTime
         *        The exclusive end time of the time range for the forecast data to get. The maximum time duration
         *        between the start and end time is seven days. </p>
         *        <p>
         *        Although this parameter can accept a date and time that is more than two days in the future, the
         *        availability of forecast data has limits. AWS Auto Scaling only issues forecasts for periods of two
         *        days in advance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingPlansRequest.BuilderImpl implements Builder {
        private String scalingPlanName;

        private Long scalingPlanVersion;

        private String serviceNamespace;

        private String resourceId;

        private String scalableDimension;

        private String forecastDataType;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScalingPlanResourceForecastDataRequest model) {
            super(model);
            scalingPlanName(model.scalingPlanName);
            scalingPlanVersion(model.scalingPlanVersion);
            serviceNamespace(model.serviceNamespace);
            resourceId(model.resourceId);
            scalableDimension(model.scalableDimension);
            forecastDataType(model.forecastDataType);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getScalingPlanName() {
            return scalingPlanName;
        }

        public final void setScalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
        }

        @Override
        @Transient
        public final Builder scalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
            return this;
        }

        public final Long getScalingPlanVersion() {
            return scalingPlanVersion;
        }

        public final void setScalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
        }

        @Override
        @Transient
        public final Builder scalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
            return this;
        }

        public final String getServiceNamespace() {
            return serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        @Transient
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        @Transient
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        @Transient
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getScalableDimension() {
            return scalableDimension;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        @Override
        @Transient
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        @Transient
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final String getForecastDataType() {
            return forecastDataType;
        }

        public final void setForecastDataType(String forecastDataType) {
            this.forecastDataType = forecastDataType;
        }

        @Override
        @Transient
        public final Builder forecastDataType(String forecastDataType) {
            this.forecastDataType = forecastDataType;
            return this;
        }

        @Override
        @Transient
        public final Builder forecastDataType(ForecastDataType forecastDataType) {
            this.forecastDataType(forecastDataType == null ? null : forecastDataType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetScalingPlanResourceForecastDataRequest build() {
            return new GetScalingPlanResourceForecastDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
