/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.autoscalingplans.AutoScalingPlansClient;
import software.amazon.awssdk.services.autoscalingplans.AutoScalingPlansClientBuilder;
import software.amazon.awssdk.services.autoscalingplans.AutoScalingPlansServiceClientConfiguration;
import software.amazon.awssdk.services.autoscalingplans.DefaultAutoScalingPlansBaseClientBuilder;
import software.amazon.awssdk.services.autoscalingplans.DefaultAutoScalingPlansClient;
import software.amazon.awssdk.services.autoscalingplans.endpoints.AutoScalingPlansEndpointProvider;

@SdkInternalApi
final class DefaultAutoScalingPlansClientBuilder
extends DefaultAutoScalingPlansBaseClientBuilder<AutoScalingPlansClientBuilder, AutoScalingPlansClient>
implements AutoScalingPlansClientBuilder {
    DefaultAutoScalingPlansClientBuilder() {
    }

    @Override
    public DefaultAutoScalingPlansClientBuilder endpointProvider(AutoScalingPlansEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AutoScalingPlansClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAutoScalingPlansClientBuilder.validateClientOptions(clientConfiguration);
        AutoScalingPlansServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAutoScalingPlansClient client = new DefaultAutoScalingPlansClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AutoScalingPlansServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AutoScalingPlansServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

