/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a predefined metric that can be used for predictive scaling.
 * </p>
 * <p>
 * After creating your scaling plan, you can use the AWS Auto Scaling console to visualize forecasts for the specified
 * metric. For more information, see <a
 * href="https://docs.aws.amazon.com/autoscaling/plans/userguide/gs-create-scaling-plan.html#gs-view-resource">View
 * Scaling Information for a Resource</a> in the <i>AWS Auto Scaling User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredefinedLoadMetricSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PredefinedLoadMetricSpecification.Builder, PredefinedLoadMetricSpecification> {
    private static final SdkField<String> PREDEFINED_LOAD_METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredefinedLoadMetricType")
            .getter(getter(PredefinedLoadMetricSpecification::predefinedLoadMetricTypeAsString))
            .setter(setter(Builder::predefinedLoadMetricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedLoadMetricType").build())
            .build();

    private static final SdkField<String> RESOURCE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceLabel").getter(getter(PredefinedLoadMetricSpecification::resourceLabel))
            .setter(setter(Builder::resourceLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREDEFINED_LOAD_METRIC_TYPE_FIELD, RESOURCE_LABEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String predefinedLoadMetricType;

    private final String resourceLabel;

    private PredefinedLoadMetricSpecification(BuilderImpl builder) {
        this.predefinedLoadMetricType = builder.predefinedLoadMetricType;
        this.resourceLabel = builder.resourceLabel;
    }

    /**
     * <p>
     * The metric type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #predefinedLoadMetricType} will return {@link LoadMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #predefinedLoadMetricTypeAsString}.
     * </p>
     * 
     * @return The metric type.
     * @see LoadMetricType
     */
    public final LoadMetricType predefinedLoadMetricType() {
        return LoadMetricType.fromValue(predefinedLoadMetricType);
    }

    /**
     * <p>
     * The metric type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #predefinedLoadMetricType} will return {@link LoadMetricType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #predefinedLoadMetricTypeAsString}.
     * </p>
     * 
     * @return The metric type.
     * @see LoadMetricType
     */
    public final String predefinedLoadMetricTypeAsString() {
        return predefinedLoadMetricType;
    }

    /**
     * <p>
     * Identifies the resource associated with the metric type. You can't specify a resource label unless the metric
     * type is <code>ALBTargetGroupRequestCount</code> and there is a target group for an Application Load Balancer
     * attached to the Auto Scaling group.
     * </p>
     * <p>
     * You create the resource label by appending the final portion of the load balancer ARN and the final portion of
     * the target group ARN into a single value, separated by a forward slash (/). The format is
     * app/&lt;load-balancer-name
     * &gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt;, where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
     * </p>
     * </li>
     * <li>
     * <p>
     * targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This is an example:
     * app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
     * </p>
     * <p>
     * To find the ARN for an Application Load Balancer, use the <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
     * >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
     * >DescribeTargetGroups</a> API operation.
     * </p>
     * 
     * @return Identifies the resource associated with the metric type. You can't specify a resource label unless the
     *         metric type is <code>ALBTargetGroupRequestCount</code> and there is a target group for an Application
     *         Load Balancer attached to the Auto Scaling group.</p>
     *         <p>
     *         You create the resource label by appending the final portion of the load balancer ARN and the final
     *         portion of the target group ARN into a single value, separated by a forward slash (/). The format is
     *         app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target-
     *         group-id&gt;, where:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group
     *         ARN.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This is an example:
     *         app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
     *         </p>
     *         <p>
     *         To find the ARN for an Application Load Balancer, use the <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
     *         >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
     *         >DescribeTargetGroups</a> API operation.
     */
    public final String resourceLabel() {
        return resourceLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedLoadMetricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedLoadMetricSpecification)) {
            return false;
        }
        PredefinedLoadMetricSpecification other = (PredefinedLoadMetricSpecification) obj;
        return Objects.equals(predefinedLoadMetricTypeAsString(), other.predefinedLoadMetricTypeAsString())
                && Objects.equals(resourceLabel(), other.resourceLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredefinedLoadMetricSpecification")
                .add("PredefinedLoadMetricType", predefinedLoadMetricTypeAsString()).add("ResourceLabel", resourceLabel())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredefinedLoadMetricType":
            return Optional.ofNullable(clazz.cast(predefinedLoadMetricTypeAsString()));
        case "ResourceLabel":
            return Optional.ofNullable(clazz.cast(resourceLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PredefinedLoadMetricType", PREDEFINED_LOAD_METRIC_TYPE_FIELD);
        map.put("ResourceLabel", RESOURCE_LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredefinedLoadMetricSpecification, T> g) {
        return obj -> g.apply((PredefinedLoadMetricSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredefinedLoadMetricSpecification> {
        /**
         * <p>
         * The metric type.
         * </p>
         * 
         * @param predefinedLoadMetricType
         *        The metric type.
         * @see LoadMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadMetricType
         */
        Builder predefinedLoadMetricType(String predefinedLoadMetricType);

        /**
         * <p>
         * The metric type.
         * </p>
         * 
         * @param predefinedLoadMetricType
         *        The metric type.
         * @see LoadMetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadMetricType
         */
        Builder predefinedLoadMetricType(LoadMetricType predefinedLoadMetricType);

        /**
         * <p>
         * Identifies the resource associated with the metric type. You can't specify a resource label unless the metric
         * type is <code>ALBTargetGroupRequestCount</code> and there is a target group for an Application Load Balancer
         * attached to the Auto Scaling group.
         * </p>
         * <p>
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion
         * of the target group ARN into a single value, separated by a forward slash (/). The format is
         * app/&lt;load-balancer
         * -name&gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt;, where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
         * </p>
         * </li>
         * <li>
         * <p>
         * targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This is an example:
         * app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         * </p>
         * <p>
         * To find the ARN for an Application Load Balancer, use the <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
         * >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
         * >DescribeTargetGroups</a> API operation.
         * </p>
         * 
         * @param resourceLabel
         *        Identifies the resource associated with the metric type. You can't specify a resource label unless the
         *        metric type is <code>ALBTargetGroupRequestCount</code> and there is a target group for an Application
         *        Load Balancer attached to the Auto Scaling group.</p>
         *        <p>
         *        You create the resource label by appending the final portion of the load balancer ARN and the final
         *        portion of the target group ARN into a single value, separated by a forward slash (/). The format is
         *        app
         *        /&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt;/targetgroup/&lt;target-group-name&gt;/&lt;target
         *        -group-id&gt;, where:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group
         *        ARN.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This is an example:
         *        app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defau-LDNM7Q3ZH1ZN/6d4ea56ca2d6a18d.
         *        </p>
         *        <p>
         *        To find the ARN for an Application Load Balancer, use the <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
         *        >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
         *        >DescribeTargetGroups</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLabel(String resourceLabel);
    }

    static final class BuilderImpl implements Builder {
        private String predefinedLoadMetricType;

        private String resourceLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedLoadMetricSpecification model) {
            predefinedLoadMetricType(model.predefinedLoadMetricType);
            resourceLabel(model.resourceLabel);
        }

        public final String getPredefinedLoadMetricType() {
            return predefinedLoadMetricType;
        }

        public final void setPredefinedLoadMetricType(String predefinedLoadMetricType) {
            this.predefinedLoadMetricType = predefinedLoadMetricType;
        }

        @Override
        public final Builder predefinedLoadMetricType(String predefinedLoadMetricType) {
            this.predefinedLoadMetricType = predefinedLoadMetricType;
            return this;
        }

        @Override
        public final Builder predefinedLoadMetricType(LoadMetricType predefinedLoadMetricType) {
            this.predefinedLoadMetricType(predefinedLoadMetricType == null ? null : predefinedLoadMetricType.toString());
            return this;
        }

        public final String getResourceLabel() {
            return resourceLabel;
        }

        public final void setResourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
        }

        @Override
        public final Builder resourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
            return this;
        }

        @Override
        public PredefinedLoadMetricSpecification build() {
            return new PredefinedLoadMetricSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
