/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a scaling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingPolicy implements SdkPojo, Serializable, ToCopyableBuilder<ScalingPolicy.Builder, ScalingPolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(ScalingPolicy::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyType").getter(getter(ScalingPolicy::policyTypeAsString)).setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()).build();

    private static final SdkField<TargetTrackingConfiguration> TARGET_TRACKING_CONFIGURATION_FIELD = SdkField
            .<TargetTrackingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TargetTrackingConfiguration")
            .getter(getter(ScalingPolicy::targetTrackingConfiguration))
            .setter(setter(Builder::targetTrackingConfiguration))
            .constructor(TargetTrackingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            POLICY_TYPE_FIELD, TARGET_TRACKING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyName;

    private final String policyType;

    private final TargetTrackingConfiguration targetTrackingConfiguration;

    private ScalingPolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyType = builder.policyType;
        this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
    }

    /**
     * <p>
     * The name of the scaling policy.
     * </p>
     * 
     * @return The name of the scaling policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The type of scaling policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of scaling policy.
     * @see PolicyType
     */
    public final PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of scaling policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of scaling policy.
     * @see PolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * The target tracking scaling policy. Includes support for predefined or customized metrics.
     * </p>
     * 
     * @return The target tracking scaling policy. Includes support for predefined or customized metrics.
     */
    public final TargetTrackingConfiguration targetTrackingConfiguration() {
        return targetTrackingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetTrackingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy) obj;
        return Objects.equals(policyName(), other.policyName())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(targetTrackingConfiguration(), other.targetTrackingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingPolicy").add("PolicyName", policyName()).add("PolicyType", policyTypeAsString())
                .add("TargetTrackingConfiguration", targetTrackingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "TargetTrackingConfiguration":
            return Optional.ofNullable(clazz.cast(targetTrackingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyName", POLICY_NAME_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("TargetTrackingConfiguration", TARGET_TRACKING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicy, T> g) {
        return obj -> g.apply((ScalingPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingPolicy> {
        /**
         * <p>
         * The name of the scaling policy.
         * </p>
         * 
         * @param policyName
         *        The name of the scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The type of scaling policy.
         * </p>
         * 
         * @param policyType
         *        The type of scaling policy.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of scaling policy.
         * </p>
         * 
         * @param policyType
         *        The type of scaling policy.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * <p>
         * The target tracking scaling policy. Includes support for predefined or customized metrics.
         * </p>
         * 
         * @param targetTrackingConfiguration
         *        The target tracking scaling policy. Includes support for predefined or customized metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration);

        /**
         * <p>
         * The target tracking scaling policy. Includes support for predefined or customized metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetTrackingConfiguration.Builder}
         * avoiding the need to create one manually via {@link TargetTrackingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetTrackingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #targetTrackingConfiguration(TargetTrackingConfiguration)}.
         * 
         * @param targetTrackingConfiguration
         *        a consumer that will call methods on {@link TargetTrackingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTrackingConfiguration(TargetTrackingConfiguration)
         */
        default Builder targetTrackingConfiguration(Consumer<TargetTrackingConfiguration.Builder> targetTrackingConfiguration) {
            return targetTrackingConfiguration(TargetTrackingConfiguration.builder().applyMutation(targetTrackingConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private String policyType;

        private TargetTrackingConfiguration targetTrackingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            policyName(model.policyName);
            policyType(model.policyType);
            targetTrackingConfiguration(model.targetTrackingConfiguration);
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final TargetTrackingConfiguration.Builder getTargetTrackingConfiguration() {
            return targetTrackingConfiguration != null ? targetTrackingConfiguration.toBuilder() : null;
        }

        public final void setTargetTrackingConfiguration(TargetTrackingConfiguration.BuilderImpl targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration != null ? targetTrackingConfiguration.build() : null;
        }

        @Override
        public final Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        @Override
        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
