/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.request;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.crt.internal.CrtRequestContext;
import software.amazon.awssdk.http.crt.internal.request.CrtRequestBodyAdapter;

@SdkInternalApi
public final class CrtRequestAdapter {
    private CrtRequestAdapter() {
    }

    public static HttpRequest toCrtRequest(CrtRequestContext request) {
        AsyncExecuteRequest sdkExecuteRequest = request.sdkRequest();
        SdkHttpRequest sdkRequest = sdkExecuteRequest.request();
        String method = sdkRequest.method().name();
        String encodedPath = sdkRequest.encodedPath();
        if (encodedPath == null || encodedPath.isEmpty()) {
            encodedPath = "/";
        }
        String encodedQueryString = sdkRequest.encodedQueryParameters().map(value -> "?" + value).orElse("");
        HttpHeader[] crtHeaderArray = CrtRequestAdapter.asArray(CrtRequestAdapter.createHttpHeaderList(sdkRequest.getUri(), sdkExecuteRequest));
        return new HttpRequest(method, encodedPath + encodedQueryString, crtHeaderArray, (HttpRequestBodyStream)new CrtRequestBodyAdapter(sdkExecuteRequest.requestContentPublisher(), request.readBufferSize()));
    }

    private static HttpHeader[] asArray(List<HttpHeader> crtHeaderList) {
        return crtHeaderList.toArray(new HttpHeader[0]);
    }

    private static List<HttpHeader> createHttpHeaderList(URI uri, AsyncExecuteRequest sdkExecuteRequest) {
        SdkHttpRequest sdkRequest = sdkExecuteRequest.request();
        ArrayList<HttpHeader> crtHeaderList = new ArrayList<HttpHeader>(sdkRequest.numHeaders() + 3);
        if (!sdkRequest.firstMatchingHeader("Host").isPresent()) {
            crtHeaderList.add(new HttpHeader("Host", uri.getHost()));
        }
        if (!sdkRequest.firstMatchingHeader("Connection").isPresent()) {
            crtHeaderList.add(new HttpHeader("Connection", "keep-alive"));
        }
        Optional contentLength = sdkExecuteRequest.requestContentPublisher().contentLength();
        if (!sdkRequest.firstMatchingHeader("Content-Length").isPresent() && contentLength.isPresent()) {
            crtHeaderList.add(new HttpHeader("Content-Length", Long.toString((Long)contentLength.get())));
        }
        sdkRequest.forEachHeader((key, value) -> value.stream().map(val -> new HttpHeader(key, val)).forEach(crtHeaderList::add));
        return crtHeaderList;
    }
}

