/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.response;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.Abortable;
import software.amazon.awssdk.utils.async.InputStreamSubscriber;

@SdkInternalApi
public final class AbortableInputStreamSubscriber
extends InputStream
implements Subscriber<ByteBuffer>,
Abortable {
    private final InputStreamSubscriber delegate;
    private final Runnable closeConnection;

    public AbortableInputStreamSubscriber(Runnable onClose, InputStreamSubscriber inputStreamSubscriber) {
        this.delegate = inputStreamSubscriber;
        this.closeConnection = onClose;
    }

    public void abort() {
        this.close();
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.delegate.read(b);
    }

    public void onSubscribe(Subscription s) {
        this.delegate.onSubscribe(s);
    }

    public void onNext(ByteBuffer byteBuffer) {
        this.delegate.onNext(byteBuffer);
    }

    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    public void onComplete() {
        this.delegate.onComplete();
    }

    @Override
    public void close() {
        this.closeConnection.run();
        this.delegate.close();
    }
}

