/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal.response;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpHeaderBlock;
import software.amazon.awssdk.crt.http.HttpStream;
import software.amazon.awssdk.crt.http.HttpStreamResponseHandler;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AbortableInputStreamSubscriber;
import software.amazon.awssdk.http.crt.internal.CrtUtils;
import software.amazon.awssdk.http.crt.internal.response.ResponseHandlerHelper;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.async.SimplePublisher;

@SdkInternalApi
public final class InputStreamAdaptingHttpStreamResponseHandler
implements HttpStreamResponseHandler {
    private static final Logger log = Logger.loggerFor(InputStreamAdaptingHttpStreamResponseHandler.class);
    private volatile AbortableInputStreamSubscriber inputStreamSubscriber;
    private final SimplePublisher<ByteBuffer> simplePublisher;
    private final CompletableFuture<SdkHttpFullResponse> requestCompletionFuture;
    private final HttpClientConnection crtConn;
    private final SdkHttpFullResponse.Builder responseBuilder;
    private final ResponseHandlerHelper responseHandlerHelper;

    public InputStreamAdaptingHttpStreamResponseHandler(HttpClientConnection crtConn, CompletableFuture<SdkHttpFullResponse> requestCompletionFuture) {
        this(crtConn, requestCompletionFuture, (SimplePublisher<ByteBuffer>)new SimplePublisher());
    }

    @SdkTestInternalApi
    public InputStreamAdaptingHttpStreamResponseHandler(HttpClientConnection crtConn, CompletableFuture<SdkHttpFullResponse> requestCompletionFuture, SimplePublisher<ByteBuffer> simplePublisher) {
        this.crtConn = crtConn;
        this.requestCompletionFuture = requestCompletionFuture;
        this.responseBuilder = SdkHttpResponse.builder();
        this.responseHandlerHelper = new ResponseHandlerHelper((SdkHttpResponse.Builder)this.responseBuilder, crtConn);
        this.simplePublisher = simplePublisher;
    }

    public void onResponseHeaders(HttpStream stream, int responseStatusCode, int blockType, HttpHeader[] nextHeaders) {
        if (blockType == HttpHeaderBlock.MAIN.getValue()) {
            for (HttpHeader h : nextHeaders) {
                this.responseBuilder.appendHeader(h.getName(), h.getValue());
            }
            this.responseBuilder.statusCode(responseStatusCode);
        }
        this.requestCompletionFuture.exceptionally(t -> {
            this.responseHandlerHelper.closeConnection(stream);
            return null;
        });
    }

    public int onResponseBody(HttpStream stream, byte[] bodyBytesIn) {
        CompletableFuture writeFuture;
        if (this.inputStreamSubscriber == null) {
            this.inputStreamSubscriber = AbortableInputStreamSubscriber.builder().doAfterClose(() -> this.responseHandlerHelper.closeConnection(stream)).build();
            this.simplePublisher.subscribe((Subscriber)this.inputStreamSubscriber);
            this.responseBuilder.content(AbortableInputStream.create((InputStream)this.inputStreamSubscriber));
            this.requestCompletionFuture.complete(this.responseBuilder.build());
        }
        if ((writeFuture = this.simplePublisher.send((Object)ByteBuffer.wrap(bodyBytesIn))).isDone() && !writeFuture.isCompletedExceptionally()) {
            return bodyBytesIn.length;
        }
        writeFuture.whenComplete((result, failure) -> {
            if (failure != null) {
                log.debug(() -> "The subscriber failed to receive the data, closing the connection and failing the future", failure);
                this.failFutureAndCloseConnection(stream, (Throwable)failure);
                return;
            }
            this.responseHandlerHelper.incrementWindow(stream, bodyBytesIn.length);
        });
        return 0;
    }

    public void onResponseComplete(HttpStream stream, int errorCode) {
        if (errorCode == 0) {
            this.onSuccessfulResponseComplete(stream);
        } else {
            this.onFailedResponseComplete(stream, errorCode);
        }
    }

    private void failFutureAndCloseConnection(HttpStream stream, Throwable failure) {
        this.requestCompletionFuture.completeExceptionally(failure);
        this.responseHandlerHelper.closeConnection(stream);
    }

    private void onFailedResponseComplete(HttpStream stream, int errorCode) {
        Throwable toThrow = CrtUtils.wrapWithIoExceptionIfRetryable(new HttpException(errorCode));
        this.simplePublisher.error(toThrow);
        this.failFutureAndCloseConnection(stream, toThrow);
    }

    private void onSuccessfulResponseComplete(HttpStream stream) {
        this.requestCompletionFuture.complete(this.responseBuilder.build());
        this.simplePublisher.complete();
        this.responseHandlerHelper.cleanUpConnectionBasedOnStatusCode(stream);
    }
}

