/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.ion;

import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.protocols.ion.internal.AwsStructuredIonFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.DefaultJsonContentTypeResolver;
import software.amazon.awssdk.protocols.json.JsonContentTypeResolver;
import software.amazon.awssdk.protocols.json.StructuredJsonFactory;

@SdkProtectedApi
public final class AwsIonProtocolFactory
extends BaseAwsJsonProtocolFactory {
    private static final JsonContentTypeResolver ION_BINARY = new DefaultJsonContentTypeResolver("application/x-amz-ion-");
    private static final JsonContentTypeResolver ION_TEXT = new DefaultJsonContentTypeResolver("text/x-amz-ion-");

    private AwsIonProtocolFactory(Builder builder) {
        super((BaseAwsJsonProtocolFactory.Builder)builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected JsonContentTypeResolver getContentTypeResolver() {
        return this.isIonBinaryEnabled() ? ION_BINARY : ION_TEXT;
    }

    protected StructuredJsonFactory getSdkFactory() {
        return this.isIonBinaryEnabled() ? AwsStructuredIonFactory.SDK_ION_BINARY_FACTORY : AwsStructuredIonFactory.SDK_ION_TEXT_FACTORY;
    }

    private boolean isIonBinaryEnabled() {
        return SdkSystemSetting.BINARY_ION_ENABLED.getBooleanValueOrThrow();
    }

    public static final class Builder
    extends BaseAwsJsonProtocolFactory.Builder<Builder> {
        private Builder() {
        }

        public AwsIonProtocolFactory build() {
            return new AwsIonProtocolFactory(this);
        }
    }
}

