/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.ion.internal;

import com.fasterxml.jackson.core.JsonFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.ion.internal.CompositeErrorCodeParser;
import software.amazon.awssdk.protocols.ion.internal.IonErrorCodeParser;
import software.amazon.awssdk.protocols.ion.internal.SdkStructuredIonFactory;
import software.amazon.awssdk.protocols.json.BaseAwsStructuredJsonFactory;
import software.amazon.awssdk.protocols.json.ErrorCodeParser;
import software.amazon.awssdk.protocols.json.StructuredJsonGenerator;
import software.amazon.ion.system.IonBinaryWriterBuilder;
import software.amazon.ion.system.IonTextWriterBuilder;
import software.amazon.ion.system.IonWriterBuilder;

@SdkInternalApi
public final class AwsStructuredIonFactory
extends SdkStructuredIonFactory {
    private static final IonWriterBuilder BINARY_WRITER_BUILDER = IonBinaryWriterBuilder.standard().immutable();
    private static final IonWriterBuilder TEXT_WRITER_BUILDER = IonTextWriterBuilder.standard().immutable();
    public static final BaseAwsStructuredJsonFactory SDK_ION_BINARY_FACTORY = new AwsIonFactory(JSON_FACTORY, BINARY_WRITER_BUILDER);
    public static final BaseAwsStructuredJsonFactory SDK_ION_TEXT_FACTORY = new AwsIonFactory(JSON_FACTORY, TEXT_WRITER_BUILDER);

    static class AwsIonFactory
    extends BaseAwsStructuredJsonFactory {
        private final JsonFactory jsonFactory;
        private final IonWriterBuilder builder;

        AwsIonFactory(JsonFactory jsonFactory, IonWriterBuilder builder) {
            super(jsonFactory);
            this.jsonFactory = jsonFactory;
            this.builder = builder;
        }

        protected StructuredJsonGenerator createWriter(JsonFactory jsonFactory, String contentType) {
            return SdkStructuredIonFactory.ION_GENERATOR_SUPPLIER.apply(this.builder, contentType);
        }

        public JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public ErrorCodeParser getErrorCodeParser(String customErrorCodeFieldName) {
            return new CompositeErrorCodeParser(new IonErrorCodeParser(SdkStructuredIonFactory.ION_SYSTEM), super.getErrorCodeParser(customErrorCodeFieldName));
        }
    }
}

