/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.json.internal.unmarshall;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.protocols.core.StringToValueConverter;
import software.amazon.awssdk.protocols.json.internal.dom.SdkJsonNode;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonProtocolUnmarshaller;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshaller;
import software.amazon.awssdk.protocols.json.internal.unmarshall.JsonUnmarshallerContext;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkInternalApi
final class HeaderUnmarshaller {
    public static final JsonUnmarshaller<String> STRING = new SimpleHeaderUnmarshaller<String>(HeaderUnmarshaller::unmarshallStringHeader);
    public static final JsonUnmarshaller<Integer> INTEGER = new SimpleHeaderUnmarshaller<Integer>((StringToValueConverter.StringToValue)StringToValueConverter.TO_INTEGER);
    public static final JsonUnmarshaller<Long> LONG = new SimpleHeaderUnmarshaller<Long>((StringToValueConverter.StringToValue)StringToValueConverter.TO_LONG);
    public static final JsonUnmarshaller<Double> DOUBLE = new SimpleHeaderUnmarshaller<Double>((StringToValueConverter.StringToValue)StringToValueConverter.TO_DOUBLE);
    public static final JsonUnmarshaller<Boolean> BOOLEAN = new SimpleHeaderUnmarshaller<Boolean>((StringToValueConverter.StringToValue)StringToValueConverter.TO_BOOLEAN);
    public static final JsonUnmarshaller<Instant> INSTANT = new SimpleHeaderUnmarshaller<Instant>(JsonProtocolUnmarshaller.INSTANT_STRING_TO_VALUE);
    public static final JsonUnmarshaller<Float> FLOAT = new SimpleHeaderUnmarshaller<Float>((StringToValueConverter.StringToValue)StringToValueConverter.TO_FLOAT);

    private HeaderUnmarshaller() {
    }

    private static String unmarshallStringHeader(String value, SdkField<String> field) {
        return field.containsTrait(JsonValueTrait.class) ? new String(BinaryUtils.fromBase64((String)value), StandardCharsets.UTF_8) : value;
    }

    private static class SimpleHeaderUnmarshaller<T>
    implements JsonUnmarshaller<T> {
        private final StringToValueConverter.StringToValue<T> stringToValue;

        private SimpleHeaderUnmarshaller(StringToValueConverter.StringToValue<T> stringToValue) {
            this.stringToValue = stringToValue;
        }

        @Override
        public T unmarshall(JsonUnmarshallerContext context, SdkJsonNode jsonContent, SdkField<T> field) {
            return context.response().firstMatchingHeader(field.locationName()).map(s -> this.stringToValue.convert(s, field)).orElse(null);
        }
    }
}

