/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiResponse;
import software.amazon.awssdk.services.b2bi.model.PartnershipCapabilitiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePartnershipResponse
extends B2BiResponse
implements ToCopyableBuilder<Builder, UpdatePartnershipResponse> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileId").getter(UpdatePartnershipResponse.getter(UpdatePartnershipResponse::profileId)).setter(UpdatePartnershipResponse.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()}).build();
    private static final SdkField<String> PARTNERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partnershipId").getter(UpdatePartnershipResponse.getter(UpdatePartnershipResponse::partnershipId)).setter(UpdatePartnershipResponse.setter(Builder::partnershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnershipId").build()}).build();
    private static final SdkField<String> PARTNERSHIP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partnershipArn").getter(UpdatePartnershipResponse.getter(UpdatePartnershipResponse::partnershipArn)).setter(UpdatePartnershipResponse.setter(Builder::partnershipArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnershipArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdatePartnershipResponse.getter(UpdatePartnershipResponse::name)).setter(UpdatePartnershipResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("email").getter(UpdatePartnershipResponse.getter(UpdatePartnershipResponse::email)).setter(UpdatePartnershipResponse.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<String> PHONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("phone").getter(UpdatePartnershipResponse.getter(UpdatePartnershipResponse::phone)).setter(UpdatePartnershipResponse.setter(Builder::phone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phone").build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilities").getter(UpdatePartnershipResponse.getter(UpdatePartnershipResponse::capabilities)).setter(UpdatePartnershipResponse.setter(Builder::capabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRADING_PARTNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tradingPartnerId").getter(UpdatePartnershipResponse.getter(UpdatePartnershipResponse::tradingPartnerId)).setter(UpdatePartnershipResponse.setter(Builder::tradingPartnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tradingPartnerId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdatePartnershipResponse.getter(UpdatePartnershipResponse::createdAt)).setter(UpdatePartnershipResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(UpdatePartnershipResponse.getter(UpdatePartnershipResponse::modifiedAt)).setter(UpdatePartnershipResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, PARTNERSHIP_ID_FIELD, PARTNERSHIP_ARN_FIELD, NAME_FIELD, EMAIL_FIELD, PHONE_FIELD, CAPABILITIES_FIELD, TRADING_PARTNER_ID_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));
    private final String profileId;
    private final String partnershipId;
    private final String partnershipArn;
    private final String name;
    private final String email;
    private final String phone;
    private final List<String> capabilities;
    private final String tradingPartnerId;
    private final Instant createdAt;
    private final Instant modifiedAt;

    private UpdatePartnershipResponse(BuilderImpl builder) {
        super(builder);
        this.profileId = builder.profileId;
        this.partnershipId = builder.partnershipId;
        this.partnershipArn = builder.partnershipArn;
        this.name = builder.name;
        this.email = builder.email;
        this.phone = builder.phone;
        this.capabilities = builder.capabilities;
        this.tradingPartnerId = builder.tradingPartnerId;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String partnershipId() {
        return this.partnershipId;
    }

    public final String partnershipArn() {
        return this.partnershipArn;
    }

    public final String name() {
        return this.name;
    }

    public final String email() {
        return this.email;
    }

    public final String phone() {
        return this.phone;
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilities() {
        return this.capabilities;
    }

    public final String tradingPartnerId() {
        return this.tradingPartnerId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.phone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tradingPartnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePartnershipResponse)) {
            return false;
        }
        UpdatePartnershipResponse other = (UpdatePartnershipResponse)((Object)obj);
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.partnershipId(), other.partnershipId()) && Objects.equals(this.partnershipArn(), other.partnershipArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.phone(), other.phone()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilities(), other.capabilities()) && Objects.equals(this.tradingPartnerId(), other.tradingPartnerId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePartnershipResponse").add("ProfileId", (Object)this.profileId()).add("PartnershipId", (Object)this.partnershipId()).add("PartnershipArn", (Object)this.partnershipArn()).add("Name", (Object)this.name()).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("Phone", (Object)(this.phone() == null ? null : "*** Sensitive Data Redacted ***")).add("Capabilities", this.hasCapabilities() ? this.capabilities() : null).add("TradingPartnerId", (Object)this.tradingPartnerId()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "partnershipId": {
                return Optional.ofNullable(clazz.cast(this.partnershipId()));
            }
            case "partnershipArn": {
                return Optional.ofNullable(clazz.cast(this.partnershipArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "phone": {
                return Optional.ofNullable(clazz.cast(this.phone()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
            case "tradingPartnerId": {
                return Optional.ofNullable(clazz.cast(this.tradingPartnerId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePartnershipResponse, T> g) {
        return obj -> g.apply((UpdatePartnershipResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiResponse.BuilderImpl
    implements Builder {
        private String profileId;
        private String partnershipId;
        private String partnershipArn;
        private String name;
        private String email;
        private String phone;
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private String tradingPartnerId;
        private Instant createdAt;
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePartnershipResponse model) {
            super(model);
            this.profileId(model.profileId);
            this.partnershipId(model.partnershipId);
            this.partnershipArn(model.partnershipArn);
            this.name(model.name);
            this.email(model.email);
            this.phone(model.phone);
            this.capabilities(model.capabilities);
            this.tradingPartnerId(model.tradingPartnerId);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getPartnershipId() {
            return this.partnershipId;
        }

        public final void setPartnershipId(String partnershipId) {
            this.partnershipId = partnershipId;
        }

        @Override
        public final Builder partnershipId(String partnershipId) {
            this.partnershipId = partnershipId;
            return this;
        }

        public final String getPartnershipArn() {
            return this.partnershipArn;
        }

        public final void setPartnershipArn(String partnershipArn) {
            this.partnershipArn = partnershipArn;
        }

        @Override
        public final Builder partnershipArn(String partnershipArn) {
            this.partnershipArn = partnershipArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getPhone() {
            return this.phone;
        }

        public final void setPhone(String phone) {
            this.phone = phone;
        }

        @Override
        public final Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final String getTradingPartnerId() {
            return this.tradingPartnerId;
        }

        public final void setTradingPartnerId(String tradingPartnerId) {
            this.tradingPartnerId = tradingPartnerId;
        }

        @Override
        public final Builder tradingPartnerId(String tradingPartnerId) {
            this.tradingPartnerId = tradingPartnerId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public UpdatePartnershipResponse build() {
            return new UpdatePartnershipResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends B2BiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePartnershipResponse> {
        public Builder profileId(String var1);

        public Builder partnershipId(String var1);

        public Builder partnershipArn(String var1);

        public Builder name(String var1);

        public Builder email(String var1);

        public Builder phone(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder tradingPartnerId(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);
    }
}

