/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransformerResponse extends B2BiResponse implements
        ToCopyableBuilder<CreateTransformerResponse.Builder, CreateTransformerResponse> {
    private static final SdkField<String> TRANSFORMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformerId").getter(getter(CreateTransformerResponse::transformerId))
            .setter(setter(Builder::transformerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerId").build()).build();

    private static final SdkField<String> TRANSFORMER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformerArn").getter(getter(CreateTransformerResponse::transformerArn))
            .setter(setter(Builder::transformerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateTransformerResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(CreateTransformerResponse::fileFormatAsString))
            .setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mappingTemplate").getter(getter(CreateTransformerResponse::mappingTemplate))
            .setter(setter(Builder::mappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateTransformerResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<EdiType> EDI_TYPE_FIELD = SdkField.<EdiType> builder(MarshallingType.SDK_POJO)
            .memberName("ediType").getter(getter(CreateTransformerResponse::ediType)).setter(setter(Builder::ediType))
            .constructor(EdiType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ediType").build()).build();

    private static final SdkField<String> SAMPLE_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleDocument").getter(getter(CreateTransformerResponse::sampleDocument))
            .setter(setter(Builder::sampleDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocument").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CreateTransformerResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMER_ID_FIELD,
            TRANSFORMER_ARN_FIELD, NAME_FIELD, FILE_FORMAT_FIELD, MAPPING_TEMPLATE_FIELD, STATUS_FIELD, EDI_TYPE_FIELD,
            SAMPLE_DOCUMENT_FIELD, CREATED_AT_FIELD));

    private final String transformerId;

    private final String transformerArn;

    private final String name;

    private final String fileFormat;

    private final String mappingTemplate;

    private final String status;

    private final EdiType ediType;

    private final String sampleDocument;

    private final Instant createdAt;

    private CreateTransformerResponse(BuilderImpl builder) {
        super(builder);
        this.transformerId = builder.transformerId;
        this.transformerArn = builder.transformerArn;
        this.name = builder.name;
        this.fileFormat = builder.fileFormat;
        this.mappingTemplate = builder.mappingTemplate;
        this.status = builder.status;
        this.ediType = builder.ediType;
        this.sampleDocument = builder.sampleDocument;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * Returns the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @return Returns the system-assigned unique identifier for the transformer.
     */
    public final String transformerId() {
        return transformerId;
    }

    /**
     * <p>
     * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
     * partnership, profile, or transformer.
     * </p>
     * 
     * @return Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
     *         partnership, profile, or transformer.
     */
    public final String transformerArn() {
        return transformerArn;
    }

    /**
     * <p>
     * Returns the name of the transformer, used to identify it.
     * </p>
     * 
     * @return Returns the name of the transformer, used to identify it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     */
    public final FileFormat fileFormat() {
        return FileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * Returns the name of the mapping template for the transformer. This template is used to convert the input document
     * into the correct set of objects.
     * </p>
     * 
     * @return Returns the name of the mapping template for the transformer. This template is used to convert the input
     *         document into the correct set of objects.
     */
    public final String mappingTemplate() {
        return mappingTemplate;
    }

    /**
     * <p>
     * Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     * <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TransformerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     *         <code>inactive</code>. For the transformer to be used in a capability, its status must
     *         <code>active</code>.
     * @see TransformerStatus
     */
    public final TransformerStatus status() {
        return TransformerStatus.fromValue(status);
    }

    /**
     * <p>
     * Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     * <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TransformerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     *         <code>inactive</code>. For the transformer to be used in a capability, its status must
     *         <code>active</code>.
     * @see TransformerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @return Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *         supported. X12 is a set of standards and corresponding messages that define specific business documents.
     */
    public final EdiType ediType() {
        return ediType;
    }

    /**
     * <p>
     * Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * </p>
     * 
     * @return Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     */
    public final String sampleDocument() {
        return sampleDocument;
    }

    /**
     * <p>
     * Returns a timestamp for creation date and time of the transformer.
     * </p>
     * 
     * @return Returns a timestamp for creation date and time of the transformer.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformerId());
        hashCode = 31 * hashCode + Objects.hashCode(transformerArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ediType());
        hashCode = 31 * hashCode + Objects.hashCode(sampleDocument());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransformerResponse)) {
            return false;
        }
        CreateTransformerResponse other = (CreateTransformerResponse) obj;
        return Objects.equals(transformerId(), other.transformerId()) && Objects.equals(transformerArn(), other.transformerArn())
                && Objects.equals(name(), other.name()) && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(mappingTemplate(), other.mappingTemplate())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(ediType(), other.ediType())
                && Objects.equals(sampleDocument(), other.sampleDocument()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransformerResponse").add("TransformerId", transformerId())
                .add("TransformerArn", transformerArn()).add("Name", name()).add("FileFormat", fileFormatAsString())
                .add("MappingTemplate", mappingTemplate()).add("Status", statusAsString()).add("EdiType", ediType())
                .add("SampleDocument", sampleDocument()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transformerId":
            return Optional.ofNullable(clazz.cast(transformerId()));
        case "transformerArn":
            return Optional.ofNullable(clazz.cast(transformerArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "mappingTemplate":
            return Optional.ofNullable(clazz.cast(mappingTemplate()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ediType":
            return Optional.ofNullable(clazz.cast(ediType()));
        case "sampleDocument":
            return Optional.ofNullable(clazz.cast(sampleDocument()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransformerResponse, T> g) {
        return obj -> g.apply((CreateTransformerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTransformerResponse> {
        /**
         * <p>
         * Returns the system-assigned unique identifier for the transformer.
         * </p>
         * 
         * @param transformerId
         *        Returns the system-assigned unique identifier for the transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerId(String transformerId);

        /**
         * <p>
         * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
         * partnership, profile, or transformer.
         * </p>
         * 
         * @param transformerArn
         *        Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a
         *        capability, partnership, profile, or transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerArn(String transformerArn);

        /**
         * <p>
         * Returns the name of the transformer, used to identify it.
         * </p>
         * 
         * @param name
         *        Returns the name of the transformer, used to identify it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(FileFormat fileFormat);

        /**
         * <p>
         * Returns the name of the mapping template for the transformer. This template is used to convert the input
         * document into the correct set of objects.
         * </p>
         * 
         * @param mappingTemplate
         *        Returns the name of the mapping template for the transformer. This template is used to convert the
         *        input document into the correct set of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingTemplate(String mappingTemplate);

        /**
         * <p>
         * Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
         * <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.
         * </p>
         * 
         * @param status
         *        Returns the state of the newly created transformer. The transformer can be either <code>active</code>
         *        or <code>inactive</code>. For the transformer to be used in a capability, its status must
         *        <code>active</code>.
         * @see TransformerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
         * <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.
         * </p>
         * 
         * @param status
         *        Returns the state of the newly created transformer. The transformer can be either <code>active</code>
         *        or <code>inactive</code>. For the transformer to be used in a capability, its status must
         *        <code>active</code>.
         * @see TransformerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformerStatus
         */
        Builder status(TransformerStatus status);

        /**
         * <p>
         * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * 
         * @param ediType
         *        Returns the details for the EDI standard that is being used for the transformer. Currently, only X12
         *        is supported. X12 is a set of standards and corresponding messages that define specific business
         *        documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ediType(EdiType ediType);

        /**
         * <p>
         * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdiType.Builder} avoiding the need to
         * create one manually via {@link EdiType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdiType.Builder#build()} is called immediately and its result is
         * passed to {@link #ediType(EdiType)}.
         * 
         * @param ediType
         *        a consumer that will call methods on {@link EdiType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ediType(EdiType)
         */
        default Builder ediType(Consumer<EdiType.Builder> ediType) {
            return ediType(EdiType.builder().applyMutation(ediType).build());
        }

        /**
         * <p>
         * Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
         * </p>
         * 
         * @param sampleDocument
         *        Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleDocument(String sampleDocument);

        /**
         * <p>
         * Returns a timestamp for creation date and time of the transformer.
         * </p>
         * 
         * @param createdAt
         *        Returns a timestamp for creation date and time of the transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private String transformerId;

        private String transformerArn;

        private String name;

        private String fileFormat;

        private String mappingTemplate;

        private String status;

        private EdiType ediType;

        private String sampleDocument;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransformerResponse model) {
            super(model);
            transformerId(model.transformerId);
            transformerArn(model.transformerArn);
            name(model.name);
            fileFormat(model.fileFormat);
            mappingTemplate(model.mappingTemplate);
            status(model.status);
            ediType(model.ediType);
            sampleDocument(model.sampleDocument);
            createdAt(model.createdAt);
        }

        public final String getTransformerId() {
            return transformerId;
        }

        public final void setTransformerId(String transformerId) {
            this.transformerId = transformerId;
        }

        @Override
        public final Builder transformerId(String transformerId) {
            this.transformerId = transformerId;
            return this;
        }

        public final String getTransformerArn() {
            return transformerArn;
        }

        public final void setTransformerArn(String transformerArn) {
            this.transformerArn = transformerArn;
        }

        @Override
        public final Builder transformerArn(String transformerArn) {
            this.transformerArn = transformerArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getMappingTemplate() {
            return mappingTemplate;
        }

        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TransformerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final EdiType.Builder getEdiType() {
            return ediType != null ? ediType.toBuilder() : null;
        }

        public final void setEdiType(EdiType.BuilderImpl ediType) {
            this.ediType = ediType != null ? ediType.build() : null;
        }

        @Override
        public final Builder ediType(EdiType ediType) {
            this.ediType = ediType;
            return this;
        }

        public final String getSampleDocument() {
            return sampleDocument;
        }

        public final void setSampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
        }

        @Override
        public final Builder sampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreateTransformerResponse build() {
            return new CreateTransformerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
