/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiResponse;
import software.amazon.awssdk.services.b2bi.model.CapabilityConfiguration;
import software.amazon.awssdk.services.b2bi.model.CapabilityType;
import software.amazon.awssdk.services.b2bi.model.InstructionsDocumentsCopier;
import software.amazon.awssdk.services.b2bi.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCapabilityResponse
extends B2BiResponse
implements ToCopyableBuilder<Builder, CreateCapabilityResponse> {
    private static final SdkField<String> CAPABILITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilityId").getter(CreateCapabilityResponse.getter(CreateCapabilityResponse::capabilityId)).setter(CreateCapabilityResponse.setter(Builder::capabilityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityId").build()}).build();
    private static final SdkField<String> CAPABILITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capabilityArn").getter(CreateCapabilityResponse.getter(CreateCapabilityResponse::capabilityArn)).setter(CreateCapabilityResponse.setter(Builder::capabilityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateCapabilityResponse.getter(CreateCapabilityResponse::name)).setter(CreateCapabilityResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateCapabilityResponse.getter(CreateCapabilityResponse::typeAsString)).setter(CreateCapabilityResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<CapabilityConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateCapabilityResponse.getter(CreateCapabilityResponse::configuration)).setter(CreateCapabilityResponse.setter(Builder::configuration)).constructor(CapabilityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<List<S3Location>> INSTRUCTIONS_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instructionsDocuments").getter(CreateCapabilityResponse.getter(CreateCapabilityResponse::instructionsDocuments)).setter(CreateCapabilityResponse.setter(Builder::instructionsDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructionsDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateCapabilityResponse.getter(CreateCapabilityResponse::createdAt)).setter(CreateCapabilityResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_ID_FIELD, CAPABILITY_ARN_FIELD, NAME_FIELD, TYPE_FIELD, CONFIGURATION_FIELD, INSTRUCTIONS_DOCUMENTS_FIELD, CREATED_AT_FIELD));
    private final String capabilityId;
    private final String capabilityArn;
    private final String name;
    private final String type;
    private final CapabilityConfiguration configuration;
    private final List<S3Location> instructionsDocuments;
    private final Instant createdAt;

    private CreateCapabilityResponse(BuilderImpl builder) {
        super(builder);
        this.capabilityId = builder.capabilityId;
        this.capabilityArn = builder.capabilityArn;
        this.name = builder.name;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.instructionsDocuments = builder.instructionsDocuments;
        this.createdAt = builder.createdAt;
    }

    public final String capabilityId() {
        return this.capabilityId;
    }

    public final String capabilityArn() {
        return this.capabilityArn;
    }

    public final String name() {
        return this.name;
    }

    public final CapabilityType type() {
        return CapabilityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final CapabilityConfiguration configuration() {
        return this.configuration;
    }

    public final boolean hasInstructionsDocuments() {
        return this.instructionsDocuments != null && !(this.instructionsDocuments instanceof SdkAutoConstructList);
    }

    public final List<S3Location> instructionsDocuments() {
        return this.instructionsDocuments;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstructionsDocuments() ? this.instructionsDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapabilityResponse)) {
            return false;
        }
        CreateCapabilityResponse other = (CreateCapabilityResponse)((Object)obj);
        return Objects.equals(this.capabilityId(), other.capabilityId()) && Objects.equals(this.capabilityArn(), other.capabilityArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.configuration(), other.configuration()) && this.hasInstructionsDocuments() == other.hasInstructionsDocuments() && Objects.equals(this.instructionsDocuments(), other.instructionsDocuments()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCapabilityResponse").add("CapabilityId", (Object)this.capabilityId()).add("CapabilityArn", (Object)this.capabilityArn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Configuration", (Object)this.configuration()).add("InstructionsDocuments", this.hasInstructionsDocuments() ? this.instructionsDocuments() : null).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capabilityId": {
                return Optional.ofNullable(clazz.cast(this.capabilityId()));
            }
            case "capabilityArn": {
                return Optional.ofNullable(clazz.cast(this.capabilityArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "instructionsDocuments": {
                return Optional.ofNullable(clazz.cast(this.instructionsDocuments()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCapabilityResponse, T> g) {
        return obj -> g.apply((CreateCapabilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiResponse.BuilderImpl
    implements Builder {
        private String capabilityId;
        private String capabilityArn;
        private String name;
        private String type;
        private CapabilityConfiguration configuration;
        private List<S3Location> instructionsDocuments = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapabilityResponse model) {
            super(model);
            this.capabilityId(model.capabilityId);
            this.capabilityArn(model.capabilityArn);
            this.name(model.name);
            this.type(model.type);
            this.configuration(model.configuration);
            this.instructionsDocuments(model.instructionsDocuments);
            this.createdAt(model.createdAt);
        }

        public final String getCapabilityId() {
            return this.capabilityId;
        }

        public final void setCapabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
        }

        @Override
        public final Builder capabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
            return this;
        }

        public final String getCapabilityArn() {
            return this.capabilityArn;
        }

        public final void setCapabilityArn(String capabilityArn) {
            this.capabilityArn = capabilityArn;
        }

        @Override
        public final Builder capabilityArn(String capabilityArn) {
            this.capabilityArn = capabilityArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CapabilityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CapabilityConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CapabilityConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CapabilityConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<S3Location.Builder> getInstructionsDocuments() {
            List<S3Location.Builder> result = InstructionsDocumentsCopier.copyToBuilder(this.instructionsDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstructionsDocuments(Collection<S3Location.BuilderImpl> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copyFromBuilder(instructionsDocuments);
        }

        @Override
        public final Builder instructionsDocuments(Collection<S3Location> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copy(instructionsDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(S3Location ... instructionsDocuments) {
            this.instructionsDocuments(Arrays.asList(instructionsDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(Consumer<S3Location.Builder> ... instructionsDocuments) {
            this.instructionsDocuments(Stream.of(instructionsDocuments).map(c -> (S3Location)((S3Location.Builder)S3Location.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreateCapabilityResponse build() {
            return new CreateCapabilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends B2BiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCapabilityResponse> {
        public Builder capabilityId(String var1);

        public Builder capabilityArn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(CapabilityType var1);

        public Builder configuration(CapabilityConfiguration var1);

        default public Builder configuration(Consumer<CapabilityConfiguration.Builder> configuration) {
            return this.configuration((CapabilityConfiguration)((CapabilityConfiguration.Builder)CapabilityConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder instructionsDocuments(Collection<S3Location> var1);

        public Builder instructionsDocuments(S3Location ... var1);

        public Builder instructionsDocuments(Consumer<S3Location.Builder> ... var1);

        public Builder createdAt(Instant var1);
    }
}

