/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestParsingRequest extends B2BiRequest implements
        ToCopyableBuilder<TestParsingRequest.Builder, TestParsingRequest> {
    private static final SdkField<S3Location> INPUT_FILE_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("inputFile").getter(getter(TestParsingRequest::inputFile)).setter(setter(Builder::inputFile))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFile").build()).build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(TestParsingRequest::fileFormatAsString)).setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<EdiType> EDI_TYPE_FIELD = SdkField.<EdiType> builder(MarshallingType.SDK_POJO)
            .memberName("ediType").getter(getter(TestParsingRequest::ediType)).setter(setter(Builder::ediType))
            .constructor(EdiType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ediType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILE_FIELD,
            FILE_FORMAT_FIELD, EDI_TYPE_FIELD));

    private final S3Location inputFile;

    private final String fileFormat;

    private final EdiType ediType;

    private TestParsingRequest(BuilderImpl builder) {
        super(builder);
        this.inputFile = builder.inputFile;
        this.fileFormat = builder.fileFormat;
        this.ediType = builder.ediType;
    }

    /**
     * <p>
     * Specifies an <code>S3Location</code> object, which contains the Amazon S3 bucket and prefix for the location of
     * the input file.
     * </p>
     * 
     * @return Specifies an <code>S3Location</code> object, which contains the Amazon S3 bucket and prefix for the
     *         location of the input file.
     */
    public final S3Location inputFile() {
        return inputFile;
    }

    /**
     * <p>
     * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     */
    public final FileFormat fileFormat() {
        return FileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @return Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *         supported. X12 is a set of standards and corresponding messages that define specific business documents.
     */
    public final EdiType ediType() {
        return ediType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputFile());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ediType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestParsingRequest)) {
            return false;
        }
        TestParsingRequest other = (TestParsingRequest) obj;
        return Objects.equals(inputFile(), other.inputFile()) && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(ediType(), other.ediType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestParsingRequest").add("InputFile", inputFile()).add("FileFormat", fileFormatAsString())
                .add("EdiType", ediType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputFile":
            return Optional.ofNullable(clazz.cast(inputFile()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "ediType":
            return Optional.ofNullable(clazz.cast(ediType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestParsingRequest, T> g) {
        return obj -> g.apply((TestParsingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestParsingRequest> {
        /**
         * <p>
         * Specifies an <code>S3Location</code> object, which contains the Amazon S3 bucket and prefix for the location
         * of the input file.
         * </p>
         * 
         * @param inputFile
         *        Specifies an <code>S3Location</code> object, which contains the Amazon S3 bucket and prefix for the
         *        location of the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFile(S3Location inputFile);

        /**
         * <p>
         * Specifies an <code>S3Location</code> object, which contains the Amazon S3 bucket and prefix for the location
         * of the input file.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #inputFile(S3Location)}.
         * 
         * @param inputFile
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputFile(S3Location)
         */
        default Builder inputFile(Consumer<S3Location.Builder> inputFile) {
            return inputFile(S3Location.builder().applyMutation(inputFile).build());
        }

        /**
         * <p>
         * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(FileFormat fileFormat);

        /**
         * <p>
         * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * 
         * @param ediType
         *        Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12
         *        is supported. X12 is a set of standards and corresponding messages that define specific business
         *        documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ediType(EdiType ediType);

        /**
         * <p>
         * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdiType.Builder} avoiding the need to
         * create one manually via {@link EdiType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdiType.Builder#build()} is called immediately and its result is
         * passed to {@link #ediType(EdiType)}.
         * 
         * @param ediType
         *        a consumer that will call methods on {@link EdiType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ediType(EdiType)
         */
        default Builder ediType(Consumer<EdiType.Builder> ediType) {
            return ediType(EdiType.builder().applyMutation(ediType).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private S3Location inputFile;

        private String fileFormat;

        private EdiType ediType;

        private BuilderImpl() {
        }

        private BuilderImpl(TestParsingRequest model) {
            super(model);
            inputFile(model.inputFile);
            fileFormat(model.fileFormat);
            ediType(model.ediType);
        }

        public final S3Location.Builder getInputFile() {
            return inputFile != null ? inputFile.toBuilder() : null;
        }

        public final void setInputFile(S3Location.BuilderImpl inputFile) {
            this.inputFile = inputFile != null ? inputFile.build() : null;
        }

        @Override
        public final Builder inputFile(S3Location inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final EdiType.Builder getEdiType() {
            return ediType != null ? ediType.toBuilder() : null;
        }

        public final void setEdiType(EdiType.BuilderImpl ediType) {
            this.ediType = ediType != null ? ediType.build() : null;
        }

        @Override
        public final Builder ediType(EdiType ediType) {
            this.ediType = ediType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestParsingRequest build() {
            return new TestParsingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
