/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.B2BiResponse;
import software.amazon.awssdk.services.b2bi.model.EdiType;
import software.amazon.awssdk.services.b2bi.model.FileFormat;
import software.amazon.awssdk.services.b2bi.model.TransformerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTransformerResponse
extends B2BiResponse
implements ToCopyableBuilder<Builder, GetTransformerResponse> {
    private static final SdkField<String> TRANSFORMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transformerId").getter(GetTransformerResponse.getter(GetTransformerResponse::transformerId)).setter(GetTransformerResponse.setter(Builder::transformerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerId").build()}).build();
    private static final SdkField<String> TRANSFORMER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transformerArn").getter(GetTransformerResponse.getter(GetTransformerResponse::transformerArn)).setter(GetTransformerResponse.setter(Builder::transformerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTransformerResponse.getter(GetTransformerResponse::name)).setter(GetTransformerResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(GetTransformerResponse.getter(GetTransformerResponse::fileFormatAsString)).setter(GetTransformerResponse.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mappingTemplate").getter(GetTransformerResponse.getter(GetTransformerResponse::mappingTemplate)).setter(GetTransformerResponse.setter(Builder::mappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetTransformerResponse.getter(GetTransformerResponse::statusAsString)).setter(GetTransformerResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<EdiType> EDI_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ediType").getter(GetTransformerResponse.getter(GetTransformerResponse::ediType)).setter(GetTransformerResponse.setter(Builder::ediType)).constructor(EdiType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ediType").build()}).build();
    private static final SdkField<String> SAMPLE_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleDocument").getter(GetTransformerResponse.getter(GetTransformerResponse::sampleDocument)).setter(GetTransformerResponse.setter(Builder::sampleDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocument").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetTransformerResponse.getter(GetTransformerResponse::createdAt)).setter(GetTransformerResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(GetTransformerResponse.getter(GetTransformerResponse::modifiedAt)).setter(GetTransformerResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMER_ID_FIELD, TRANSFORMER_ARN_FIELD, NAME_FIELD, FILE_FORMAT_FIELD, MAPPING_TEMPLATE_FIELD, STATUS_FIELD, EDI_TYPE_FIELD, SAMPLE_DOCUMENT_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD));
    private final String transformerId;
    private final String transformerArn;
    private final String name;
    private final String fileFormat;
    private final String mappingTemplate;
    private final String status;
    private final EdiType ediType;
    private final String sampleDocument;
    private final Instant createdAt;
    private final Instant modifiedAt;

    private GetTransformerResponse(BuilderImpl builder) {
        super(builder);
        this.transformerId = builder.transformerId;
        this.transformerArn = builder.transformerArn;
        this.name = builder.name;
        this.fileFormat = builder.fileFormat;
        this.mappingTemplate = builder.mappingTemplate;
        this.status = builder.status;
        this.ediType = builder.ediType;
        this.sampleDocument = builder.sampleDocument;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    public final String transformerId() {
        return this.transformerId;
    }

    public final String transformerArn() {
        return this.transformerArn;
    }

    public final String name() {
        return this.name;
    }

    public final FileFormat fileFormat() {
        return FileFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final String mappingTemplate() {
        return this.mappingTemplate;
    }

    public final TransformerStatus status() {
        return TransformerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final EdiType ediType() {
        return this.ediType;
    }

    public final String sampleDocument() {
        return this.sampleDocument;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transformerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ediType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransformerResponse)) {
            return false;
        }
        GetTransformerResponse other = (GetTransformerResponse)((Object)obj);
        return Objects.equals(this.transformerId(), other.transformerId()) && Objects.equals(this.transformerArn(), other.transformerArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.mappingTemplate(), other.mappingTemplate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.ediType(), other.ediType()) && Objects.equals(this.sampleDocument(), other.sampleDocument()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetTransformerResponse").add("TransformerId", (Object)this.transformerId()).add("TransformerArn", (Object)this.transformerArn()).add("Name", (Object)this.name()).add("FileFormat", (Object)this.fileFormatAsString()).add("MappingTemplate", (Object)this.mappingTemplate()).add("Status", (Object)this.statusAsString()).add("EdiType", (Object)this.ediType()).add("SampleDocument", (Object)this.sampleDocument()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transformerId": {
                return Optional.ofNullable(clazz.cast(this.transformerId()));
            }
            case "transformerArn": {
                return Optional.ofNullable(clazz.cast(this.transformerArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "mappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.mappingTemplate()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ediType": {
                return Optional.ofNullable(clazz.cast(this.ediType()));
            }
            case "sampleDocument": {
                return Optional.ofNullable(clazz.cast(this.sampleDocument()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransformerResponse, T> g) {
        return obj -> g.apply((GetTransformerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiResponse.BuilderImpl
    implements Builder {
        private String transformerId;
        private String transformerArn;
        private String name;
        private String fileFormat;
        private String mappingTemplate;
        private String status;
        private EdiType ediType;
        private String sampleDocument;
        private Instant createdAt;
        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransformerResponse model) {
            super(model);
            this.transformerId(model.transformerId);
            this.transformerArn(model.transformerArn);
            this.name(model.name);
            this.fileFormat(model.fileFormat);
            this.mappingTemplate(model.mappingTemplate);
            this.status(model.status);
            this.ediType(model.ediType);
            this.sampleDocument(model.sampleDocument);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
        }

        public final String getTransformerId() {
            return this.transformerId;
        }

        public final void setTransformerId(String transformerId) {
            this.transformerId = transformerId;
        }

        @Override
        public final Builder transformerId(String transformerId) {
            this.transformerId = transformerId;
            return this;
        }

        public final String getTransformerArn() {
            return this.transformerArn;
        }

        public final void setTransformerArn(String transformerArn) {
            this.transformerArn = transformerArn;
        }

        @Override
        public final Builder transformerArn(String transformerArn) {
            this.transformerArn = transformerArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getMappingTemplate() {
            return this.mappingTemplate;
        }

        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TransformerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final EdiType.Builder getEdiType() {
            return this.ediType != null ? this.ediType.toBuilder() : null;
        }

        public final void setEdiType(EdiType.BuilderImpl ediType) {
            this.ediType = ediType != null ? ediType.build() : null;
        }

        @Override
        public final Builder ediType(EdiType ediType) {
            this.ediType = ediType;
            return this;
        }

        public final String getSampleDocument() {
            return this.sampleDocument;
        }

        public final void setSampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
        }

        @Override
        public final Builder sampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public GetTransformerResponse build() {
            return new GetTransformerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends B2BiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTransformerResponse> {
        public Builder transformerId(String var1);

        public Builder transformerArn(String var1);

        public Builder name(String var1);

        public Builder fileFormat(String var1);

        public Builder fileFormat(FileFormat var1);

        public Builder mappingTemplate(String var1);

        public Builder status(String var1);

        public Builder status(TransformerStatus var1);

        public Builder ediType(EdiType var1);

        default public Builder ediType(Consumer<EdiType.Builder> ediType) {
            return this.ediType((EdiType)((EdiType.Builder)EdiType.builder().applyMutation(ediType)).build());
        }

        public Builder sampleDocument(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);
    }
}

