/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A capability object. Currently, only EDI (electronic data interchange) capabilities are supported. A trading
 * capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapabilityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CapabilityConfiguration.Builder, CapabilityConfiguration> {
    private static final SdkField<EdiConfiguration> EDI_FIELD = SdkField.<EdiConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("edi").getter(getter(CapabilityConfiguration::edi)).setter(setter(Builder::edi))
            .constructor(EdiConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("edi").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDI_FIELD));

    private static final long serialVersionUID = 1L;

    private final EdiConfiguration edi;

    private final Type type;

    private CapabilityConfiguration(BuilderImpl builder) {
        this.edi = builder.edi;
        this.type = builder.type;
    }

    /**
     * <p>
     * An EDI (electronic data interchange) configuration object.
     * </p>
     * 
     * @return An EDI (electronic data interchange) configuration object.
     */
    public final EdiConfiguration edi() {
        return edi;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(edi());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilityConfiguration)) {
            return false;
        }
        CapabilityConfiguration other = (CapabilityConfiguration) obj;
        return Objects.equals(edi(), other.edi());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapabilityConfiguration").add("Edi", edi()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "edi":
            return Optional.ofNullable(clazz.cast(edi()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #edi()} initialized to the given value.
     *
     * <p>
     * An EDI (electronic data interchange) configuration object.
     * </p>
     * 
     * @param edi
     *        An EDI (electronic data interchange) configuration object.
     */
    public static CapabilityConfiguration fromEdi(EdiConfiguration edi) {
        return builder().edi(edi).build();
    }

    /**
     * Create an instance of this class with {@link #edi()} initialized to the given value.
     *
     * <p>
     * An EDI (electronic data interchange) configuration object.
     * </p>
     * 
     * @param edi
     *        An EDI (electronic data interchange) configuration object.
     */
    public static CapabilityConfiguration fromEdi(Consumer<EdiConfiguration.Builder> edi) {
        EdiConfiguration.Builder builder = EdiConfiguration.builder();
        edi.accept(builder);
        return fromEdi(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapabilityConfiguration, T> g) {
        return obj -> g.apply((CapabilityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapabilityConfiguration> {
        /**
         * <p>
         * An EDI (electronic data interchange) configuration object.
         * </p>
         * 
         * @param edi
         *        An EDI (electronic data interchange) configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edi(EdiConfiguration edi);

        /**
         * <p>
         * An EDI (electronic data interchange) configuration object.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdiConfiguration.Builder} avoiding the
         * need to create one manually via {@link EdiConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdiConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #edi(EdiConfiguration)}.
         * 
         * @param edi
         *        a consumer that will call methods on {@link EdiConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edi(EdiConfiguration)
         */
        default Builder edi(Consumer<EdiConfiguration.Builder> edi) {
            return edi(EdiConfiguration.builder().applyMutation(edi).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EdiConfiguration edi;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilityConfiguration model) {
            edi(model.edi);
        }

        public final EdiConfiguration.Builder getEdi() {
            return edi != null ? edi.toBuilder() : null;
        }

        public final void setEdi(EdiConfiguration.BuilderImpl edi) {
            Object oldValue = this.edi;
            this.edi = edi != null ? edi.build() : null;
            handleUnionValueChange(Type.EDI, oldValue, this.edi);
        }

        @Override
        public final Builder edi(EdiConfiguration edi) {
            Object oldValue = this.edi;
            this.edi = edi;
            handleUnionValueChange(Type.EDI, oldValue, this.edi);
            return this;
        }

        @Override
        public CapabilityConfiguration build() {
            return new CapabilityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CapabilityConfiguration#type()
     */
    public enum Type {
        EDI,

        UNKNOWN_TO_SDK_VERSION
    }
}
