/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestMappingRequest extends B2BiRequest implements
        ToCopyableBuilder<TestMappingRequest.Builder, TestMappingRequest> {
    private static final SdkField<String> INPUT_FILE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputFileContent").getter(getter(TestMappingRequest::inputFileContent))
            .setter(setter(Builder::inputFileContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFileContent").build()).build();

    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mappingTemplate").getter(getter(TestMappingRequest::mappingTemplate))
            .setter(setter(Builder::mappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()).build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(TestMappingRequest::fileFormatAsString)).setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILE_CONTENT_FIELD,
            MAPPING_TEMPLATE_FIELD, FILE_FORMAT_FIELD));

    private final String inputFileContent;

    private final String mappingTemplate;

    private final String fileFormat;

    private TestMappingRequest(BuilderImpl builder) {
        super(builder);
        this.inputFileContent = builder.inputFileContent;
        this.mappingTemplate = builder.mappingTemplate;
        this.fileFormat = builder.fileFormat;
    }

    /**
     * <p>
     * Specify the contents of the EDI (electronic data interchange) XML or JSON file that is used as input for the
     * transform.
     * </p>
     * 
     * @return Specify the contents of the EDI (electronic data interchange) XML or JSON file that is used as input for
     *         the transform.
     */
    public final String inputFileContent() {
        return inputFileContent;
    }

    /**
     * <p>
     * Specifies the name of the mapping template for the transformer. This template is used to convert the input
     * document into the correct set of objects.
     * </p>
     * 
     * @return Specifies the name of the mapping template for the transformer. This template is used to convert the
     *         input document into the correct set of objects.
     */
    public final String mappingTemplate() {
        return mappingTemplate;
    }

    /**
     * <p>
     * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     */
    public final FileFormat fileFormat() {
        return FileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestMappingRequest)) {
            return false;
        }
        TestMappingRequest other = (TestMappingRequest) obj;
        return Objects.equals(inputFileContent(), other.inputFileContent())
                && Objects.equals(mappingTemplate(), other.mappingTemplate())
                && Objects.equals(fileFormatAsString(), other.fileFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestMappingRequest").add("InputFileContent", inputFileContent())
                .add("MappingTemplate", mappingTemplate()).add("FileFormat", fileFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputFileContent":
            return Optional.ofNullable(clazz.cast(inputFileContent()));
        case "mappingTemplate":
            return Optional.ofNullable(clazz.cast(mappingTemplate()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestMappingRequest, T> g) {
        return obj -> g.apply((TestMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestMappingRequest> {
        /**
         * <p>
         * Specify the contents of the EDI (electronic data interchange) XML or JSON file that is used as input for the
         * transform.
         * </p>
         * 
         * @param inputFileContent
         *        Specify the contents of the EDI (electronic data interchange) XML or JSON file that is used as input
         *        for the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFileContent(String inputFileContent);

        /**
         * <p>
         * Specifies the name of the mapping template for the transformer. This template is used to convert the input
         * document into the correct set of objects.
         * </p>
         * 
         * @param mappingTemplate
         *        Specifies the name of the mapping template for the transformer. This template is used to convert the
         *        input document into the correct set of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingTemplate(String mappingTemplate);

        /**
         * <p>
         * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(FileFormat fileFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String inputFileContent;

        private String mappingTemplate;

        private String fileFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(TestMappingRequest model) {
            super(model);
            inputFileContent(model.inputFileContent);
            mappingTemplate(model.mappingTemplate);
            fileFormat(model.fileFormat);
        }

        public final String getInputFileContent() {
            return inputFileContent;
        }

        public final void setInputFileContent(String inputFileContent) {
            this.inputFileContent = inputFileContent;
        }

        @Override
        public final Builder inputFileContent(String inputFileContent) {
            this.inputFileContent = inputFileContent;
            return this;
        }

        public final String getMappingTemplate() {
            return mappingTemplate;
        }

        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestMappingRequest build() {
            return new TestMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
