/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.b2bi.model.CreateCapabilityRequest;
import software.amazon.awssdk.services.b2bi.model.CreateCapabilityResponse;
import software.amazon.awssdk.services.b2bi.model.CreatePartnershipRequest;
import software.amazon.awssdk.services.b2bi.model.CreatePartnershipResponse;
import software.amazon.awssdk.services.b2bi.model.CreateProfileRequest;
import software.amazon.awssdk.services.b2bi.model.CreateProfileResponse;
import software.amazon.awssdk.services.b2bi.model.CreateTransformerRequest;
import software.amazon.awssdk.services.b2bi.model.CreateTransformerResponse;
import software.amazon.awssdk.services.b2bi.model.DeleteCapabilityRequest;
import software.amazon.awssdk.services.b2bi.model.DeleteCapabilityResponse;
import software.amazon.awssdk.services.b2bi.model.DeletePartnershipRequest;
import software.amazon.awssdk.services.b2bi.model.DeletePartnershipResponse;
import software.amazon.awssdk.services.b2bi.model.DeleteProfileRequest;
import software.amazon.awssdk.services.b2bi.model.DeleteProfileResponse;
import software.amazon.awssdk.services.b2bi.model.DeleteTransformerRequest;
import software.amazon.awssdk.services.b2bi.model.DeleteTransformerResponse;
import software.amazon.awssdk.services.b2bi.model.GetCapabilityRequest;
import software.amazon.awssdk.services.b2bi.model.GetCapabilityResponse;
import software.amazon.awssdk.services.b2bi.model.GetPartnershipRequest;
import software.amazon.awssdk.services.b2bi.model.GetPartnershipResponse;
import software.amazon.awssdk.services.b2bi.model.GetProfileRequest;
import software.amazon.awssdk.services.b2bi.model.GetProfileResponse;
import software.amazon.awssdk.services.b2bi.model.GetTransformerJobRequest;
import software.amazon.awssdk.services.b2bi.model.GetTransformerJobResponse;
import software.amazon.awssdk.services.b2bi.model.GetTransformerRequest;
import software.amazon.awssdk.services.b2bi.model.GetTransformerResponse;
import software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest;
import software.amazon.awssdk.services.b2bi.model.ListCapabilitiesResponse;
import software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest;
import software.amazon.awssdk.services.b2bi.model.ListPartnershipsResponse;
import software.amazon.awssdk.services.b2bi.model.ListProfilesRequest;
import software.amazon.awssdk.services.b2bi.model.ListProfilesResponse;
import software.amazon.awssdk.services.b2bi.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.b2bi.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.b2bi.model.ListTransformersRequest;
import software.amazon.awssdk.services.b2bi.model.ListTransformersResponse;
import software.amazon.awssdk.services.b2bi.model.StartTransformerJobRequest;
import software.amazon.awssdk.services.b2bi.model.StartTransformerJobResponse;
import software.amazon.awssdk.services.b2bi.model.TagResourceRequest;
import software.amazon.awssdk.services.b2bi.model.TagResourceResponse;
import software.amazon.awssdk.services.b2bi.model.TestMappingRequest;
import software.amazon.awssdk.services.b2bi.model.TestMappingResponse;
import software.amazon.awssdk.services.b2bi.model.TestParsingRequest;
import software.amazon.awssdk.services.b2bi.model.TestParsingResponse;
import software.amazon.awssdk.services.b2bi.model.UntagResourceRequest;
import software.amazon.awssdk.services.b2bi.model.UntagResourceResponse;
import software.amazon.awssdk.services.b2bi.model.UpdateCapabilityRequest;
import software.amazon.awssdk.services.b2bi.model.UpdateCapabilityResponse;
import software.amazon.awssdk.services.b2bi.model.UpdatePartnershipRequest;
import software.amazon.awssdk.services.b2bi.model.UpdatePartnershipResponse;
import software.amazon.awssdk.services.b2bi.model.UpdateProfileRequest;
import software.amazon.awssdk.services.b2bi.model.UpdateProfileResponse;
import software.amazon.awssdk.services.b2bi.model.UpdateTransformerRequest;
import software.amazon.awssdk.services.b2bi.model.UpdateTransformerResponse;
import software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesPublisher;
import software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsPublisher;
import software.amazon.awssdk.services.b2bi.paginators.ListProfilesPublisher;
import software.amazon.awssdk.services.b2bi.paginators.ListTransformersPublisher;

/**
 * Service client for accessing AWS B2BI asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * This is the <i>Amazon Web Services B2B Data Interchange API Reference</i>. It provides descriptions, API request
 * parameters, and the XML response for each of the B2BI API actions.
 * </p>
 * <p>
 * B2BI enables automated exchange of EDI (electronic data interchange) based business-critical transactions at cloud
 * scale, with elasticity and pay-as-you-go pricing. Businesses use EDI documents to exchange transactional data with
 * trading partners, such as suppliers and end customers, using standardized formats such as X12.
 * </p>
 * <note>
 * <p>
 * Rather than actually running a command, you can use the <code>--generate-cli-skeleton</code> parameter with any API
 * call to generate and display a parameter template. You can then use the generated template to customize and use as
 * input on a later command. For details, see <a
 * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-skeleton.html#cli-usage-skeleton-generate">Generate
 * and use a parameter skeleton file</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface B2BiAsyncClient extends AwsClient {
    String SERVICE_NAME = "b2bi";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "b2bi";

    /**
     * <p>
     * Instantiates a capability based on the specified parameters. A trading capability contains the information
     * required to transform incoming EDI documents into JSON or XML outputs.
     * </p>
     *
     * @param createCapabilityRequest
     * @return A Java Future containing the result of the CreateCapability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.CreateCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCapabilityResponse> createCapability(CreateCapabilityRequest createCapabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instantiates a capability based on the specified parameters. A trading capability contains the information
     * required to transform incoming EDI documents into JSON or XML outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCapabilityRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCapabilityRequest#builder()}
     * </p>
     *
     * @param createCapabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.CreateCapabilityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCapability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.CreateCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCapabilityResponse> createCapability(
            Consumer<CreateCapabilityRequest.Builder> createCapabilityRequest) {
        return createCapability(CreateCapabilityRequest.builder().applyMutation(createCapabilityRequest).build());
    }

    /**
     * <p>
     * Creates a partnership between a customer and a trading partner, based on the supplied parameters. A partnership
     * represents the connection between you and your trading partner. It ties together a profile and one or more
     * trading capabilities.
     * </p>
     *
     * @param createPartnershipRequest
     * @return A Java Future containing the result of the CreatePartnership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.CreatePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreatePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePartnershipResponse> createPartnership(CreatePartnershipRequest createPartnershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a partnership between a customer and a trading partner, based on the supplied parameters. A partnership
     * represents the connection between you and your trading partner. It ties together a profile and one or more
     * trading capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartnershipRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePartnershipRequest#builder()}
     * </p>
     *
     * @param createPartnershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.CreatePartnershipRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePartnership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.CreatePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreatePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePartnershipResponse> createPartnership(
            Consumer<CreatePartnershipRequest.Builder> createPartnershipRequest) {
        return createPartnership(CreatePartnershipRequest.builder().applyMutation(createPartnershipRequest).build());
    }

    /**
     * <p>
     * Creates a customer profile. You can have up to five customer profiles, each representing a distinct private
     * network. A profile is the mechanism used to create the concept of a private network.
     * </p>
     *
     * @param createProfileRequest
     * @return A Java Future containing the result of the CreateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProfileResponse> createProfile(CreateProfileRequest createProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a customer profile. You can have up to five customer profiles, each representing a distinct private
     * network. A profile is the mechanism used to create the concept of a private network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProfileRequest#builder()}
     * </p>
     *
     * @param createProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.CreateProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProfileResponse> createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest) {
        return createProfile(CreateProfileRequest.builder().applyMutation(createProfileRequest).build());
    }

    /**
     * <p>
     * Creates a transformer. A transformer describes how to process the incoming EDI documents and extract the
     * necessary information to the output file.
     * </p>
     *
     * @param createTransformerRequest
     * @return A Java Future containing the result of the CreateTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.CreateTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTransformerResponse> createTransformer(CreateTransformerRequest createTransformerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a transformer. A transformer describes how to process the incoming EDI documents and extract the
     * necessary information to the output file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransformerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTransformerRequest#builder()}
     * </p>
     *
     * @param createTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.CreateTransformerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.CreateTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/CreateTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTransformerResponse> createTransformer(
            Consumer<CreateTransformerRequest.Builder> createTransformerRequest) {
        return createTransformer(CreateTransformerRequest.builder().applyMutation(createTransformerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified capability. A trading capability contains the information required to transform incoming
     * EDI documents into JSON or XML outputs.
     * </p>
     *
     * @param deleteCapabilityRequest
     * @return A Java Future containing the result of the DeleteCapability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.DeleteCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCapabilityResponse> deleteCapability(DeleteCapabilityRequest deleteCapabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified capability. A trading capability contains the information required to transform incoming
     * EDI documents into JSON or XML outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCapabilityRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCapabilityRequest#builder()}
     * </p>
     *
     * @param deleteCapabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.DeleteCapabilityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCapability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.DeleteCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCapabilityResponse> deleteCapability(
            Consumer<DeleteCapabilityRequest.Builder> deleteCapabilityRequest) {
        return deleteCapability(DeleteCapabilityRequest.builder().applyMutation(deleteCapabilityRequest).build());
    }

    /**
     * <p>
     * Deletes the specified partnership. A partnership represents the connection between you and your trading partner.
     * It ties together a profile and one or more trading capabilities.
     * </p>
     *
     * @param deletePartnershipRequest
     * @return A Java Future containing the result of the DeletePartnership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.DeletePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeletePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePartnershipResponse> deletePartnership(DeletePartnershipRequest deletePartnershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified partnership. A partnership represents the connection between you and your trading partner.
     * It ties together a profile and one or more trading capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartnershipRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePartnershipRequest#builder()}
     * </p>
     *
     * @param deletePartnershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.DeletePartnershipRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePartnership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.DeletePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeletePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePartnershipResponse> deletePartnership(
            Consumer<DeletePartnershipRequest.Builder> deletePartnershipRequest) {
        return deletePartnership(DeletePartnershipRequest.builder().applyMutation(deletePartnershipRequest).build());
    }

    /**
     * <p>
     * Deletes the specified profile. A profile is the mechanism used to create the concept of a private network.
     * </p>
     *
     * @param deleteProfileRequest
     * @return A Java Future containing the result of the DeleteProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProfileResponse> deleteProfile(DeleteProfileRequest deleteProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified profile. A profile is the mechanism used to create the concept of a private network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProfileRequest#builder()}
     * </p>
     *
     * @param deleteProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.DeleteProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProfileResponse> deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest) {
        return deleteProfile(DeleteProfileRequest.builder().applyMutation(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Deletes the specified transformer. A transformer describes how to process the incoming EDI documents and extract
     * the necessary information to the output file.
     * </p>
     *
     * @param deleteTransformerRequest
     * @return A Java Future containing the result of the DeleteTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.DeleteTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTransformerResponse> deleteTransformer(DeleteTransformerRequest deleteTransformerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified transformer. A transformer describes how to process the incoming EDI documents and extract
     * the necessary information to the output file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTransformerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTransformerRequest#builder()}
     * </p>
     *
     * @param deleteTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.DeleteTransformerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.DeleteTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/DeleteTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTransformerResponse> deleteTransformer(
            Consumer<DeleteTransformerRequest.Builder> deleteTransformerRequest) {
        return deleteTransformer(DeleteTransformerRequest.builder().applyMutation(deleteTransformerRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for the specified capability. A trading capability contains the information required to
     * transform incoming EDI documents into JSON or XML outputs.
     * </p>
     *
     * @param getCapabilityRequest
     * @return A Java Future containing the result of the GetCapability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.GetCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCapabilityResponse> getCapability(GetCapabilityRequest getCapabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for the specified capability. A trading capability contains the information required to
     * transform incoming EDI documents into JSON or XML outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCapabilityRequest.Builder} avoiding the need to
     * create one manually via {@link GetCapabilityRequest#builder()}
     * </p>
     *
     * @param getCapabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GetCapabilityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCapability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.GetCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCapabilityResponse> getCapability(Consumer<GetCapabilityRequest.Builder> getCapabilityRequest) {
        return getCapability(GetCapabilityRequest.builder().applyMutation(getCapabilityRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for a partnership, based on the partner and profile IDs specified. A partnership represents
     * the connection between you and your trading partner. It ties together a profile and one or more trading
     * capabilities.
     * </p>
     *
     * @param getPartnershipRequest
     * @return A Java Future containing the result of the GetPartnership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.GetPartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetPartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPartnershipResponse> getPartnership(GetPartnershipRequest getPartnershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for a partnership, based on the partner and profile IDs specified. A partnership represents
     * the connection between you and your trading partner. It ties together a profile and one or more trading
     * capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPartnershipRequest.Builder} avoiding the need to
     * create one manually via {@link GetPartnershipRequest#builder()}
     * </p>
     *
     * @param getPartnershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GetPartnershipRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPartnership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.GetPartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetPartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPartnershipResponse> getPartnership(Consumer<GetPartnershipRequest.Builder> getPartnershipRequest) {
        return getPartnership(GetPartnershipRequest.builder().applyMutation(getPartnershipRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for the profile specified by the profile ID. A profile is the mechanism used to create the
     * concept of a private network.
     * </p>
     *
     * @param getProfileRequest
     * @return A Java Future containing the result of the GetProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProfileResponse> getProfile(GetProfileRequest getProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for the profile specified by the profile ID. A profile is the mechanism used to create the
     * concept of a private network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetProfileRequest#builder()}
     * </p>
     *
     * @param getProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GetProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.GetProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetProfileResponse> getProfile(Consumer<GetProfileRequest.Builder> getProfileRequest) {
        return getProfile(GetProfileRequest.builder().applyMutation(getProfileRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for the transformer specified by the transformer ID. A transformer describes how to process
     * the incoming EDI documents and extract the necessary information to the output file.
     * </p>
     *
     * @param getTransformerRequest
     * @return A Java Future containing the result of the GetTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.GetTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTransformerResponse> getTransformer(GetTransformerRequest getTransformerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for the transformer specified by the transformer ID. A transformer describes how to process
     * the incoming EDI documents and extract the necessary information to the output file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransformerRequest.Builder} avoiding the need to
     * create one manually via {@link GetTransformerRequest#builder()}
     * </p>
     *
     * @param getTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GetTransformerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.GetTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTransformerResponse> getTransformer(Consumer<GetTransformerRequest.Builder> getTransformerRequest) {
        return getTransformer(GetTransformerRequest.builder().applyMutation(getTransformerRequest).build());
    }

    /**
     * <p>
     * Returns the details of the transformer run, based on the Transformer job ID.
     * </p>
     *
     * @param getTransformerJobRequest
     * @return A Java Future containing the result of the GetTransformerJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.GetTransformerJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformerJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTransformerJobResponse> getTransformerJob(GetTransformerJobRequest getTransformerJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the transformer run, based on the Transformer job ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransformerJobRequest.Builder} avoiding the need
     * to create one manually via {@link GetTransformerJobRequest#builder()}
     * </p>
     *
     * @param getTransformerJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.GetTransformerJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTransformerJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.GetTransformerJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/GetTransformerJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTransformerJobResponse> getTransformerJob(
            Consumer<GetTransformerJobRequest.Builder> getTransformerJobRequest) {
        return getTransformerJob(GetTransformerJobRequest.builder().applyMutation(getTransformerJobRequest).build());
    }

    /**
     * <p>
     * Lists the capabilities associated with your Amazon Web Services account for your current or specified region. A
     * trading capability contains the information required to transform incoming EDI documents into JSON or XML
     * outputs.
     * </p>
     *
     * @param listCapabilitiesRequest
     * @return A Java Future containing the result of the ListCapabilities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListCapabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListCapabilities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCapabilitiesResponse> listCapabilities(ListCapabilitiesRequest listCapabilitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the capabilities associated with your Amazon Web Services account for your current or specified region. A
     * trading capability contains the information required to transform incoming EDI documents into JSON or XML
     * outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCapabilitiesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCapabilitiesRequest#builder()}
     * </p>
     *
     * @param listCapabilitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCapabilities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListCapabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListCapabilities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCapabilitiesResponse> listCapabilities(
            Consumer<ListCapabilitiesRequest.Builder> listCapabilitiesRequest) {
        return listCapabilities(ListCapabilitiesRequest.builder().applyMutation(listCapabilitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCapabilities(software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesPublisher publisher = client.listCapabilitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesPublisher publisher = client.listCapabilitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.b2bi.model.ListCapabilitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.b2bi.model.ListCapabilitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCapabilities(software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest)} operation.</b>
     * </p>
     *
     * @param listCapabilitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListCapabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListCapabilities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCapabilitiesPublisher listCapabilitiesPaginator(ListCapabilitiesRequest listCapabilitiesRequest) {
        return new ListCapabilitiesPublisher(this, listCapabilitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCapabilities(software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesPublisher publisher = client.listCapabilitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListCapabilitiesPublisher publisher = client.listCapabilitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.b2bi.model.ListCapabilitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.b2bi.model.ListCapabilitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCapabilities(software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCapabilitiesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCapabilitiesRequest#builder()}
     * </p>
     *
     * @param listCapabilitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListCapabilitiesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListCapabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListCapabilities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCapabilitiesPublisher listCapabilitiesPaginator(Consumer<ListCapabilitiesRequest.Builder> listCapabilitiesRequest) {
        return listCapabilitiesPaginator(ListCapabilitiesRequest.builder().applyMutation(listCapabilitiesRequest).build());
    }

    /**
     * <p>
     * Lists the partnerships associated with your Amazon Web Services account for your current or specified region. A
     * partnership represents the connection between you and your trading partner. It ties together a profile and one or
     * more trading capabilities.
     * </p>
     *
     * @param listPartnershipsRequest
     * @return A Java Future containing the result of the ListPartnerships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListPartnerships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListPartnerships" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPartnershipsResponse> listPartnerships(ListPartnershipsRequest listPartnershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the partnerships associated with your Amazon Web Services account for your current or specified region. A
     * partnership represents the connection between you and your trading partner. It ties together a profile and one or
     * more trading capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnershipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPartnershipsRequest#builder()}
     * </p>
     *
     * @param listPartnershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPartnerships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListPartnerships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListPartnerships" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPartnershipsResponse> listPartnerships(
            Consumer<ListPartnershipsRequest.Builder> listPartnershipsRequest) {
        return listPartnerships(ListPartnershipsRequest.builder().applyMutation(listPartnershipsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPartnerships(software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsPublisher publisher = client.listPartnershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsPublisher publisher = client.listPartnershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.b2bi.model.ListPartnershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.b2bi.model.ListPartnershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPartnerships(software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest)} operation.</b>
     * </p>
     *
     * @param listPartnershipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListPartnerships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListPartnerships" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPartnershipsPublisher listPartnershipsPaginator(ListPartnershipsRequest listPartnershipsRequest) {
        return new ListPartnershipsPublisher(this, listPartnershipsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPartnerships(software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsPublisher publisher = client.listPartnershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListPartnershipsPublisher publisher = client.listPartnershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.b2bi.model.ListPartnershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.b2bi.model.ListPartnershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPartnerships(software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPartnershipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPartnershipsRequest#builder()}
     * </p>
     *
     * @param listPartnershipsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListPartnershipsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListPartnerships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListPartnerships" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPartnershipsPublisher listPartnershipsPaginator(Consumer<ListPartnershipsRequest.Builder> listPartnershipsRequest) {
        return listPartnershipsPaginator(ListPartnershipsRequest.builder().applyMutation(listPartnershipsRequest).build());
    }

    /**
     * <p>
     * Lists the profiles associated with your Amazon Web Services account for your current or specified region. A
     * profile is the mechanism used to create the concept of a private network.
     * </p>
     *
     * @param listProfilesRequest
     * @return A Java Future containing the result of the ListProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProfilesResponse> listProfiles(ListProfilesRequest listProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the profiles associated with your Amazon Web Services account for your current or specified region. A
     * profile is the mechanism used to create the concept of a private network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListProfilesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProfilesResponse> listProfiles(Consumer<ListProfilesRequest.Builder> listProfilesRequest) {
        return listProfiles(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listProfiles(software.amazon.awssdk.services.b2bi.model.ListProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.b2bi.model.ListProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.b2bi.model.ListProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.b2bi.model.ListProfilesRequest)} operation.</b>
     * </p>
     *
     * @param listProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesPublisher listProfilesPaginator(ListProfilesRequest listProfilesRequest) {
        return new ListProfilesPublisher(this, listProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listProfiles(software.amazon.awssdk.services.b2bi.model.ListProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.b2bi.model.ListProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.b2bi.model.ListProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.b2bi.model.ListProfilesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListProfilesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesPublisher listProfilesPaginator(Consumer<ListProfilesRequest.Builder> listProfilesRequest) {
        return listProfilesPaginator(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * capability, partnership, profile, or transformer.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * capability, partnership, profile, or transformer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the available transformers. A transformer describes how to process the incoming EDI documents and extract
     * the necessary information to the output file.
     * </p>
     *
     * @param listTransformersRequest
     * @return A Java Future containing the result of the ListTransformers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListTransformers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTransformersResponse> listTransformers(ListTransformersRequest listTransformersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available transformers. A transformer describes how to process the incoming EDI documents and extract
     * the necessary information to the output file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransformersRequest.Builder} avoiding the need
     * to create one manually via {@link ListTransformersRequest#builder()}
     * </p>
     *
     * @param listTransformersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListTransformersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTransformers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListTransformers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTransformersResponse> listTransformers(
            Consumer<ListTransformersRequest.Builder> listTransformersRequest) {
        return listTransformers(ListTransformersRequest.builder().applyMutation(listTransformersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTransformers(software.amazon.awssdk.services.b2bi.model.ListTransformersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListTransformersPublisher publisher = client.listTransformersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListTransformersPublisher publisher = client.listTransformersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.b2bi.model.ListTransformersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.b2bi.model.ListTransformersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransformers(software.amazon.awssdk.services.b2bi.model.ListTransformersRequest)} operation.</b>
     * </p>
     *
     * @param listTransformersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListTransformers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTransformersPublisher listTransformersPaginator(ListTransformersRequest listTransformersRequest) {
        return new ListTransformersPublisher(this, listTransformersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTransformers(software.amazon.awssdk.services.b2bi.model.ListTransformersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListTransformersPublisher publisher = client.listTransformersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.b2bi.paginators.ListTransformersPublisher publisher = client.listTransformersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.b2bi.model.ListTransformersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.b2bi.model.ListTransformersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransformers(software.amazon.awssdk.services.b2bi.model.ListTransformersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransformersRequest.Builder} avoiding the need
     * to create one manually via {@link ListTransformersRequest#builder()}
     * </p>
     *
     * @param listTransformersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.ListTransformersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.ListTransformers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/ListTransformers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTransformersPublisher listTransformersPaginator(Consumer<ListTransformersRequest.Builder> listTransformersRequest) {
        return listTransformersPaginator(ListTransformersRequest.builder().applyMutation(listTransformersRequest).build());
    }

    /**
     * <p>
     * Runs a job, using a transformer, to parse input EDI (electronic data interchange) file into the output structures
     * used by Amazon Web Services B2BI Data Interchange.
     * </p>
     * <p>
     * If you only want to transform EDI (electronic data interchange) documents, you don't need to create profiles,
     * partnerships or capabilities. Just create and configure a transformer, and then run the
     * <code>StartTransformerJob</code> API to process your files.
     * </p>
     *
     * @param startTransformerJobRequest
     * @return A Java Future containing the result of the StartTransformerJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.StartTransformerJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/StartTransformerJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartTransformerJobResponse> startTransformerJob(
            StartTransformerJobRequest startTransformerJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs a job, using a transformer, to parse input EDI (electronic data interchange) file into the output structures
     * used by Amazon Web Services B2BI Data Interchange.
     * </p>
     * <p>
     * If you only want to transform EDI (electronic data interchange) documents, you don't need to create profiles,
     * partnerships or capabilities. Just create and configure a transformer, and then run the
     * <code>StartTransformerJob</code> API to process your files.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTransformerJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartTransformerJobRequest#builder()}
     * </p>
     *
     * @param startTransformerJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.StartTransformerJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartTransformerJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.StartTransformerJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/StartTransformerJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartTransformerJobResponse> startTransformerJob(
            Consumer<StartTransformerJobRequest.Builder> startTransformerJobRequest) {
        return startTransformerJob(StartTransformerJobRequest.builder().applyMutation(startTransformerJobRequest).build());
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are
     * capability, partnership, profile, transformers and other entities.
     * </p>
     * <p>
     * There is no response returned from this call.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are
     * capability, partnership, profile, transformers and other entities.
     * </p>
     * <p>
     * There is no response returned from this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Maps the input file according to the provided template file. The API call downloads the file contents from the
     * Amazon S3 location, and passes the contents in as a string, to the <code>inputFileContent</code> parameter.
     * </p>
     *
     * @param testMappingRequest
     * @return A Java Future containing the result of the TestMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.TestMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestMapping" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestMappingResponse> testMapping(TestMappingRequest testMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Maps the input file according to the provided template file. The API call downloads the file contents from the
     * Amazon S3 location, and passes the contents in as a string, to the <code>inputFileContent</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestMappingRequest.Builder} avoiding the need to
     * create one manually via {@link TestMappingRequest#builder()}
     * </p>
     *
     * @param testMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.TestMappingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TestMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.TestMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestMapping" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestMappingResponse> testMapping(Consumer<TestMappingRequest.Builder> testMappingRequest) {
        return testMapping(TestMappingRequest.builder().applyMutation(testMappingRequest).build());
    }

    /**
     * <p>
     * Parses the input EDI (electronic data interchange) file. The input file has a file size limit of 250 KB.
     * </p>
     *
     * @param testParsingRequest
     * @return A Java Future containing the result of the TestParsing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.TestParsing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestParsing" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestParsingResponse> testParsing(TestParsingRequest testParsingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Parses the input EDI (electronic data interchange) file. The input file has a file size limit of 250 KB.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestParsingRequest.Builder} avoiding the need to
     * create one manually via {@link TestParsingRequest#builder()}
     * </p>
     *
     * @param testParsingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.TestParsingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TestParsing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.TestParsing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TestParsing" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestParsingResponse> testParsing(Consumer<TestParsingRequest.Builder> testParsingRequest) {
        return testParsing(TestParsingRequest.builder().applyMutation(testParsingRequest).build());
    }

    /**
     * <p>
     * Detaches a key-value pair from the specified resource, as identified by its Amazon Resource Name (ARN). Resources
     * are capability, partnership, profile, transformers and other entities.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a key-value pair from the specified resource, as identified by its Amazon Resource Name (ARN). Resources
     * are capability, partnership, profile, transformers and other entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters for a capability, based on the specified parameters. A trading capability contains
     * the information required to transform incoming EDI documents into JSON or XML outputs.
     * </p>
     *
     * @param updateCapabilityRequest
     * @return A Java Future containing the result of the UpdateCapability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.UpdateCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateCapabilityResponse> updateCapability(UpdateCapabilityRequest updateCapabilityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters for a capability, based on the specified parameters. A trading capability contains
     * the information required to transform incoming EDI documents into JSON or XML outputs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCapabilityRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCapabilityRequest#builder()}
     * </p>
     *
     * @param updateCapabilityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.UpdateCapabilityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCapability operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.UpdateCapability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateCapability" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateCapabilityResponse> updateCapability(
            Consumer<UpdateCapabilityRequest.Builder> updateCapabilityRequest) {
        return updateCapability(UpdateCapabilityRequest.builder().applyMutation(updateCapabilityRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters for a partnership between a customer and trading partner. A partnership represents
     * the connection between you and your trading partner. It ties together a profile and one or more trading
     * capabilities.
     * </p>
     *
     * @param updatePartnershipRequest
     * @return A Java Future containing the result of the UpdatePartnership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.UpdatePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdatePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePartnershipResponse> updatePartnership(UpdatePartnershipRequest updatePartnershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters for a partnership between a customer and trading partner. A partnership represents
     * the connection between you and your trading partner. It ties together a profile and one or more trading
     * capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePartnershipRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePartnershipRequest#builder()}
     * </p>
     *
     * @param updatePartnershipRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.UpdatePartnershipRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdatePartnership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.UpdatePartnership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdatePartnership" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdatePartnershipResponse> updatePartnership(
            Consumer<UpdatePartnershipRequest.Builder> updatePartnershipRequest) {
        return updatePartnership(UpdatePartnershipRequest.builder().applyMutation(updatePartnershipRequest).build());
    }

    /**
     * <p>
     * Updates the specified parameters for a profile. A profile is the mechanism used to create the concept of a
     * private network.
     * </p>
     *
     * @param updateProfileRequest
     * @return A Java Future containing the result of the UpdateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProfileResponse> updateProfile(UpdateProfileRequest updateProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified parameters for a profile. A profile is the mechanism used to create the concept of a
     * private network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProfileRequest#builder()}
     * </p>
     *
     * @param updateProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.UpdateProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProfileResponse> updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest) {
        return updateProfile(UpdateProfileRequest.builder().applyMutation(updateProfileRequest).build());
    }

    /**
     * <p>
     * Updates the specified parameters for a transformer. A transformer describes how to process the incoming EDI
     * documents and extract the necessary information to the output file.
     * </p>
     *
     * @param updateTransformerRequest
     * @return A Java Future containing the result of the UpdateTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.UpdateTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTransformerResponse> updateTransformer(UpdateTransformerRequest updateTransformerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified parameters for a transformer. A transformer describes how to process the incoming EDI
     * documents and extract the necessary information to the output file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTransformerRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTransformerRequest#builder()}
     * </p>
     *
     * @param updateTransformerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.b2bi.model.UpdateTransformerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTransformer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict exception is thrown when you attempt to delete a resource (such as a
     *         profile or a capability) that is being used by other resources.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException Occurs when a B2BI object cannot be validated against a request from another
     *         object.</li>
     *         <li>ThrottlingException The request was denied due to throttling: the data speed and rendering may be
     *         limited depending on various parameters and conditions.</li>
     *         <li>ResourceNotFoundException Occurs when the requested resource does not exist, or cannot be found. In
     *         some cases, the resource exists in a region other than the region specified in the API call.</li>
     *         <li>ServiceQuotaExceededException Occurs when the calling command attempts to exceed one of the service
     *         quotas, for example trying to create a capability when you already have the maximum number of
     *         capabilities allowed.</li>
     *         <li>InternalServerException This exception is thrown when an error occurs in the Amazon Web Services B2B
     *         Data Interchange service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>B2BiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample B2BiAsyncClient.UpdateTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/UpdateTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTransformerResponse> updateTransformer(
            Consumer<UpdateTransformerRequest.Builder> updateTransformerRequest) {
        return updateTransformer(UpdateTransformerRequest.builder().applyMutation(updateTransformerRequest).build());
    }

    @Override
    default B2BiServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link B2BiAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static B2BiAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link B2BiAsyncClient}.
     */
    static B2BiAsyncClientBuilder builder() {
        return new DefaultB2BiAsyncClientBuilder();
    }
}
