/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCapabilityResponse extends B2BiResponse implements
        ToCopyableBuilder<UpdateCapabilityResponse.Builder, UpdateCapabilityResponse> {
    private static final SdkField<String> CAPABILITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilityId").getter(getter(UpdateCapabilityResponse::capabilityId))
            .setter(setter(Builder::capabilityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityId").build()).build();

    private static final SdkField<String> CAPABILITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilityArn").getter(getter(UpdateCapabilityResponse::capabilityArn))
            .setter(setter(Builder::capabilityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateCapabilityResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UpdateCapabilityResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<CapabilityConfiguration> CONFIGURATION_FIELD = SdkField
            .<CapabilityConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateCapabilityResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(CapabilityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<List<S3Location>> INSTRUCTIONS_DOCUMENTS_FIELD = SdkField
            .<List<S3Location>> builder(MarshallingType.LIST)
            .memberName("instructionsDocuments")
            .getter(getter(UpdateCapabilityResponse::instructionsDocuments))
            .setter(setter(Builder::instructionsDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructionsDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Location::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(UpdateCapabilityResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedAt")
            .getter(getter(UpdateCapabilityResponse::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_ID_FIELD,
            CAPABILITY_ARN_FIELD, NAME_FIELD, TYPE_FIELD, CONFIGURATION_FIELD, INSTRUCTIONS_DOCUMENTS_FIELD, CREATED_AT_FIELD,
            MODIFIED_AT_FIELD));

    private final String capabilityId;

    private final String capabilityArn;

    private final String name;

    private final String type;

    private final CapabilityConfiguration configuration;

    private final List<S3Location> instructionsDocuments;

    private final Instant createdAt;

    private final Instant modifiedAt;

    private UpdateCapabilityResponse(BuilderImpl builder) {
        super(builder);
        this.capabilityId = builder.capabilityId;
        this.capabilityArn = builder.capabilityArn;
        this.name = builder.name;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.instructionsDocuments = builder.instructionsDocuments;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
    }

    /**
     * <p>
     * Returns a system-assigned unique identifier for the capability.
     * </p>
     * 
     * @return Returns a system-assigned unique identifier for the capability.
     */
    public final String capabilityId() {
        return capabilityId;
    }

    /**
     * <p>
     * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
     * partnership, profile, or transformer.
     * </p>
     * 
     * @return Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
     *         partnership, profile, or transformer.
     */
    public final String capabilityArn() {
        return capabilityArn;
    }

    /**
     * <p>
     * Returns the name of the capability, used to identify it.
     * </p>
     * 
     * @return Returns the name of the capability, used to identify it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Returns the type of the capability. Currently, only <code>edi</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Returns the type of the capability. Currently, only <code>edi</code> is supported.
     * @see CapabilityType
     */
    public final CapabilityType type() {
        return CapabilityType.fromValue(type);
    }

    /**
     * <p>
     * Returns the type of the capability. Currently, only <code>edi</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Returns the type of the capability. Currently, only <code>edi</code> is supported.
     * @see CapabilityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Returns a structure that contains the details for a capability.
     * </p>
     * 
     * @return Returns a structure that contains the details for a capability.
     */
    public final CapabilityConfiguration configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstructionsDocuments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInstructionsDocuments() {
        return instructionsDocuments != null && !(instructionsDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this
     * capability. Each item contains the name of the bucket and the key, to identify the document's location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstructionsDocuments} method.
     * </p>
     * 
     * @return Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this
     *         capability. Each item contains the name of the bucket and the key, to identify the document's location.
     */
    public final List<S3Location> instructionsDocuments() {
        return instructionsDocuments;
    }

    /**
     * <p>
     * Returns a timestamp for creation date and time of the capability.
     * </p>
     * 
     * @return Returns a timestamp for creation date and time of the capability.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Returns a timestamp for last time the capability was modified.
     * </p>
     * 
     * @return Returns a timestamp for last time the capability was modified.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(capabilityArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstructionsDocuments() ? instructionsDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapabilityResponse)) {
            return false;
        }
        UpdateCapabilityResponse other = (UpdateCapabilityResponse) obj;
        return Objects.equals(capabilityId(), other.capabilityId()) && Objects.equals(capabilityArn(), other.capabilityArn())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(configuration(), other.configuration())
                && hasInstructionsDocuments() == other.hasInstructionsDocuments()
                && Objects.equals(instructionsDocuments(), other.instructionsDocuments())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(modifiedAt(), other.modifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCapabilityResponse").add("CapabilityId", capabilityId())
                .add("CapabilityArn", capabilityArn()).add("Name", name()).add("Type", typeAsString())
                .add("Configuration", configuration())
                .add("InstructionsDocuments", hasInstructionsDocuments() ? instructionsDocuments() : null)
                .add("CreatedAt", createdAt()).add("ModifiedAt", modifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capabilityId":
            return Optional.ofNullable(clazz.cast(capabilityId()));
        case "capabilityArn":
            return Optional.ofNullable(clazz.cast(capabilityArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "instructionsDocuments":
            return Optional.ofNullable(clazz.cast(instructionsDocuments()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "modifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCapabilityResponse, T> g) {
        return obj -> g.apply((UpdateCapabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCapabilityResponse> {
        /**
         * <p>
         * Returns a system-assigned unique identifier for the capability.
         * </p>
         * 
         * @param capabilityId
         *        Returns a system-assigned unique identifier for the capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityId(String capabilityId);

        /**
         * <p>
         * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
         * partnership, profile, or transformer.
         * </p>
         * 
         * @param capabilityArn
         *        Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a
         *        capability, partnership, profile, or transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityArn(String capabilityArn);

        /**
         * <p>
         * Returns the name of the capability, used to identify it.
         * </p>
         * 
         * @param name
         *        Returns the name of the capability, used to identify it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Returns the type of the capability. Currently, only <code>edi</code> is supported.
         * </p>
         * 
         * @param type
         *        Returns the type of the capability. Currently, only <code>edi</code> is supported.
         * @see CapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityType
         */
        Builder type(String type);

        /**
         * <p>
         * Returns the type of the capability. Currently, only <code>edi</code> is supported.
         * </p>
         * 
         * @param type
         *        Returns the type of the capability. Currently, only <code>edi</code> is supported.
         * @see CapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityType
         */
        Builder type(CapabilityType type);

        /**
         * <p>
         * Returns a structure that contains the details for a capability.
         * </p>
         * 
         * @param configuration
         *        Returns a structure that contains the details for a capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(CapabilityConfiguration configuration);

        /**
         * <p>
         * Returns a structure that contains the details for a capability.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapabilityConfiguration.Builder} avoiding
         * the need to create one manually via {@link CapabilityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapabilityConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(CapabilityConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link CapabilityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(CapabilityConfiguration)
         */
        default Builder configuration(Consumer<CapabilityConfiguration.Builder> configuration) {
            return configuration(CapabilityConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         * capability. Each item contains the name of the bucket and the key, to identify the document's location.
         * </p>
         * 
         * @param instructionsDocuments
         *        Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         *        capability. Each item contains the name of the bucket and the key, to identify the document's
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructionsDocuments(Collection<S3Location> instructionsDocuments);

        /**
         * <p>
         * Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         * capability. Each item contains the name of the bucket and the key, to identify the document's location.
         * </p>
         * 
         * @param instructionsDocuments
         *        Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         *        capability. Each item contains the name of the bucket and the key, to identify the document's
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructionsDocuments(S3Location... instructionsDocuments);

        /**
         * <p>
         * Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         * capability. Each item contains the name of the bucket and the key, to identify the document's location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.b2bi.model.S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder#build()} is called immediately and its
         * result is passed to {@link #instructionsDocuments(List<S3Location>)}.
         * 
         * @param instructionsDocuments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instructionsDocuments(java.util.Collection<S3Location>)
         */
        Builder instructionsDocuments(Consumer<S3Location.Builder>... instructionsDocuments);

        /**
         * <p>
         * Returns a timestamp for creation date and time of the capability.
         * </p>
         * 
         * @param createdAt
         *        Returns a timestamp for creation date and time of the capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Returns a timestamp for last time the capability was modified.
         * </p>
         * 
         * @param modifiedAt
         *        Returns a timestamp for last time the capability was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private String capabilityId;

        private String capabilityArn;

        private String name;

        private String type;

        private CapabilityConfiguration configuration;

        private List<S3Location> instructionsDocuments = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant modifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCapabilityResponse model) {
            super(model);
            capabilityId(model.capabilityId);
            capabilityArn(model.capabilityArn);
            name(model.name);
            type(model.type);
            configuration(model.configuration);
            instructionsDocuments(model.instructionsDocuments);
            createdAt(model.createdAt);
            modifiedAt(model.modifiedAt);
        }

        public final String getCapabilityId() {
            return capabilityId;
        }

        public final void setCapabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
        }

        @Override
        public final Builder capabilityId(String capabilityId) {
            this.capabilityId = capabilityId;
            return this;
        }

        public final String getCapabilityArn() {
            return capabilityArn;
        }

        public final void setCapabilityArn(String capabilityArn) {
            this.capabilityArn = capabilityArn;
        }

        @Override
        public final Builder capabilityArn(String capabilityArn) {
            this.capabilityArn = capabilityArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CapabilityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CapabilityConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(CapabilityConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CapabilityConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<S3Location.Builder> getInstructionsDocuments() {
            List<S3Location.Builder> result = InstructionsDocumentsCopier.copyToBuilder(this.instructionsDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstructionsDocuments(Collection<S3Location.BuilderImpl> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copyFromBuilder(instructionsDocuments);
        }

        @Override
        public final Builder instructionsDocuments(Collection<S3Location> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copy(instructionsDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(S3Location... instructionsDocuments) {
            instructionsDocuments(Arrays.asList(instructionsDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(Consumer<S3Location.Builder>... instructionsDocuments) {
            instructionsDocuments(Stream.of(instructionsDocuments).map(c -> S3Location.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public UpdateCapabilityResponse build() {
            return new UpdateCapabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
