/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransformerRequest extends B2BiRequest implements
        ToCopyableBuilder<CreateTransformerRequest.Builder, CreateTransformerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateTransformerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(CreateTransformerRequest::fileFormatAsString))
            .setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mappingTemplate").getter(getter(CreateTransformerRequest::mappingTemplate))
            .setter(setter(Builder::mappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()).build();

    private static final SdkField<EdiType> EDI_TYPE_FIELD = SdkField.<EdiType> builder(MarshallingType.SDK_POJO)
            .memberName("ediType").getter(getter(CreateTransformerRequest::ediType)).setter(setter(Builder::ediType))
            .constructor(EdiType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ediType").build()).build();

    private static final SdkField<String> SAMPLE_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleDocument").getter(getter(CreateTransformerRequest::sampleDocument))
            .setter(setter(Builder::sampleDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocument").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateTransformerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateTransformerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FILE_FORMAT_FIELD,
            MAPPING_TEMPLATE_FIELD, EDI_TYPE_FIELD, SAMPLE_DOCUMENT_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String name;

    private final String fileFormat;

    private final String mappingTemplate;

    private final EdiType ediType;

    private final String sampleDocument;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateTransformerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.fileFormat = builder.fileFormat;
        this.mappingTemplate = builder.mappingTemplate;
        this.ediType = builder.ediType;
        this.sampleDocument = builder.sampleDocument;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies the name of the transformer, used to identify it.
     * </p>
     * 
     * @return Specifies the name of the transformer, used to identify it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     */
    public final FileFormat fileFormat() {
        return FileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * Specifies the mapping template for the transformer. This template is used to map the parsed EDI file using
     * JSONata or XSLT.
     * </p>
     * 
     * @return Specifies the mapping template for the transformer. This template is used to map the parsed EDI file
     *         using JSONata or XSLT.
     */
    public final String mappingTemplate() {
        return mappingTemplate;
    }

    /**
     * <p>
     * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @return Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *         supported. X12 is a set of standards and corresponding messages that define specific business documents.
     */
    public final EdiType ediType() {
        return ediType;
    }

    /**
     * <p>
     * Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * </p>
     * 
     * @return Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     */
    public final String sampleDocument() {
        return sampleDocument;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You
     * can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
     *         type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(ediType());
        hashCode = 31 * hashCode + Objects.hashCode(sampleDocument());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransformerRequest)) {
            return false;
        }
        CreateTransformerRequest other = (CreateTransformerRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(mappingTemplate(), other.mappingTemplate()) && Objects.equals(ediType(), other.ediType())
                && Objects.equals(sampleDocument(), other.sampleDocument()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransformerRequest").add("Name", name()).add("FileFormat", fileFormatAsString())
                .add("MappingTemplate", mappingTemplate()).add("EdiType", ediType()).add("SampleDocument", sampleDocument())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "mappingTemplate":
            return Optional.ofNullable(clazz.cast(mappingTemplate()));
        case "ediType":
            return Optional.ofNullable(clazz.cast(ediType()));
        case "sampleDocument":
            return Optional.ofNullable(clazz.cast(sampleDocument()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransformerRequest, T> g) {
        return obj -> g.apply((CreateTransformerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTransformerRequest> {
        /**
         * <p>
         * Specifies the name of the transformer, used to identify it.
         * </p>
         * 
         * @param name
         *        Specifies the name of the transformer, used to identify it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(FileFormat fileFormat);

        /**
         * <p>
         * Specifies the mapping template for the transformer. This template is used to map the parsed EDI file using
         * JSONata or XSLT.
         * </p>
         * 
         * @param mappingTemplate
         *        Specifies the mapping template for the transformer. This template is used to map the parsed EDI file
         *        using JSONata or XSLT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingTemplate(String mappingTemplate);

        /**
         * <p>
         * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * 
         * @param ediType
         *        Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12
         *        is supported. X12 is a set of standards and corresponding messages that define specific business
         *        documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ediType(EdiType ediType);

        /**
         * <p>
         * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdiType.Builder} avoiding the need to
         * create one manually via {@link EdiType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdiType.Builder#build()} is called immediately and its result is
         * passed to {@link #ediType(EdiType)}.
         * 
         * @param ediType
         *        a consumer that will call methods on {@link EdiType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ediType(EdiType)
         */
        default Builder ediType(Consumer<EdiType.Builder> ediType) {
            return ediType(EdiType.builder().applyMutation(ediType).build());
        }

        /**
         * <p>
         * Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
         * </p>
         * 
         * @param sampleDocument
         *        Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleDocument(String sampleDocument);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param clientToken
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
         *        type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any
         *        purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
         *        type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any
         *        purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.b2bi.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String name;

        private String fileFormat;

        private String mappingTemplate;

        private EdiType ediType;

        private String sampleDocument;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransformerRequest model) {
            super(model);
            name(model.name);
            fileFormat(model.fileFormat);
            mappingTemplate(model.mappingTemplate);
            ediType(model.ediType);
            sampleDocument(model.sampleDocument);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getMappingTemplate() {
            return mappingTemplate;
        }

        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        public final EdiType.Builder getEdiType() {
            return ediType != null ? ediType.toBuilder() : null;
        }

        public final void setEdiType(EdiType.BuilderImpl ediType) {
            this.ediType = ediType != null ? ediType.build() : null;
        }

        @Override
        public final Builder ediType(EdiType ediType) {
            this.ediType = ediType;
            return this;
        }

        public final String getSampleDocument() {
            return sampleDocument;
        }

        public final void setSampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
        }

        @Override
        public final Builder sampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransformerRequest build() {
            return new CreateTransformerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
