/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.EdiType;
import software.amazon.awssdk.services.b2bi.model.FileFormat;
import software.amazon.awssdk.services.b2bi.model.InputConversion;
import software.amazon.awssdk.services.b2bi.model.Mapping;
import software.amazon.awssdk.services.b2bi.model.OutputConversion;
import software.amazon.awssdk.services.b2bi.model.SampleDocuments;
import software.amazon.awssdk.services.b2bi.model.Tag;
import software.amazon.awssdk.services.b2bi.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransformerRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, CreateTransformerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateTransformerRequest.getter(CreateTransformerRequest::name)).setter(CreateTransformerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateTransformerRequest.getter(CreateTransformerRequest::clientToken)).setter(CreateTransformerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateTransformerRequest.getter(CreateTransformerRequest::tags)).setter(CreateTransformerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(CreateTransformerRequest.getter(CreateTransformerRequest::fileFormatAsString)).setter(CreateTransformerRequest.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mappingTemplate").getter(CreateTransformerRequest.getter(CreateTransformerRequest::mappingTemplate)).setter(CreateTransformerRequest.setter(Builder::mappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()}).build();
    private static final SdkField<EdiType> EDI_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ediType").getter(CreateTransformerRequest.getter(CreateTransformerRequest::ediType)).setter(CreateTransformerRequest.setter(Builder::ediType)).constructor(EdiType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ediType").build()}).build();
    private static final SdkField<String> SAMPLE_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleDocument").getter(CreateTransformerRequest.getter(CreateTransformerRequest::sampleDocument)).setter(CreateTransformerRequest.setter(Builder::sampleDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocument").build()}).build();
    private static final SdkField<InputConversion> INPUT_CONVERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputConversion").getter(CreateTransformerRequest.getter(CreateTransformerRequest::inputConversion)).setter(CreateTransformerRequest.setter(Builder::inputConversion)).constructor(InputConversion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConversion").build()}).build();
    private static final SdkField<Mapping> MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mapping").getter(CreateTransformerRequest.getter(CreateTransformerRequest::mapping)).setter(CreateTransformerRequest.setter(Builder::mapping)).constructor(Mapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapping").build()}).build();
    private static final SdkField<OutputConversion> OUTPUT_CONVERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConversion").getter(CreateTransformerRequest.getter(CreateTransformerRequest::outputConversion)).setter(CreateTransformerRequest.setter(Builder::outputConversion)).constructor(OutputConversion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConversion").build()}).build();
    private static final SdkField<SampleDocuments> SAMPLE_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sampleDocuments").getter(CreateTransformerRequest.getter(CreateTransformerRequest::sampleDocuments)).setter(CreateTransformerRequest.setter(Builder::sampleDocuments)).constructor(SampleDocuments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocuments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, FILE_FORMAT_FIELD, MAPPING_TEMPLATE_FIELD, EDI_TYPE_FIELD, SAMPLE_DOCUMENT_FIELD, INPUT_CONVERSION_FIELD, MAPPING_FIELD, OUTPUT_CONVERSION_FIELD, SAMPLE_DOCUMENTS_FIELD));
    private final String name;
    private final String clientToken;
    private final List<Tag> tags;
    private final String fileFormat;
    private final String mappingTemplate;
    private final EdiType ediType;
    private final String sampleDocument;
    private final InputConversion inputConversion;
    private final Mapping mapping;
    private final OutputConversion outputConversion;
    private final SampleDocuments sampleDocuments;

    private CreateTransformerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.fileFormat = builder.fileFormat;
        this.mappingTemplate = builder.mappingTemplate;
        this.ediType = builder.ediType;
        this.sampleDocument = builder.sampleDocument;
        this.inputConversion = builder.inputConversion;
        this.mapping = builder.mapping;
        this.outputConversion = builder.outputConversion;
        this.sampleDocuments = builder.sampleDocuments;
    }

    public final String name() {
        return this.name;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Deprecated
    public final FileFormat fileFormat() {
        return FileFormat.fromValue(this.fileFormat);
    }

    @Deprecated
    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    @Deprecated
    public final String mappingTemplate() {
        return this.mappingTemplate;
    }

    @Deprecated
    public final EdiType ediType() {
        return this.ediType;
    }

    @Deprecated
    public final String sampleDocument() {
        return this.sampleDocument;
    }

    public final InputConversion inputConversion() {
        return this.inputConversion;
    }

    public final Mapping mapping() {
        return this.mapping;
    }

    public final OutputConversion outputConversion() {
        return this.outputConversion;
    }

    public final SampleDocuments sampleDocuments() {
        return this.sampleDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.ediType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConversion());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConversion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleDocuments());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransformerRequest)) {
            return false;
        }
        CreateTransformerRequest other = (CreateTransformerRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.mappingTemplate(), other.mappingTemplate()) && Objects.equals(this.ediType(), other.ediType()) && Objects.equals(this.sampleDocument(), other.sampleDocument()) && Objects.equals(this.inputConversion(), other.inputConversion()) && Objects.equals(this.mapping(), other.mapping()) && Objects.equals(this.outputConversion(), other.outputConversion()) && Objects.equals(this.sampleDocuments(), other.sampleDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransformerRequest").add("Name", (Object)this.name()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("FileFormat", (Object)this.fileFormatAsString()).add("MappingTemplate", (Object)this.mappingTemplate()).add("EdiType", (Object)this.ediType()).add("SampleDocument", (Object)this.sampleDocument()).add("InputConversion", (Object)this.inputConversion()).add("Mapping", (Object)this.mapping()).add("OutputConversion", (Object)this.outputConversion()).add("SampleDocuments", (Object)this.sampleDocuments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "mappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.mappingTemplate()));
            }
            case "ediType": {
                return Optional.ofNullable(clazz.cast(this.ediType()));
            }
            case "sampleDocument": {
                return Optional.ofNullable(clazz.cast(this.sampleDocument()));
            }
            case "inputConversion": {
                return Optional.ofNullable(clazz.cast(this.inputConversion()));
            }
            case "mapping": {
                return Optional.ofNullable(clazz.cast(this.mapping()));
            }
            case "outputConversion": {
                return Optional.ofNullable(clazz.cast(this.outputConversion()));
            }
            case "sampleDocuments": {
                return Optional.ofNullable(clazz.cast(this.sampleDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransformerRequest, T> g) {
        return obj -> g.apply((CreateTransformerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private String name;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String fileFormat;
        private String mappingTemplate;
        private EdiType ediType;
        private String sampleDocument;
        private InputConversion inputConversion;
        private Mapping mapping;
        private OutputConversion outputConversion;
        private SampleDocuments sampleDocuments;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransformerRequest model) {
            super(model);
            this.name(model.name);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.fileFormat(model.fileFormat);
            this.mappingTemplate(model.mappingTemplate);
            this.ediType(model.ediType);
            this.sampleDocument(model.sampleDocument);
            this.inputConversion(model.inputConversion);
            this.mapping(model.mapping);
            this.outputConversion(model.outputConversion);
            this.sampleDocuments(model.sampleDocuments);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final String getFileFormat() {
            return this.fileFormat;
        }

        @Deprecated
        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        @Deprecated
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        @Deprecated
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        @Deprecated
        public final String getMappingTemplate() {
            return this.mappingTemplate;
        }

        @Deprecated
        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        @Deprecated
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        @Deprecated
        public final EdiType.Builder getEdiType() {
            return this.ediType != null ? this.ediType.toBuilder() : null;
        }

        @Deprecated
        public final void setEdiType(EdiType.BuilderImpl ediType) {
            this.ediType = ediType != null ? ediType.build() : null;
        }

        @Override
        @Deprecated
        public final Builder ediType(EdiType ediType) {
            this.ediType = ediType;
            return this;
        }

        @Deprecated
        public final String getSampleDocument() {
            return this.sampleDocument;
        }

        @Deprecated
        public final void setSampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
        }

        @Override
        @Deprecated
        public final Builder sampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
            return this;
        }

        public final InputConversion.Builder getInputConversion() {
            return this.inputConversion != null ? this.inputConversion.toBuilder() : null;
        }

        public final void setInputConversion(InputConversion.BuilderImpl inputConversion) {
            this.inputConversion = inputConversion != null ? inputConversion.build() : null;
        }

        @Override
        public final Builder inputConversion(InputConversion inputConversion) {
            this.inputConversion = inputConversion;
            return this;
        }

        public final Mapping.Builder getMapping() {
            return this.mapping != null ? this.mapping.toBuilder() : null;
        }

        public final void setMapping(Mapping.BuilderImpl mapping) {
            this.mapping = mapping != null ? mapping.build() : null;
        }

        @Override
        public final Builder mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public final OutputConversion.Builder getOutputConversion() {
            return this.outputConversion != null ? this.outputConversion.toBuilder() : null;
        }

        public final void setOutputConversion(OutputConversion.BuilderImpl outputConversion) {
            this.outputConversion = outputConversion != null ? outputConversion.build() : null;
        }

        @Override
        public final Builder outputConversion(OutputConversion outputConversion) {
            this.outputConversion = outputConversion;
            return this;
        }

        public final SampleDocuments.Builder getSampleDocuments() {
            return this.sampleDocuments != null ? this.sampleDocuments.toBuilder() : null;
        }

        public final void setSampleDocuments(SampleDocuments.BuilderImpl sampleDocuments) {
            this.sampleDocuments = sampleDocuments != null ? sampleDocuments.build() : null;
        }

        @Override
        public final Builder sampleDocuments(SampleDocuments sampleDocuments) {
            this.sampleDocuments = sampleDocuments;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransformerRequest build() {
            return new CreateTransformerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransformerRequest> {
        public Builder name(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        @Deprecated
        public Builder fileFormat(String var1);

        @Deprecated
        public Builder fileFormat(FileFormat var1);

        @Deprecated
        public Builder mappingTemplate(String var1);

        @Deprecated
        public Builder ediType(EdiType var1);

        @Deprecated
        default public Builder ediType(Consumer<EdiType.Builder> ediType) {
            return this.ediType((EdiType)((EdiType.Builder)EdiType.builder().applyMutation(ediType)).build());
        }

        @Deprecated
        public Builder sampleDocument(String var1);

        public Builder inputConversion(InputConversion var1);

        default public Builder inputConversion(Consumer<InputConversion.Builder> inputConversion) {
            return this.inputConversion((InputConversion)((InputConversion.Builder)InputConversion.builder().applyMutation(inputConversion)).build());
        }

        public Builder mapping(Mapping var1);

        default public Builder mapping(Consumer<Mapping.Builder> mapping) {
            return this.mapping((Mapping)((Mapping.Builder)Mapping.builder().applyMutation(mapping)).build());
        }

        public Builder outputConversion(OutputConversion var1);

        default public Builder outputConversion(Consumer<OutputConversion.Builder> outputConversion) {
            return this.outputConversion((OutputConversion)((OutputConversion.Builder)OutputConversion.builder().applyMutation(outputConversion)).build());
        }

        public Builder sampleDocuments(SampleDocuments var1);

        default public Builder sampleDocuments(Consumer<SampleDocuments.Builder> sampleDocuments) {
            return this.sampleDocuments((SampleDocuments)((SampleDocuments.Builder)SampleDocuments.builder().applyMutation(sampleDocuments)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

