/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.b2bi.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputSampleFileSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputSampleFileSource> {
    private static final SdkField<S3Location> FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fileLocation").getter(OutputSampleFileSource.getter(OutputSampleFileSource::fileLocation)).setter(OutputSampleFileSource.setter(Builder::fileLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3Location fileLocation;
    private final Type type;

    private OutputSampleFileSource(BuilderImpl builder) {
        this.fileLocation = builder.fileLocation;
        this.type = builder.type;
    }

    public final S3Location fileLocation() {
        return this.fileLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSampleFileSource)) {
            return false;
        }
        OutputSampleFileSource other = (OutputSampleFileSource)obj;
        return Objects.equals(this.fileLocation(), other.fileLocation());
    }

    public final String toString() {
        return ToString.builder((String)"OutputSampleFileSource").add("FileLocation", (Object)this.fileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileLocation": {
                return Optional.ofNullable(clazz.cast(this.fileLocation()));
            }
        }
        return Optional.empty();
    }

    public static OutputSampleFileSource fromFileLocation(S3Location fileLocation) {
        return (OutputSampleFileSource)OutputSampleFileSource.builder().fileLocation(fileLocation).build();
    }

    public static OutputSampleFileSource fromFileLocation(Consumer<S3Location.Builder> fileLocation) {
        S3Location.Builder builder = S3Location.builder();
        fileLocation.accept(builder);
        return OutputSampleFileSource.fromFileLocation((S3Location)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputSampleFileSource, T> g) {
        return obj -> g.apply((OutputSampleFileSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FILE_LOCATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private S3Location fileLocation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSampleFileSource model) {
            this.fileLocation(model.fileLocation);
        }

        public final S3Location.Builder getFileLocation() {
            return this.fileLocation != null ? this.fileLocation.toBuilder() : null;
        }

        public final void setFileLocation(S3Location.BuilderImpl fileLocation) {
            S3Location oldValue = this.fileLocation;
            this.fileLocation = fileLocation != null ? fileLocation.build() : null;
            this.handleUnionValueChange(Type.FILE_LOCATION, oldValue, this.fileLocation);
        }

        @Override
        public final Builder fileLocation(S3Location fileLocation) {
            S3Location oldValue = this.fileLocation;
            this.fileLocation = fileLocation;
            this.handleUnionValueChange(Type.FILE_LOCATION, oldValue, this.fileLocation);
            return this;
        }

        public OutputSampleFileSource build() {
            return new OutputSampleFileSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputSampleFileSource> {
        public Builder fileLocation(S3Location var1);

        default public Builder fileLocation(Consumer<S3Location.Builder> fileLocation) {
            return this.fileLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(fileLocation)).build());
        }
    }
}

