/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.ConversionSource;
import software.amazon.awssdk.services.b2bi.model.ConversionTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestConversionRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, TestConversionRequest> {
    private static final SdkField<ConversionSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(TestConversionRequest.getter(TestConversionRequest::source)).setter(TestConversionRequest.setter(Builder::source)).constructor(ConversionSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<ConversionTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("target").getter(TestConversionRequest.getter(TestConversionRequest::target)).setter(TestConversionRequest.setter(Builder::target)).constructor(ConversionTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGET_FIELD));
    private final ConversionSource source;
    private final ConversionTarget target;

    private TestConversionRequest(BuilderImpl builder) {
        super(builder);
        this.source = builder.source;
        this.target = builder.target;
    }

    public final ConversionSource source() {
        return this.source;
    }

    public final ConversionTarget target() {
        return this.target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestConversionRequest)) {
            return false;
        }
        TestConversionRequest other = (TestConversionRequest)((Object)obj);
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.target(), other.target());
    }

    public final String toString() {
        return ToString.builder((String)"TestConversionRequest").add("Source", (Object)this.source()).add("Target", (Object)this.target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestConversionRequest, T> g) {
        return obj -> g.apply((TestConversionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private ConversionSource source;
        private ConversionTarget target;

        private BuilderImpl() {
        }

        private BuilderImpl(TestConversionRequest model) {
            super(model);
            this.source(model.source);
            this.target(model.target);
        }

        public final ConversionSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ConversionSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ConversionSource source) {
            this.source = source;
            return this;
        }

        public final ConversionTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(ConversionTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(ConversionTarget target) {
            this.target = target;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestConversionRequest build() {
            return new TestConversionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestConversionRequest> {
        public Builder source(ConversionSource var1);

        default public Builder source(Consumer<ConversionSource.Builder> source) {
            return this.source((ConversionSource)((ConversionSource.Builder)ConversionSource.builder().applyMutation(source)).build());
        }

        public Builder target(ConversionTarget var1);

        default public Builder target(Consumer<ConversionTarget.Builder> target) {
            return this.target((ConversionTarget)((ConversionTarget.Builder)ConversionTarget.builder().applyMutation(target)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

