/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the formatting options for an outbound transformer (takes JSON or XML as input and converts it to an EDI
 * document (currently only X12 format is supported).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputConversion implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputConversion.Builder, OutputConversion> {
    private static final SdkField<String> TO_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toFormat").getter(getter(OutputConversion::toFormatAsString)).setter(setter(Builder::toFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toFormat").build()).build();

    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField
            .<FormatOptions> builder(MarshallingType.SDK_POJO).memberName("formatOptions")
            .getter(getter(OutputConversion::formatOptions)).setter(setter(Builder::formatOptions))
            .constructor(FormatOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_FORMAT_FIELD,
            FORMAT_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String toFormat;

    private final FormatOptions formatOptions;

    private OutputConversion(BuilderImpl builder) {
        this.toFormat = builder.toFormat;
        this.formatOptions = builder.formatOptions;
    }

    /**
     * <p>
     * The format for the output from an outbound transformer: only X12 is currently supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #toFormat} will
     * return {@link ToFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #toFormatAsString}.
     * </p>
     * 
     * @return The format for the output from an outbound transformer: only X12 is currently supported.
     * @see ToFormat
     */
    public final ToFormat toFormat() {
        return ToFormat.fromValue(toFormat);
    }

    /**
     * <p>
     * The format for the output from an outbound transformer: only X12 is currently supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #toFormat} will
     * return {@link ToFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #toFormatAsString}.
     * </p>
     * 
     * @return The format for the output from an outbound transformer: only X12 is currently supported.
     * @see ToFormat
     */
    public final String toFormatAsString() {
        return toFormat;
    }

    /**
     * <p>
     * A structure that contains the X12 transaction set and version for the transformer output.
     * </p>
     * 
     * @return A structure that contains the X12 transaction set and version for the transformer output.
     */
    public final FormatOptions formatOptions() {
        return formatOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(toFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputConversion)) {
            return false;
        }
        OutputConversion other = (OutputConversion) obj;
        return Objects.equals(toFormatAsString(), other.toFormatAsString())
                && Objects.equals(formatOptions(), other.formatOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputConversion").add("ToFormat", toFormatAsString()).add("FormatOptions", formatOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "toFormat":
            return Optional.ofNullable(clazz.cast(toFormatAsString()));
        case "formatOptions":
            return Optional.ofNullable(clazz.cast(formatOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputConversion, T> g) {
        return obj -> g.apply((OutputConversion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputConversion> {
        /**
         * <p>
         * The format for the output from an outbound transformer: only X12 is currently supported.
         * </p>
         * 
         * @param toFormat
         *        The format for the output from an outbound transformer: only X12 is currently supported.
         * @see ToFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ToFormat
         */
        Builder toFormat(String toFormat);

        /**
         * <p>
         * The format for the output from an outbound transformer: only X12 is currently supported.
         * </p>
         * 
         * @param toFormat
         *        The format for the output from an outbound transformer: only X12 is currently supported.
         * @see ToFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ToFormat
         */
        Builder toFormat(ToFormat toFormat);

        /**
         * <p>
         * A structure that contains the X12 transaction set and version for the transformer output.
         * </p>
         * 
         * @param formatOptions
         *        A structure that contains the X12 transaction set and version for the transformer output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatOptions(FormatOptions formatOptions);

        /**
         * <p>
         * A structure that contains the X12 transaction set and version for the transformer output.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormatOptions.Builder} avoiding the need
         * to create one manually via {@link FormatOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormatOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #formatOptions(FormatOptions)}.
         * 
         * @param formatOptions
         *        a consumer that will call methods on {@link FormatOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatOptions(FormatOptions)
         */
        default Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return formatOptions(FormatOptions.builder().applyMutation(formatOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String toFormat;

        private FormatOptions formatOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputConversion model) {
            toFormat(model.toFormat);
            formatOptions(model.formatOptions);
        }

        public final String getToFormat() {
            return toFormat;
        }

        public final void setToFormat(String toFormat) {
            this.toFormat = toFormat;
        }

        @Override
        public final Builder toFormat(String toFormat) {
            this.toFormat = toFormat;
            return this;
        }

        @Override
        public final Builder toFormat(ToFormat toFormat) {
            this.toFormat(toFormat == null ? null : toFormat.toString());
            return this;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return formatOptions != null ? formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        @Override
        public OutputConversion build() {
            return new OutputConversion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
