/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details for an Outbound EDI capability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapabilityOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<CapabilityOptions.Builder, CapabilityOptions> {
    private static final SdkField<OutboundEdiOptions> OUTBOUND_EDI_FIELD = SdkField
            .<OutboundEdiOptions> builder(MarshallingType.SDK_POJO).memberName("outboundEdi")
            .getter(getter(CapabilityOptions::outboundEdi)).setter(setter(Builder::outboundEdi))
            .constructor(OutboundEdiOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outboundEdi").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTBOUND_EDI_FIELD));

    private static final long serialVersionUID = 1L;

    private final OutboundEdiOptions outboundEdi;

    private CapabilityOptions(BuilderImpl builder) {
        this.outboundEdi = builder.outboundEdi;
    }

    /**
     * <p>
     * A structure that contains the outbound EDI options.
     * </p>
     * 
     * @return A structure that contains the outbound EDI options.
     */
    public final OutboundEdiOptions outboundEdi() {
        return outboundEdi;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outboundEdi());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapabilityOptions)) {
            return false;
        }
        CapabilityOptions other = (CapabilityOptions) obj;
        return Objects.equals(outboundEdi(), other.outboundEdi());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapabilityOptions").add("OutboundEdi", outboundEdi()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outboundEdi":
            return Optional.ofNullable(clazz.cast(outboundEdi()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapabilityOptions, T> g) {
        return obj -> g.apply((CapabilityOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapabilityOptions> {
        /**
         * <p>
         * A structure that contains the outbound EDI options.
         * </p>
         * 
         * @param outboundEdi
         *        A structure that contains the outbound EDI options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundEdi(OutboundEdiOptions outboundEdi);

        /**
         * <p>
         * A structure that contains the outbound EDI options.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutboundEdiOptions.Builder} avoiding the
         * need to create one manually via {@link OutboundEdiOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundEdiOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #outboundEdi(OutboundEdiOptions)}.
         * 
         * @param outboundEdi
         *        a consumer that will call methods on {@link OutboundEdiOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundEdi(OutboundEdiOptions)
         */
        default Builder outboundEdi(Consumer<OutboundEdiOptions.Builder> outboundEdi) {
            return outboundEdi(OutboundEdiOptions.builder().applyMutation(outboundEdi).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OutboundEdiOptions outboundEdi;

        private BuilderImpl() {
        }

        private BuilderImpl(CapabilityOptions model) {
            outboundEdi(model.outboundEdi);
        }

        public final OutboundEdiOptions.Builder getOutboundEdi() {
            return outboundEdi != null ? outboundEdi.toBuilder() : null;
        }

        public final void setOutboundEdi(OutboundEdiOptions.BuilderImpl outboundEdi) {
            this.outboundEdi = outboundEdi != null ? outboundEdi.build() : null;
        }

        @Override
        public final Builder outboundEdi(OutboundEdiOptions outboundEdi) {
            this.outboundEdi = outboundEdi;
            return this;
        }

        @Override
        public CapabilityOptions build() {
            return new CapabilityOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
