/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provide a sample of what the output of the transformation should look like.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversionTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversionTarget.Builder, ConversionTarget> {
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(ConversionTarget::fileFormatAsString)).setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<ConversionTargetFormatDetails> FORMAT_DETAILS_FIELD = SdkField
            .<ConversionTargetFormatDetails> builder(MarshallingType.SDK_POJO).memberName("formatDetails")
            .getter(getter(ConversionTarget::formatDetails)).setter(setter(Builder::formatDetails))
            .constructor(ConversionTargetFormatDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatDetails").build()).build();

    private static final SdkField<OutputSampleFileSource> OUTPUT_SAMPLE_FILE_FIELD = SdkField
            .<OutputSampleFileSource> builder(MarshallingType.SDK_POJO).memberName("outputSampleFile")
            .getter(getter(ConversionTarget::outputSampleFile)).setter(setter(Builder::outputSampleFile))
            .constructor(OutputSampleFileSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSampleFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FORMAT_FIELD,
            FORMAT_DETAILS_FIELD, OUTPUT_SAMPLE_FILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileFormat;

    private final ConversionTargetFormatDetails formatDetails;

    private final OutputSampleFileSource outputSampleFile;

    private ConversionTarget(BuilderImpl builder) {
        this.fileFormat = builder.fileFormat;
        this.formatDetails = builder.formatDetails;
        this.outputSampleFile = builder.outputSampleFile;
    }

    /**
     * <p>
     * Currently, only X12 format is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link ConversionTargetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Currently, only X12 format is supported.
     * @see ConversionTargetFormat
     */
    public final ConversionTargetFormat fileFormat() {
        return ConversionTargetFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * Currently, only X12 format is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link ConversionTargetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Currently, only X12 format is supported.
     * @see ConversionTargetFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * A structure that contains the formatting details for the conversion target.
     * </p>
     * 
     * @return A structure that contains the formatting details for the conversion target.
     */
    public final ConversionTargetFormatDetails formatDetails() {
        return formatDetails;
    }

    /**
     * <p>
     * Customer uses this to provide a sample on what should file look like after conversion X12 EDI use case around
     * this would be discovering the file syntax
     * </p>
     * 
     * @return Customer uses this to provide a sample on what should file look like after conversion X12 EDI use case
     *         around this would be discovering the file syntax
     */
    public final OutputSampleFileSource outputSampleFile() {
        return outputSampleFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatDetails());
        hashCode = 31 * hashCode + Objects.hashCode(outputSampleFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionTarget)) {
            return false;
        }
        ConversionTarget other = (ConversionTarget) obj;
        return Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(formatDetails(), other.formatDetails())
                && Objects.equals(outputSampleFile(), other.outputSampleFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversionTarget").add("FileFormat", fileFormatAsString()).add("FormatDetails", formatDetails())
                .add("OutputSampleFile", outputSampleFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "formatDetails":
            return Optional.ofNullable(clazz.cast(formatDetails()));
        case "outputSampleFile":
            return Optional.ofNullable(clazz.cast(outputSampleFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversionTarget, T> g) {
        return obj -> g.apply((ConversionTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversionTarget> {
        /**
         * <p>
         * Currently, only X12 format is supported.
         * </p>
         * 
         * @param fileFormat
         *        Currently, only X12 format is supported.
         * @see ConversionTargetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversionTargetFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * Currently, only X12 format is supported.
         * </p>
         * 
         * @param fileFormat
         *        Currently, only X12 format is supported.
         * @see ConversionTargetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversionTargetFormat
         */
        Builder fileFormat(ConversionTargetFormat fileFormat);

        /**
         * <p>
         * A structure that contains the formatting details for the conversion target.
         * </p>
         * 
         * @param formatDetails
         *        A structure that contains the formatting details for the conversion target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatDetails(ConversionTargetFormatDetails formatDetails);

        /**
         * <p>
         * A structure that contains the formatting details for the conversion target.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConversionTargetFormatDetails.Builder}
         * avoiding the need to create one manually via {@link ConversionTargetFormatDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConversionTargetFormatDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #formatDetails(ConversionTargetFormatDetails)}.
         * 
         * @param formatDetails
         *        a consumer that will call methods on {@link ConversionTargetFormatDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatDetails(ConversionTargetFormatDetails)
         */
        default Builder formatDetails(Consumer<ConversionTargetFormatDetails.Builder> formatDetails) {
            return formatDetails(ConversionTargetFormatDetails.builder().applyMutation(formatDetails).build());
        }

        /**
         * <p>
         * Customer uses this to provide a sample on what should file look like after conversion X12 EDI use case around
         * this would be discovering the file syntax
         * </p>
         * 
         * @param outputSampleFile
         *        Customer uses this to provide a sample on what should file look like after conversion X12 EDI use case
         *        around this would be discovering the file syntax
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSampleFile(OutputSampleFileSource outputSampleFile);

        /**
         * <p>
         * Customer uses this to provide a sample on what should file look like after conversion X12 EDI use case around
         * this would be discovering the file syntax
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputSampleFileSource.Builder} avoiding
         * the need to create one manually via {@link OutputSampleFileSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputSampleFileSource.Builder#build()} is called immediately and
         * its result is passed to {@link #outputSampleFile(OutputSampleFileSource)}.
         * 
         * @param outputSampleFile
         *        a consumer that will call methods on {@link OutputSampleFileSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSampleFile(OutputSampleFileSource)
         */
        default Builder outputSampleFile(Consumer<OutputSampleFileSource.Builder> outputSampleFile) {
            return outputSampleFile(OutputSampleFileSource.builder().applyMutation(outputSampleFile).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fileFormat;

        private ConversionTargetFormatDetails formatDetails;

        private OutputSampleFileSource outputSampleFile;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversionTarget model) {
            fileFormat(model.fileFormat);
            formatDetails(model.formatDetails);
            outputSampleFile(model.outputSampleFile);
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(ConversionTargetFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final ConversionTargetFormatDetails.Builder getFormatDetails() {
            return formatDetails != null ? formatDetails.toBuilder() : null;
        }

        public final void setFormatDetails(ConversionTargetFormatDetails.BuilderImpl formatDetails) {
            this.formatDetails = formatDetails != null ? formatDetails.build() : null;
        }

        @Override
        public final Builder formatDetails(ConversionTargetFormatDetails formatDetails) {
            this.formatDetails = formatDetails;
            return this;
        }

        public final OutputSampleFileSource.Builder getOutputSampleFile() {
            return outputSampleFile != null ? outputSampleFile.toBuilder() : null;
        }

        public final void setOutputSampleFile(OutputSampleFileSource.BuilderImpl outputSampleFile) {
            this.outputSampleFile = outputSampleFile != null ? outputSampleFile.build() : null;
        }

        @Override
        public final Builder outputSampleFile(OutputSampleFileSource outputSampleFile) {
            this.outputSampleFile = outputSampleFile;
            return this;
        }

        @Override
        public ConversionTarget build() {
            return new ConversionTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
