/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the details for the EDI (electronic data interchange) transformation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdiConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EdiConfiguration.Builder, EdiConfiguration> {
    private static final SdkField<String> CAPABILITY_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capabilityDirection").getter(getter(EdiConfiguration::capabilityDirectionAsString))
            .setter(setter(Builder::capabilityDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityDirection").build())
            .build();

    private static final SdkField<EdiType> TYPE_FIELD = SdkField.<EdiType> builder(MarshallingType.SDK_POJO).memberName("type")
            .getter(getter(EdiConfiguration::type)).setter(setter(Builder::type)).constructor(EdiType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<S3Location> INPUT_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("inputLocation").getter(getter(EdiConfiguration::inputLocation)).setter(setter(Builder::inputLocation))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLocation").build()).build();

    private static final SdkField<S3Location> OUTPUT_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("outputLocation").getter(getter(EdiConfiguration::outputLocation))
            .setter(setter(Builder::outputLocation)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final SdkField<String> TRANSFORMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformerId").getter(getter(EdiConfiguration::transformerId)).setter(setter(Builder::transformerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_DIRECTION_FIELD,
            TYPE_FIELD, INPUT_LOCATION_FIELD, OUTPUT_LOCATION_FIELD, TRANSFORMER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String capabilityDirection;

    private final EdiType type;

    private final S3Location inputLocation;

    private final S3Location outputLocation;

    private final String transformerId;

    private EdiConfiguration(BuilderImpl builder) {
        this.capabilityDirection = builder.capabilityDirection;
        this.type = builder.type;
        this.inputLocation = builder.inputLocation;
        this.outputLocation = builder.outputLocation;
        this.transformerId = builder.transformerId;
    }

    /**
     * <p>
     * Specifies whether this is capability is for inbound or outbound transformations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capabilityDirection} will return {@link CapabilityDirection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #capabilityDirectionAsString}.
     * </p>
     * 
     * @return Specifies whether this is capability is for inbound or outbound transformations.
     * @see CapabilityDirection
     */
    public final CapabilityDirection capabilityDirection() {
        return CapabilityDirection.fromValue(capabilityDirection);
    }

    /**
     * <p>
     * Specifies whether this is capability is for inbound or outbound transformations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capabilityDirection} will return {@link CapabilityDirection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #capabilityDirectionAsString}.
     * </p>
     * 
     * @return Specifies whether this is capability is for inbound or outbound transformations.
     * @see CapabilityDirection
     */
    public final String capabilityDirectionAsString() {
        return capabilityDirection;
    }

    /**
     * <p>
     * Returns the type of the capability. Currently, only <code>edi</code> is supported.
     * </p>
     * 
     * @return Returns the type of the capability. Currently, only <code>edi</code> is supported.
     */
    public final EdiType type() {
        return type;
    }

    /**
     * <p>
     * Contains the Amazon S3 bucket and prefix for the location of the input file, which is contained in an
     * <code>S3Location</code> object.
     * </p>
     * 
     * @return Contains the Amazon S3 bucket and prefix for the location of the input file, which is contained in an
     *         <code>S3Location</code> object.
     */
    public final S3Location inputLocation() {
        return inputLocation;
    }

    /**
     * <p>
     * Contains the Amazon S3 bucket and prefix for the location of the output file, which is contained in an
     * <code>S3Location</code> object.
     * </p>
     * 
     * @return Contains the Amazon S3 bucket and prefix for the location of the output file, which is contained in an
     *         <code>S3Location</code> object.
     */
    public final S3Location outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * Returns the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @return Returns the system-assigned unique identifier for the transformer.
     */
    public final String transformerId() {
        return transformerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capabilityDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(inputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(transformerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdiConfiguration)) {
            return false;
        }
        EdiConfiguration other = (EdiConfiguration) obj;
        return Objects.equals(capabilityDirectionAsString(), other.capabilityDirectionAsString())
                && Objects.equals(type(), other.type()) && Objects.equals(inputLocation(), other.inputLocation())
                && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(transformerId(), other.transformerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdiConfiguration").add("CapabilityDirection", capabilityDirectionAsString()).add("Type", type())
                .add("InputLocation", inputLocation()).add("OutputLocation", outputLocation())
                .add("TransformerId", transformerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capabilityDirection":
            return Optional.ofNullable(clazz.cast(capabilityDirectionAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "inputLocation":
            return Optional.ofNullable(clazz.cast(inputLocation()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "transformerId":
            return Optional.ofNullable(clazz.cast(transformerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdiConfiguration, T> g) {
        return obj -> g.apply((EdiConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdiConfiguration> {
        /**
         * <p>
         * Specifies whether this is capability is for inbound or outbound transformations.
         * </p>
         * 
         * @param capabilityDirection
         *        Specifies whether this is capability is for inbound or outbound transformations.
         * @see CapabilityDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityDirection
         */
        Builder capabilityDirection(String capabilityDirection);

        /**
         * <p>
         * Specifies whether this is capability is for inbound or outbound transformations.
         * </p>
         * 
         * @param capabilityDirection
         *        Specifies whether this is capability is for inbound or outbound transformations.
         * @see CapabilityDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityDirection
         */
        Builder capabilityDirection(CapabilityDirection capabilityDirection);

        /**
         * <p>
         * Returns the type of the capability. Currently, only <code>edi</code> is supported.
         * </p>
         * 
         * @param type
         *        Returns the type of the capability. Currently, only <code>edi</code> is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(EdiType type);

        /**
         * <p>
         * Returns the type of the capability. Currently, only <code>edi</code> is supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdiType.Builder} avoiding the need to
         * create one manually via {@link EdiType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdiType.Builder#build()} is called immediately and its result is
         * passed to {@link #type(EdiType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link EdiType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(EdiType)
         */
        default Builder type(Consumer<EdiType.Builder> type) {
            return type(EdiType.builder().applyMutation(type).build());
        }

        /**
         * <p>
         * Contains the Amazon S3 bucket and prefix for the location of the input file, which is contained in an
         * <code>S3Location</code> object.
         * </p>
         * 
         * @param inputLocation
         *        Contains the Amazon S3 bucket and prefix for the location of the input file, which is contained in an
         *        <code>S3Location</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLocation(S3Location inputLocation);

        /**
         * <p>
         * Contains the Amazon S3 bucket and prefix for the location of the input file, which is contained in an
         * <code>S3Location</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #inputLocation(S3Location)}.
         * 
         * @param inputLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputLocation(S3Location)
         */
        default Builder inputLocation(Consumer<S3Location.Builder> inputLocation) {
            return inputLocation(S3Location.builder().applyMutation(inputLocation).build());
        }

        /**
         * <p>
         * Contains the Amazon S3 bucket and prefix for the location of the output file, which is contained in an
         * <code>S3Location</code> object.
         * </p>
         * 
         * @param outputLocation
         *        Contains the Amazon S3 bucket and prefix for the location of the output file, which is contained in an
         *        <code>S3Location</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(S3Location outputLocation);

        /**
         * <p>
         * Contains the Amazon S3 bucket and prefix for the location of the output file, which is contained in an
         * <code>S3Location</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #outputLocation(S3Location)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(S3Location)
         */
        default Builder outputLocation(Consumer<S3Location.Builder> outputLocation) {
            return outputLocation(S3Location.builder().applyMutation(outputLocation).build());
        }

        /**
         * <p>
         * Returns the system-assigned unique identifier for the transformer.
         * </p>
         * 
         * @param transformerId
         *        Returns the system-assigned unique identifier for the transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerId(String transformerId);
    }

    static final class BuilderImpl implements Builder {
        private String capabilityDirection;

        private EdiType type;

        private S3Location inputLocation;

        private S3Location outputLocation;

        private String transformerId;

        private BuilderImpl() {
        }

        private BuilderImpl(EdiConfiguration model) {
            capabilityDirection(model.capabilityDirection);
            type(model.type);
            inputLocation(model.inputLocation);
            outputLocation(model.outputLocation);
            transformerId(model.transformerId);
        }

        public final String getCapabilityDirection() {
            return capabilityDirection;
        }

        public final void setCapabilityDirection(String capabilityDirection) {
            this.capabilityDirection = capabilityDirection;
        }

        @Override
        public final Builder capabilityDirection(String capabilityDirection) {
            this.capabilityDirection = capabilityDirection;
            return this;
        }

        @Override
        public final Builder capabilityDirection(CapabilityDirection capabilityDirection) {
            this.capabilityDirection(capabilityDirection == null ? null : capabilityDirection.toString());
            return this;
        }

        public final EdiType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(EdiType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(EdiType type) {
            this.type = type;
            return this;
        }

        public final S3Location.Builder getInputLocation() {
            return inputLocation != null ? inputLocation.toBuilder() : null;
        }

        public final void setInputLocation(S3Location.BuilderImpl inputLocation) {
            this.inputLocation = inputLocation != null ? inputLocation.build() : null;
        }

        @Override
        public final Builder inputLocation(S3Location inputLocation) {
            this.inputLocation = inputLocation;
            return this;
        }

        public final S3Location.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(S3Location.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(S3Location outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getTransformerId() {
            return transformerId;
        }

        public final void setTransformerId(String transformerId) {
            this.transformerId = transformerId;
        }

        @Override
        public final Builder transformerId(String transformerId) {
            this.transformerId = transformerId;
            return this;
        }

        @Override
        public EdiConfiguration build() {
            return new EdiConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
