/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the location of a sample file used for outbound transformations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputSampleFileSource implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputSampleFileSource.Builder, OutputSampleFileSource> {
    private static final SdkField<S3Location> FILE_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("fileLocation").getter(getter(OutputSampleFileSource::fileLocation))
            .setter(setter(Builder::fileLocation)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Location fileLocation;

    private final Type type;

    private OutputSampleFileSource(BuilderImpl builder) {
        this.fileLocation = builder.fileLocation;
        this.type = builder.type;
    }

    /**
     * Returns the value of the FileLocation property for this object.
     * 
     * @return The value of the FileLocation property for this object.
     */
    public final S3Location fileLocation() {
        return fileLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSampleFileSource)) {
            return false;
        }
        OutputSampleFileSource other = (OutputSampleFileSource) obj;
        return Objects.equals(fileLocation(), other.fileLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputSampleFileSource").add("FileLocation", fileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileLocation":
            return Optional.ofNullable(clazz.cast(fileLocation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #fileLocation()} initialized to the given value.
     *
     * Sets the value of the FileLocation property for this object.
     *
     * @param fileLocation
     *        The new value for the FileLocation property for this object.
     */
    public static OutputSampleFileSource fromFileLocation(S3Location fileLocation) {
        return builder().fileLocation(fileLocation).build();
    }

    /**
     * Create an instance of this class with {@link #fileLocation()} initialized to the given value.
     *
     * Sets the value of the FileLocation property for this object.
     *
     * @param fileLocation
     *        The new value for the FileLocation property for this object.
     */
    public static OutputSampleFileSource fromFileLocation(Consumer<S3Location.Builder> fileLocation) {
        S3Location.Builder builder = S3Location.builder();
        fileLocation.accept(builder);
        return fromFileLocation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputSampleFileSource, T> g) {
        return obj -> g.apply((OutputSampleFileSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputSampleFileSource> {
        /**
         * Sets the value of the FileLocation property for this object.
         *
         * @param fileLocation
         *        The new value for the FileLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileLocation(S3Location fileLocation);

        /**
         * Sets the value of the FileLocation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #fileLocation(S3Location)}.
         * 
         * @param fileLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileLocation(S3Location)
         */
        default Builder fileLocation(Consumer<S3Location.Builder> fileLocation) {
            return fileLocation(S3Location.builder().applyMutation(fileLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Location fileLocation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSampleFileSource model) {
            fileLocation(model.fileLocation);
        }

        public final S3Location.Builder getFileLocation() {
            return fileLocation != null ? fileLocation.toBuilder() : null;
        }

        public final void setFileLocation(S3Location.BuilderImpl fileLocation) {
            Object oldValue = this.fileLocation;
            this.fileLocation = fileLocation != null ? fileLocation.build() : null;
            handleUnionValueChange(Type.FILE_LOCATION, oldValue, this.fileLocation);
        }

        @Override
        public final Builder fileLocation(S3Location fileLocation) {
            Object oldValue = this.fileLocation;
            this.fileLocation = fileLocation;
            handleUnionValueChange(Type.FILE_LOCATION, oldValue, this.fileLocation);
            return this;
        }

        @Override
        public OutputSampleFileSource build() {
            return new OutputSampleFileSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see OutputSampleFileSource#type()
     */
    public enum Type {
        FILE_LOCATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
