/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePartnershipRequest extends B2BiRequest implements
        ToCopyableBuilder<UpdatePartnershipRequest.Builder, UpdatePartnershipRequest> {
    private static final SdkField<String> PARTNERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partnershipId").getter(getter(UpdatePartnershipRequest::partnershipId))
            .setter(setter(Builder::partnershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnershipId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdatePartnershipRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(UpdatePartnershipRequest::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CapabilityOptions> CAPABILITY_OPTIONS_FIELD = SdkField
            .<CapabilityOptions> builder(MarshallingType.SDK_POJO).memberName("capabilityOptions")
            .getter(getter(UpdatePartnershipRequest::capabilityOptions)).setter(setter(Builder::capabilityOptions))
            .constructor(CapabilityOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTNERSHIP_ID_FIELD,
            NAME_FIELD, CAPABILITIES_FIELD, CAPABILITY_OPTIONS_FIELD));

    private final String partnershipId;

    private final String name;

    private final List<String> capabilities;

    private final CapabilityOptions capabilityOptions;

    private UpdatePartnershipRequest(BuilderImpl builder) {
        super(builder);
        this.partnershipId = builder.partnershipId;
        this.name = builder.name;
        this.capabilities = builder.capabilities;
        this.capabilityOptions = builder.capabilityOptions;
    }

    /**
     * <p>
     * Specifies the unique, system-generated identifier for a partnership.
     * </p>
     * 
     * @return Specifies the unique, system-generated identifier for a partnership.
     */
    public final String partnershipId() {
        return partnershipId;
    }

    /**
     * <p>
     * The name of the partnership, used to identify it.
     * </p>
     * 
     * @return The name of the partnership, used to identify it.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the capabilities associated with this partnership.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return List of the capabilities associated with this partnership.
     */
    public final List<String> capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * To update, specify the structure that contains the details for the associated capabilities.
     * </p>
     * 
     * @return To update, specify the structure that contains the details for the associated capabilities.
     */
    public final CapabilityOptions capabilityOptions() {
        return capabilityOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(partnershipId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capabilityOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePartnershipRequest)) {
            return false;
        }
        UpdatePartnershipRequest other = (UpdatePartnershipRequest) obj;
        return Objects.equals(partnershipId(), other.partnershipId()) && Objects.equals(name(), other.name())
                && hasCapabilities() == other.hasCapabilities() && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(capabilityOptions(), other.capabilityOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePartnershipRequest").add("PartnershipId", partnershipId()).add("Name", name())
                .add("Capabilities", hasCapabilities() ? capabilities() : null).add("CapabilityOptions", capabilityOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "partnershipId":
            return Optional.ofNullable(clazz.cast(partnershipId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "capabilityOptions":
            return Optional.ofNullable(clazz.cast(capabilityOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePartnershipRequest, T> g) {
        return obj -> g.apply((UpdatePartnershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePartnershipRequest> {
        /**
         * <p>
         * Specifies the unique, system-generated identifier for a partnership.
         * </p>
         * 
         * @param partnershipId
         *        Specifies the unique, system-generated identifier for a partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnershipId(String partnershipId);

        /**
         * <p>
         * The name of the partnership, used to identify it.
         * </p>
         * 
         * @param name
         *        The name of the partnership, used to identify it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * List of the capabilities associated with this partnership.
         * </p>
         * 
         * @param capabilities
         *        List of the capabilities associated with this partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * List of the capabilities associated with this partnership.
         * </p>
         * 
         * @param capabilities
         *        List of the capabilities associated with this partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * To update, specify the structure that contains the details for the associated capabilities.
         * </p>
         * 
         * @param capabilityOptions
         *        To update, specify the structure that contains the details for the associated capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityOptions(CapabilityOptions capabilityOptions);

        /**
         * <p>
         * To update, specify the structure that contains the details for the associated capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapabilityOptions.Builder} avoiding the
         * need to create one manually via {@link CapabilityOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapabilityOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilityOptions(CapabilityOptions)}.
         * 
         * @param capabilityOptions
         *        a consumer that will call methods on {@link CapabilityOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilityOptions(CapabilityOptions)
         */
        default Builder capabilityOptions(Consumer<CapabilityOptions.Builder> capabilityOptions) {
            return capabilityOptions(CapabilityOptions.builder().applyMutation(capabilityOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String partnershipId;

        private String name;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private CapabilityOptions capabilityOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePartnershipRequest model) {
            super(model);
            partnershipId(model.partnershipId);
            name(model.name);
            capabilities(model.capabilities);
            capabilityOptions(model.capabilityOptions);
        }

        public final String getPartnershipId() {
            return partnershipId;
        }

        public final void setPartnershipId(String partnershipId) {
            this.partnershipId = partnershipId;
        }

        @Override
        public final Builder partnershipId(String partnershipId) {
            this.partnershipId = partnershipId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final CapabilityOptions.Builder getCapabilityOptions() {
            return capabilityOptions != null ? capabilityOptions.toBuilder() : null;
        }

        public final void setCapabilityOptions(CapabilityOptions.BuilderImpl capabilityOptions) {
            this.capabilityOptions = capabilityOptions != null ? capabilityOptions.build() : null;
        }

        @Override
        public final Builder capabilityOptions(CapabilityOptions capabilityOptions) {
            this.capabilityOptions = capabilityOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePartnershipRequest build() {
            return new UpdatePartnershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
