/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the interchange
 * control header. The delimiters are part of the message's syntax and divide up its different elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12Delimiters implements SdkPojo, Serializable, ToCopyableBuilder<X12Delimiters.Builder, X12Delimiters> {
    private static final SdkField<String> COMPONENT_SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentSeparator").getter(getter(X12Delimiters::componentSeparator))
            .setter(setter(Builder::componentSeparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentSeparator").build())
            .build();

    private static final SdkField<String> DATA_ELEMENT_SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataElementSeparator").getter(getter(X12Delimiters::dataElementSeparator))
            .setter(setter(Builder::dataElementSeparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataElementSeparator").build())
            .build();

    private static final SdkField<String> SEGMENT_TERMINATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("segmentTerminator").getter(getter(X12Delimiters::segmentTerminator))
            .setter(setter(Builder::segmentTerminator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentTerminator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_SEPARATOR_FIELD,
            DATA_ELEMENT_SEPARATOR_FIELD, SEGMENT_TERMINATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentSeparator;

    private final String dataElementSeparator;

    private final String segmentTerminator;

    private X12Delimiters(BuilderImpl builder) {
        this.componentSeparator = builder.componentSeparator;
        this.dataElementSeparator = builder.dataElementSeparator;
        this.segmentTerminator = builder.segmentTerminator;
    }

    /**
     * <p>
     * The component, or sub-element, separator. The default value is <code>:</code> (colon).
     * </p>
     * 
     * @return The component, or sub-element, separator. The default value is <code>:</code> (colon).
     */
    public final String componentSeparator() {
        return componentSeparator;
    }

    /**
     * <p>
     * The data element separator. The default value is <code>*</code> (asterisk).
     * </p>
     * 
     * @return The data element separator. The default value is <code>*</code> (asterisk).
     */
    public final String dataElementSeparator() {
        return dataElementSeparator;
    }

    /**
     * <p>
     * The segment terminator. The default value is <code>~</code> (tilde).
     * </p>
     * 
     * @return The segment terminator. The default value is <code>~</code> (tilde).
     */
    public final String segmentTerminator() {
        return segmentTerminator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentSeparator());
        hashCode = 31 * hashCode + Objects.hashCode(dataElementSeparator());
        hashCode = 31 * hashCode + Objects.hashCode(segmentTerminator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12Delimiters)) {
            return false;
        }
        X12Delimiters other = (X12Delimiters) obj;
        return Objects.equals(componentSeparator(), other.componentSeparator())
                && Objects.equals(dataElementSeparator(), other.dataElementSeparator())
                && Objects.equals(segmentTerminator(), other.segmentTerminator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12Delimiters").add("ComponentSeparator", componentSeparator())
                .add("DataElementSeparator", dataElementSeparator()).add("SegmentTerminator", segmentTerminator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentSeparator":
            return Optional.ofNullable(clazz.cast(componentSeparator()));
        case "dataElementSeparator":
            return Optional.ofNullable(clazz.cast(dataElementSeparator()));
        case "segmentTerminator":
            return Optional.ofNullable(clazz.cast(segmentTerminator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<X12Delimiters, T> g) {
        return obj -> g.apply((X12Delimiters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12Delimiters> {
        /**
         * <p>
         * The component, or sub-element, separator. The default value is <code>:</code> (colon).
         * </p>
         * 
         * @param componentSeparator
         *        The component, or sub-element, separator. The default value is <code>:</code> (colon).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentSeparator(String componentSeparator);

        /**
         * <p>
         * The data element separator. The default value is <code>*</code> (asterisk).
         * </p>
         * 
         * @param dataElementSeparator
         *        The data element separator. The default value is <code>*</code> (asterisk).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataElementSeparator(String dataElementSeparator);

        /**
         * <p>
         * The segment terminator. The default value is <code>~</code> (tilde).
         * </p>
         * 
         * @param segmentTerminator
         *        The segment terminator. The default value is <code>~</code> (tilde).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentTerminator(String segmentTerminator);
    }

    static final class BuilderImpl implements Builder {
        private String componentSeparator;

        private String dataElementSeparator;

        private String segmentTerminator;

        private BuilderImpl() {
        }

        private BuilderImpl(X12Delimiters model) {
            componentSeparator(model.componentSeparator);
            dataElementSeparator(model.dataElementSeparator);
            segmentTerminator(model.segmentTerminator);
        }

        public final String getComponentSeparator() {
            return componentSeparator;
        }

        public final void setComponentSeparator(String componentSeparator) {
            this.componentSeparator = componentSeparator;
        }

        @Override
        public final Builder componentSeparator(String componentSeparator) {
            this.componentSeparator = componentSeparator;
            return this;
        }

        public final String getDataElementSeparator() {
            return dataElementSeparator;
        }

        public final void setDataElementSeparator(String dataElementSeparator) {
            this.dataElementSeparator = dataElementSeparator;
        }

        @Override
        public final Builder dataElementSeparator(String dataElementSeparator) {
            this.dataElementSeparator = dataElementSeparator;
            return this;
        }

        public final String getSegmentTerminator() {
            return segmentTerminator;
        }

        public final void setSegmentTerminator(String segmentTerminator) {
            this.segmentTerminator = segmentTerminator;
        }

        @Override
        public final Builder segmentTerminator(String segmentTerminator) {
            this.segmentTerminator = segmentTerminator;
            return this;
        }

        @Override
        public X12Delimiters build() {
            return new X12Delimiters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
