/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In X12, the Interchange Control Header is the first segment of an EDI document and is part of the Interchange
 * Envelope. It contains information about the sender and receiver, the date and time of transmission, and the X12
 * version being used. It also includes delivery information, such as the sender and receiver IDs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class X12InterchangeControlHeaders implements SdkPojo, Serializable,
        ToCopyableBuilder<X12InterchangeControlHeaders.Builder, X12InterchangeControlHeaders> {
    private static final SdkField<String> SENDER_ID_QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("senderIdQualifier").getter(getter(X12InterchangeControlHeaders::senderIdQualifier))
            .setter(setter(Builder::senderIdQualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderIdQualifier").build()).build();

    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("senderId").getter(getter(X12InterchangeControlHeaders::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderId").build()).build();

    private static final SdkField<String> RECEIVER_ID_QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("receiverIdQualifier").getter(getter(X12InterchangeControlHeaders::receiverIdQualifier))
            .setter(setter(Builder::receiverIdQualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverIdQualifier").build())
            .build();

    private static final SdkField<String> RECEIVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("receiverId").getter(getter(X12InterchangeControlHeaders::receiverId))
            .setter(setter(Builder::receiverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverId").build()).build();

    private static final SdkField<String> REPETITION_SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repetitionSeparator").getter(getter(X12InterchangeControlHeaders::repetitionSeparator))
            .setter(setter(Builder::repetitionSeparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repetitionSeparator").build())
            .build();

    private static final SdkField<String> ACKNOWLEDGMENT_REQUESTED_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("acknowledgmentRequestedCode")
            .getter(getter(X12InterchangeControlHeaders::acknowledgmentRequestedCode))
            .setter(setter(Builder::acknowledgmentRequestedCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acknowledgmentRequestedCode")
                    .build()).build();

    private static final SdkField<String> USAGE_INDICATOR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageIndicatorCode").getter(getter(X12InterchangeControlHeaders::usageIndicatorCode))
            .setter(setter(Builder::usageIndicatorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageIndicatorCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDER_ID_QUALIFIER_FIELD,
            SENDER_ID_FIELD, RECEIVER_ID_QUALIFIER_FIELD, RECEIVER_ID_FIELD, REPETITION_SEPARATOR_FIELD,
            ACKNOWLEDGMENT_REQUESTED_CODE_FIELD, USAGE_INDICATOR_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String senderIdQualifier;

    private final String senderId;

    private final String receiverIdQualifier;

    private final String receiverId;

    private final String repetitionSeparator;

    private final String acknowledgmentRequestedCode;

    private final String usageIndicatorCode;

    private X12InterchangeControlHeaders(BuilderImpl builder) {
        this.senderIdQualifier = builder.senderIdQualifier;
        this.senderId = builder.senderId;
        this.receiverIdQualifier = builder.receiverIdQualifier;
        this.receiverId = builder.receiverId;
        this.repetitionSeparator = builder.repetitionSeparator;
        this.acknowledgmentRequestedCode = builder.acknowledgmentRequestedCode;
        this.usageIndicatorCode = builder.usageIndicatorCode;
    }

    /**
     * <p>
     * Located at position ISA-05 in the header. Qualifier for the sender ID. Together, the ID and qualifier uniquely
     * identify the sending trading partner.
     * </p>
     * 
     * @return Located at position ISA-05 in the header. Qualifier for the sender ID. Together, the ID and qualifier
     *         uniquely identify the sending trading partner.
     */
    public final String senderIdQualifier() {
        return senderIdQualifier;
    }

    /**
     * <p>
     * Located at position ISA-06 in the header. This value (along with the <code>senderIdQualifier</code>) identifies
     * the sender of the interchange.
     * </p>
     * 
     * @return Located at position ISA-06 in the header. This value (along with the <code>senderIdQualifier</code>)
     *         identifies the sender of the interchange.
     */
    public final String senderId() {
        return senderId;
    }

    /**
     * <p>
     * Located at position ISA-07 in the header. Qualifier for the receiver ID. Together, the ID and qualifier uniquely
     * identify the receiving trading partner.
     * </p>
     * 
     * @return Located at position ISA-07 in the header. Qualifier for the receiver ID. Together, the ID and qualifier
     *         uniquely identify the receiving trading partner.
     */
    public final String receiverIdQualifier() {
        return receiverIdQualifier;
    }

    /**
     * <p>
     * Located at position ISA-08 in the header. This value (along with the <code>receiverIdQualifier</code>) identifies
     * the intended recipient of the interchange.
     * </p>
     * 
     * @return Located at position ISA-08 in the header. This value (along with the <code>receiverIdQualifier</code>)
     *         identifies the intended recipient of the interchange.
     */
    public final String receiverId() {
        return receiverId;
    }

    /**
     * <p>
     * Located at position ISA-11 in the header. This string makes it easier when you need to group similar adjacent
     * element values together without using extra segments.
     * </p>
     * <note>
     * <p>
     * This parameter is only honored for version greater than 401 (<code>VERSION_4010</code> and higher).
     * </p>
     * <p>
     * For versions less than 401, this field is called <a
     * href="https://www.stedi.com/edi/x12-004010/segment/ISA#ISA-11">StandardsId</a>, in which case our service sets
     * the value to <code>U</code>.
     * </p>
     * </note>
     * 
     * @return Located at position ISA-11 in the header. This string makes it easier when you need to group similar
     *         adjacent element values together without using extra segments.</p> <note>
     *         <p>
     *         This parameter is only honored for version greater than 401 (<code>VERSION_4010</code> and higher).
     *         </p>
     *         <p>
     *         For versions less than 401, this field is called <a
     *         href="https://www.stedi.com/edi/x12-004010/segment/ISA#ISA-11">StandardsId</a>, in which case our service
     *         sets the value to <code>U</code>.
     *         </p>
     */
    public final String repetitionSeparator() {
        return repetitionSeparator;
    }

    /**
     * <p>
     * Located at position ISA-14 in the header. The value "1" indicates that the sender is requesting an interchange
     * acknowledgment at receipt of the interchange. The value "0" is used otherwise.
     * </p>
     * 
     * @return Located at position ISA-14 in the header. The value "1" indicates that the sender is requesting an
     *         interchange acknowledgment at receipt of the interchange. The value "0" is used otherwise.
     */
    public final String acknowledgmentRequestedCode() {
        return acknowledgmentRequestedCode;
    }

    /**
     * <p>
     * Located at position ISA-15 in the header. Specifies how this interchange is being used:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>T</code> indicates this interchange is for testing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>P</code> indicates this interchange is for production.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>I</code> indicates this interchange is informational.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Located at position ISA-15 in the header. Specifies how this interchange is being used:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>T</code> indicates this interchange is for testing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>P</code> indicates this interchange is for production.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>I</code> indicates this interchange is informational.
     *         </p>
     *         </li>
     */
    public final String usageIndicatorCode() {
        return usageIndicatorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(senderIdQualifier());
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        hashCode = 31 * hashCode + Objects.hashCode(receiverIdQualifier());
        hashCode = 31 * hashCode + Objects.hashCode(receiverId());
        hashCode = 31 * hashCode + Objects.hashCode(repetitionSeparator());
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgmentRequestedCode());
        hashCode = 31 * hashCode + Objects.hashCode(usageIndicatorCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12InterchangeControlHeaders)) {
            return false;
        }
        X12InterchangeControlHeaders other = (X12InterchangeControlHeaders) obj;
        return Objects.equals(senderIdQualifier(), other.senderIdQualifier()) && Objects.equals(senderId(), other.senderId())
                && Objects.equals(receiverIdQualifier(), other.receiverIdQualifier())
                && Objects.equals(receiverId(), other.receiverId())
                && Objects.equals(repetitionSeparator(), other.repetitionSeparator())
                && Objects.equals(acknowledgmentRequestedCode(), other.acknowledgmentRequestedCode())
                && Objects.equals(usageIndicatorCode(), other.usageIndicatorCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("X12InterchangeControlHeaders").add("SenderIdQualifier", senderIdQualifier())
                .add("SenderId", senderId()).add("ReceiverIdQualifier", receiverIdQualifier()).add("ReceiverId", receiverId())
                .add("RepetitionSeparator", repetitionSeparator())
                .add("AcknowledgmentRequestedCode", acknowledgmentRequestedCode())
                .add("UsageIndicatorCode", usageIndicatorCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "senderIdQualifier":
            return Optional.ofNullable(clazz.cast(senderIdQualifier()));
        case "senderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        case "receiverIdQualifier":
            return Optional.ofNullable(clazz.cast(receiverIdQualifier()));
        case "receiverId":
            return Optional.ofNullable(clazz.cast(receiverId()));
        case "repetitionSeparator":
            return Optional.ofNullable(clazz.cast(repetitionSeparator()));
        case "acknowledgmentRequestedCode":
            return Optional.ofNullable(clazz.cast(acknowledgmentRequestedCode()));
        case "usageIndicatorCode":
            return Optional.ofNullable(clazz.cast(usageIndicatorCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<X12InterchangeControlHeaders, T> g) {
        return obj -> g.apply((X12InterchangeControlHeaders) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, X12InterchangeControlHeaders> {
        /**
         * <p>
         * Located at position ISA-05 in the header. Qualifier for the sender ID. Together, the ID and qualifier
         * uniquely identify the sending trading partner.
         * </p>
         * 
         * @param senderIdQualifier
         *        Located at position ISA-05 in the header. Qualifier for the sender ID. Together, the ID and qualifier
         *        uniquely identify the sending trading partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderIdQualifier(String senderIdQualifier);

        /**
         * <p>
         * Located at position ISA-06 in the header. This value (along with the <code>senderIdQualifier</code>)
         * identifies the sender of the interchange.
         * </p>
         * 
         * @param senderId
         *        Located at position ISA-06 in the header. This value (along with the <code>senderIdQualifier</code>)
         *        identifies the sender of the interchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);

        /**
         * <p>
         * Located at position ISA-07 in the header. Qualifier for the receiver ID. Together, the ID and qualifier
         * uniquely identify the receiving trading partner.
         * </p>
         * 
         * @param receiverIdQualifier
         *        Located at position ISA-07 in the header. Qualifier for the receiver ID. Together, the ID and
         *        qualifier uniquely identify the receiving trading partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverIdQualifier(String receiverIdQualifier);

        /**
         * <p>
         * Located at position ISA-08 in the header. This value (along with the <code>receiverIdQualifier</code>)
         * identifies the intended recipient of the interchange.
         * </p>
         * 
         * @param receiverId
         *        Located at position ISA-08 in the header. This value (along with the <code>receiverIdQualifier</code>)
         *        identifies the intended recipient of the interchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverId(String receiverId);

        /**
         * <p>
         * Located at position ISA-11 in the header. This string makes it easier when you need to group similar adjacent
         * element values together without using extra segments.
         * </p>
         * <note>
         * <p>
         * This parameter is only honored for version greater than 401 (<code>VERSION_4010</code> and higher).
         * </p>
         * <p>
         * For versions less than 401, this field is called <a
         * href="https://www.stedi.com/edi/x12-004010/segment/ISA#ISA-11">StandardsId</a>, in which case our service
         * sets the value to <code>U</code>.
         * </p>
         * </note>
         * 
         * @param repetitionSeparator
         *        Located at position ISA-11 in the header. This string makes it easier when you need to group similar
         *        adjacent element values together without using extra segments.</p> <note>
         *        <p>
         *        This parameter is only honored for version greater than 401 (<code>VERSION_4010</code> and higher).
         *        </p>
         *        <p>
         *        For versions less than 401, this field is called <a
         *        href="https://www.stedi.com/edi/x12-004010/segment/ISA#ISA-11">StandardsId</a>, in which case our
         *        service sets the value to <code>U</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repetitionSeparator(String repetitionSeparator);

        /**
         * <p>
         * Located at position ISA-14 in the header. The value "1" indicates that the sender is requesting an
         * interchange acknowledgment at receipt of the interchange. The value "0" is used otherwise.
         * </p>
         * 
         * @param acknowledgmentRequestedCode
         *        Located at position ISA-14 in the header. The value "1" indicates that the sender is requesting an
         *        interchange acknowledgment at receipt of the interchange. The value "0" is used otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgmentRequestedCode(String acknowledgmentRequestedCode);

        /**
         * <p>
         * Located at position ISA-15 in the header. Specifies how this interchange is being used:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>T</code> indicates this interchange is for testing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>P</code> indicates this interchange is for production.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>I</code> indicates this interchange is informational.
         * </p>
         * </li>
         * </ul>
         * 
         * @param usageIndicatorCode
         *        Located at position ISA-15 in the header. Specifies how this interchange is being used:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>T</code> indicates this interchange is for testing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>P</code> indicates this interchange is for production.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>I</code> indicates this interchange is informational.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageIndicatorCode(String usageIndicatorCode);
    }

    static final class BuilderImpl implements Builder {
        private String senderIdQualifier;

        private String senderId;

        private String receiverIdQualifier;

        private String receiverId;

        private String repetitionSeparator;

        private String acknowledgmentRequestedCode;

        private String usageIndicatorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(X12InterchangeControlHeaders model) {
            senderIdQualifier(model.senderIdQualifier);
            senderId(model.senderId);
            receiverIdQualifier(model.receiverIdQualifier);
            receiverId(model.receiverId);
            repetitionSeparator(model.repetitionSeparator);
            acknowledgmentRequestedCode(model.acknowledgmentRequestedCode);
            usageIndicatorCode(model.usageIndicatorCode);
        }

        public final String getSenderIdQualifier() {
            return senderIdQualifier;
        }

        public final void setSenderIdQualifier(String senderIdQualifier) {
            this.senderIdQualifier = senderIdQualifier;
        }

        @Override
        public final Builder senderIdQualifier(String senderIdQualifier) {
            this.senderIdQualifier = senderIdQualifier;
            return this;
        }

        public final String getSenderId() {
            return senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final String getReceiverIdQualifier() {
            return receiverIdQualifier;
        }

        public final void setReceiverIdQualifier(String receiverIdQualifier) {
            this.receiverIdQualifier = receiverIdQualifier;
        }

        @Override
        public final Builder receiverIdQualifier(String receiverIdQualifier) {
            this.receiverIdQualifier = receiverIdQualifier;
            return this;
        }

        public final String getReceiverId() {
            return receiverId;
        }

        public final void setReceiverId(String receiverId) {
            this.receiverId = receiverId;
        }

        @Override
        public final Builder receiverId(String receiverId) {
            this.receiverId = receiverId;
            return this;
        }

        public final String getRepetitionSeparator() {
            return repetitionSeparator;
        }

        public final void setRepetitionSeparator(String repetitionSeparator) {
            this.repetitionSeparator = repetitionSeparator;
        }

        @Override
        public final Builder repetitionSeparator(String repetitionSeparator) {
            this.repetitionSeparator = repetitionSeparator;
            return this;
        }

        public final String getAcknowledgmentRequestedCode() {
            return acknowledgmentRequestedCode;
        }

        public final void setAcknowledgmentRequestedCode(String acknowledgmentRequestedCode) {
            this.acknowledgmentRequestedCode = acknowledgmentRequestedCode;
        }

        @Override
        public final Builder acknowledgmentRequestedCode(String acknowledgmentRequestedCode) {
            this.acknowledgmentRequestedCode = acknowledgmentRequestedCode;
            return this;
        }

        public final String getUsageIndicatorCode() {
            return usageIndicatorCode;
        }

        public final void setUsageIndicatorCode(String usageIndicatorCode) {
            this.usageIndicatorCode = usageIndicatorCode;
        }

        @Override
        public final Builder usageIndicatorCode(String usageIndicatorCode) {
            this.usageIndicatorCode = usageIndicatorCode;
            return this;
        }

        @Override
        public X12InterchangeControlHeaders build() {
            return new X12InterchangeControlHeaders(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
