/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.MappingType;
import software.amazon.awssdk.services.b2bi.model.S3Location;
import software.amazon.awssdk.services.b2bi.model.TemplateDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStarterMappingTemplateRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, CreateStarterMappingTemplateRequest> {
    private static final SdkField<S3Location> OUTPUT_SAMPLE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputSampleLocation").getter(CreateStarterMappingTemplateRequest.getter(CreateStarterMappingTemplateRequest::outputSampleLocation)).setter(CreateStarterMappingTemplateRequest.setter(Builder::outputSampleLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSampleLocation").build()}).build();
    private static final SdkField<String> MAPPING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mappingType").getter(CreateStarterMappingTemplateRequest.getter(CreateStarterMappingTemplateRequest::mappingTypeAsString)).setter(CreateStarterMappingTemplateRequest.setter(Builder::mappingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingType").build()}).build();
    private static final SdkField<TemplateDetails> TEMPLATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("templateDetails").getter(CreateStarterMappingTemplateRequest.getter(CreateStarterMappingTemplateRequest::templateDetails)).setter(CreateStarterMappingTemplateRequest.setter(Builder::templateDetails)).constructor(TemplateDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_SAMPLE_LOCATION_FIELD, MAPPING_TYPE_FIELD, TEMPLATE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("outputSampleLocation", OUTPUT_SAMPLE_LOCATION_FIELD);
            this.put("mappingType", MAPPING_TYPE_FIELD);
            this.put("templateDetails", TEMPLATE_DETAILS_FIELD);
        }
    });
    private final S3Location outputSampleLocation;
    private final String mappingType;
    private final TemplateDetails templateDetails;

    private CreateStarterMappingTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.outputSampleLocation = builder.outputSampleLocation;
        this.mappingType = builder.mappingType;
        this.templateDetails = builder.templateDetails;
    }

    public final S3Location outputSampleLocation() {
        return this.outputSampleLocation;
    }

    public final MappingType mappingType() {
        return MappingType.fromValue(this.mappingType);
    }

    public final String mappingTypeAsString() {
        return this.mappingType;
    }

    public final TemplateDetails templateDetails() {
        return this.templateDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSampleLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStarterMappingTemplateRequest)) {
            return false;
        }
        CreateStarterMappingTemplateRequest other = (CreateStarterMappingTemplateRequest)((Object)obj);
        return Objects.equals(this.outputSampleLocation(), other.outputSampleLocation()) && Objects.equals(this.mappingTypeAsString(), other.mappingTypeAsString()) && Objects.equals(this.templateDetails(), other.templateDetails());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStarterMappingTemplateRequest").add("OutputSampleLocation", (Object)this.outputSampleLocation()).add("MappingType", (Object)this.mappingTypeAsString()).add("TemplateDetails", (Object)this.templateDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outputSampleLocation": {
                return Optional.ofNullable(clazz.cast(this.outputSampleLocation()));
            }
            case "mappingType": {
                return Optional.ofNullable(clazz.cast(this.mappingTypeAsString()));
            }
            case "templateDetails": {
                return Optional.ofNullable(clazz.cast(this.templateDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateStarterMappingTemplateRequest, T> g) {
        return obj -> g.apply((CreateStarterMappingTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private S3Location outputSampleLocation;
        private String mappingType;
        private TemplateDetails templateDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStarterMappingTemplateRequest model) {
            super(model);
            this.outputSampleLocation(model.outputSampleLocation);
            this.mappingType(model.mappingType);
            this.templateDetails(model.templateDetails);
        }

        public final S3Location.Builder getOutputSampleLocation() {
            return this.outputSampleLocation != null ? this.outputSampleLocation.toBuilder() : null;
        }

        public final void setOutputSampleLocation(S3Location.BuilderImpl outputSampleLocation) {
            this.outputSampleLocation = outputSampleLocation != null ? outputSampleLocation.build() : null;
        }

        @Override
        public final Builder outputSampleLocation(S3Location outputSampleLocation) {
            this.outputSampleLocation = outputSampleLocation;
            return this;
        }

        public final String getMappingType() {
            return this.mappingType;
        }

        public final void setMappingType(String mappingType) {
            this.mappingType = mappingType;
        }

        @Override
        public final Builder mappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        @Override
        public final Builder mappingType(MappingType mappingType) {
            this.mappingType(mappingType == null ? null : mappingType.toString());
            return this;
        }

        public final TemplateDetails.Builder getTemplateDetails() {
            return this.templateDetails != null ? this.templateDetails.toBuilder() : null;
        }

        public final void setTemplateDetails(TemplateDetails.BuilderImpl templateDetails) {
            this.templateDetails = templateDetails != null ? templateDetails.build() : null;
        }

        @Override
        public final Builder templateDetails(TemplateDetails templateDetails) {
            this.templateDetails = templateDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStarterMappingTemplateRequest build() {
            return new CreateStarterMappingTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStarterMappingTemplateRequest> {
        public Builder outputSampleLocation(S3Location var1);

        default public Builder outputSampleLocation(Consumer<S3Location.Builder> outputSampleLocation) {
            return this.outputSampleLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(outputSampleLocation)).build());
        }

        public Builder mappingType(String var1);

        public Builder mappingType(MappingType var1);

        public Builder templateDetails(TemplateDetails var1);

        default public Builder templateDetails(Consumer<TemplateDetails.Builder> templateDetails) {
            return this.templateDetails((TemplateDetails)((TemplateDetails.Builder)TemplateDetails.builder().applyMutation(templateDetails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

