/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.MappingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GenerateMappingRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, GenerateMappingRequest> {
    private static final SdkField<String> INPUT_FILE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputFileContent").getter(GenerateMappingRequest.getter(GenerateMappingRequest::inputFileContent)).setter(GenerateMappingRequest.setter(Builder::inputFileContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFileContent").build()}).build();
    private static final SdkField<String> OUTPUT_FILE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputFileContent").getter(GenerateMappingRequest.getter(GenerateMappingRequest::outputFileContent)).setter(GenerateMappingRequest.setter(Builder::outputFileContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFileContent").build()}).build();
    private static final SdkField<String> MAPPING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mappingType").getter(GenerateMappingRequest.getter(GenerateMappingRequest::mappingTypeAsString)).setter(GenerateMappingRequest.setter(Builder::mappingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILE_CONTENT_FIELD, OUTPUT_FILE_CONTENT_FIELD, MAPPING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inputFileContent", INPUT_FILE_CONTENT_FIELD);
            this.put("outputFileContent", OUTPUT_FILE_CONTENT_FIELD);
            this.put("mappingType", MAPPING_TYPE_FIELD);
        }
    });
    private final String inputFileContent;
    private final String outputFileContent;
    private final String mappingType;

    private GenerateMappingRequest(BuilderImpl builder) {
        super(builder);
        this.inputFileContent = builder.inputFileContent;
        this.outputFileContent = builder.outputFileContent;
        this.mappingType = builder.mappingType;
    }

    public final String inputFileContent() {
        return this.inputFileContent;
    }

    public final String outputFileContent() {
        return this.outputFileContent;
    }

    public final MappingType mappingType() {
        return MappingType.fromValue(this.mappingType);
    }

    public final String mappingTypeAsString() {
        return this.mappingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFileContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMappingRequest)) {
            return false;
        }
        GenerateMappingRequest other = (GenerateMappingRequest)((Object)obj);
        return Objects.equals(this.inputFileContent(), other.inputFileContent()) && Objects.equals(this.outputFileContent(), other.outputFileContent()) && Objects.equals(this.mappingTypeAsString(), other.mappingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GenerateMappingRequest").add("InputFileContent", (Object)this.inputFileContent()).add("OutputFileContent", (Object)this.outputFileContent()).add("MappingType", (Object)this.mappingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputFileContent": {
                return Optional.ofNullable(clazz.cast(this.inputFileContent()));
            }
            case "outputFileContent": {
                return Optional.ofNullable(clazz.cast(this.outputFileContent()));
            }
            case "mappingType": {
                return Optional.ofNullable(clazz.cast(this.mappingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GenerateMappingRequest, T> g) {
        return obj -> g.apply((GenerateMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private String inputFileContent;
        private String outputFileContent;
        private String mappingType;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMappingRequest model) {
            super(model);
            this.inputFileContent(model.inputFileContent);
            this.outputFileContent(model.outputFileContent);
            this.mappingType(model.mappingType);
        }

        public final String getInputFileContent() {
            return this.inputFileContent;
        }

        public final void setInputFileContent(String inputFileContent) {
            this.inputFileContent = inputFileContent;
        }

        @Override
        public final Builder inputFileContent(String inputFileContent) {
            this.inputFileContent = inputFileContent;
            return this;
        }

        public final String getOutputFileContent() {
            return this.outputFileContent;
        }

        public final void setOutputFileContent(String outputFileContent) {
            this.outputFileContent = outputFileContent;
        }

        @Override
        public final Builder outputFileContent(String outputFileContent) {
            this.outputFileContent = outputFileContent;
            return this;
        }

        public final String getMappingType() {
            return this.mappingType;
        }

        public final void setMappingType(String mappingType) {
            this.mappingType = mappingType;
        }

        @Override
        public final Builder mappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        @Override
        public final Builder mappingType(MappingType mappingType) {
            this.mappingType(mappingType == null ? null : mappingType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateMappingRequest build() {
            return new GenerateMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GenerateMappingRequest> {
        public Builder inputFileContent(String var1);

        public Builder outputFileContent(String var1);

        public Builder mappingType(String var1);

        public Builder mappingType(MappingType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

