/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.b2bi.model.X12TransactionSet;
import software.amazon.awssdk.services.b2bi.model.X12Version;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class X12Details
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, X12Details> {
    private static final SdkField<String> TRANSACTION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionSet").getter(X12Details.getter(X12Details::transactionSetAsString)).setter(X12Details.setter(Builder::transactionSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionSet").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(X12Details.getter(X12Details::versionAsString)).setter(X12Details.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_SET_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("transactionSet", TRANSACTION_SET_FIELD);
            this.put("version", VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String transactionSet;
    private final String version;

    private X12Details(BuilderImpl builder) {
        this.transactionSet = builder.transactionSet;
        this.version = builder.version;
    }

    public final X12TransactionSet transactionSet() {
        return X12TransactionSet.fromValue(this.transactionSet);
    }

    public final String transactionSetAsString() {
        return this.transactionSet;
    }

    public final X12Version version() {
        return X12Version.fromValue(this.version);
    }

    public final String versionAsString() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionSetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12Details)) {
            return false;
        }
        X12Details other = (X12Details)obj;
        return Objects.equals(this.transactionSetAsString(), other.transactionSetAsString()) && Objects.equals(this.versionAsString(), other.versionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"X12Details").add("TransactionSet", (Object)this.transactionSetAsString()).add("Version", (Object)this.versionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transactionSet": {
                return Optional.ofNullable(clazz.cast(this.transactionSetAsString()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.versionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<X12Details, T> g) {
        return obj -> g.apply((X12Details)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transactionSet;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(X12Details model) {
            this.transactionSet(model.transactionSet);
            this.version(model.version);
        }

        public final String getTransactionSet() {
            return this.transactionSet;
        }

        public final void setTransactionSet(String transactionSet) {
            this.transactionSet = transactionSet;
        }

        @Override
        public final Builder transactionSet(String transactionSet) {
            this.transactionSet = transactionSet;
            return this;
        }

        @Override
        public final Builder transactionSet(X12TransactionSet transactionSet) {
            this.transactionSet(transactionSet == null ? null : transactionSet.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public final Builder version(X12Version version) {
            this.version(version == null ? null : version.toString());
            return this;
        }

        public X12Details build() {
            return new X12Details(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, X12Details> {
        public Builder transactionSet(String var1);

        public Builder transactionSet(X12TransactionSet var1);

        public Builder version(String var1);

        public Builder version(X12Version var1);
    }
}

