/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the input for an outbound transformation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConversionSource implements SdkPojo, Serializable,
        ToCopyableBuilder<ConversionSource.Builder, ConversionSource> {
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(ConversionSource::fileFormatAsString)).setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<InputFileSource> INPUT_FILE_FIELD = SdkField
            .<InputFileSource> builder(MarshallingType.SDK_POJO).memberName("inputFile")
            .getter(getter(ConversionSource::inputFile)).setter(setter(Builder::inputFile)).constructor(InputFileSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FORMAT_FIELD,
            INPUT_FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileFormat;

    private final InputFileSource inputFile;

    private ConversionSource(BuilderImpl builder) {
        this.fileFormat = builder.fileFormat;
        this.inputFile = builder.inputFile;
    }

    /**
     * <p>
     * The format for the input file: either JSON or XML.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link ConversionSourceFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format for the input file: either JSON or XML.
     * @see ConversionSourceFormat
     */
    public final ConversionSourceFormat fileFormat() {
        return ConversionSourceFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * The format for the input file: either JSON or XML.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link ConversionSourceFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format for the input file: either JSON or XML.
     * @see ConversionSourceFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * File to be converted
     * </p>
     * 
     * @return File to be converted
     */
    public final InputFileSource inputFile() {
        return inputFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionSource)) {
            return false;
        }
        ConversionSource other = (ConversionSource) obj;
        return Objects.equals(fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(inputFile(), other.inputFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConversionSource").add("FileFormat", fileFormatAsString()).add("InputFile", inputFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "inputFile":
            return Optional.ofNullable(clazz.cast(inputFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileFormat", FILE_FORMAT_FIELD);
        map.put("inputFile", INPUT_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConversionSource, T> g) {
        return obj -> g.apply((ConversionSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConversionSource> {
        /**
         * <p>
         * The format for the input file: either JSON or XML.
         * </p>
         * 
         * @param fileFormat
         *        The format for the input file: either JSON or XML.
         * @see ConversionSourceFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversionSourceFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * The format for the input file: either JSON or XML.
         * </p>
         * 
         * @param fileFormat
         *        The format for the input file: either JSON or XML.
         * @see ConversionSourceFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConversionSourceFormat
         */
        Builder fileFormat(ConversionSourceFormat fileFormat);

        /**
         * <p>
         * File to be converted
         * </p>
         * 
         * @param inputFile
         *        File to be converted
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFile(InputFileSource inputFile);

        /**
         * <p>
         * File to be converted
         * </p>
         * This is a convenience method that creates an instance of the {@link InputFileSource.Builder} avoiding the
         * need to create one manually via {@link InputFileSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputFileSource.Builder#build()} is called immediately and its
         * result is passed to {@link #inputFile(InputFileSource)}.
         * 
         * @param inputFile
         *        a consumer that will call methods on {@link InputFileSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputFile(InputFileSource)
         */
        default Builder inputFile(Consumer<InputFileSource.Builder> inputFile) {
            return inputFile(InputFileSource.builder().applyMutation(inputFile).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fileFormat;

        private InputFileSource inputFile;

        private BuilderImpl() {
        }

        private BuilderImpl(ConversionSource model) {
            fileFormat(model.fileFormat);
            inputFile(model.inputFile);
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(ConversionSourceFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final InputFileSource.Builder getInputFile() {
            return inputFile != null ? inputFile.toBuilder() : null;
        }

        public final void setInputFile(InputFileSource.BuilderImpl inputFile) {
            this.inputFile = inputFile != null ? inputFile.build() : null;
        }

        @Override
        public final Builder inputFile(InputFileSource inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        @Override
        public ConversionSource build() {
            return new ConversionSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
