/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCapabilityRequest extends B2BiRequest implements
        ToCopyableBuilder<CreateCapabilityRequest.Builder, CreateCapabilityRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCapabilityRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateCapabilityRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<CapabilityConfiguration> CONFIGURATION_FIELD = SdkField
            .<CapabilityConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateCapabilityRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(CapabilityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<List<S3Location>> INSTRUCTIONS_DOCUMENTS_FIELD = SdkField
            .<List<S3Location>> builder(MarshallingType.LIST)
            .memberName("instructionsDocuments")
            .getter(getter(CreateCapabilityRequest::instructionsDocuments))
            .setter(setter(Builder::instructionsDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructionsDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Location::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateCapabilityRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateCapabilityRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            CONFIGURATION_FIELD, INSTRUCTIONS_DOCUMENTS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String type;

    private final CapabilityConfiguration configuration;

    private final List<S3Location> instructionsDocuments;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateCapabilityRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.instructionsDocuments = builder.instructionsDocuments;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies the name of the capability, used to identify it.
     * </p>
     * 
     * @return Specifies the name of the capability, used to identify it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the type of the capability. Currently, only <code>edi</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of the capability. Currently, only <code>edi</code> is supported.
     * @see CapabilityType
     */
    public final CapabilityType type() {
        return CapabilityType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the type of the capability. Currently, only <code>edi</code> is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CapabilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of the capability. Currently, only <code>edi</code> is supported.
     * @see CapabilityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies a structure that contains the details for a capability.
     * </p>
     * 
     * @return Specifies a structure that contains the details for a capability.
     */
    public final CapabilityConfiguration configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstructionsDocuments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInstructionsDocuments() {
        return instructionsDocuments != null && !(instructionsDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this
     * capability. Each item contains the name of the bucket and the key, to identify the document's location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstructionsDocuments} method.
     * </p>
     * 
     * @return Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this
     *         capability. Each item contains the name of the bucket and the key, to identify the document's location.
     */
    public final List<S3Location> instructionsDocuments() {
        return instructionsDocuments;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You
     * can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
     *         type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstructionsDocuments() ? instructionsDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapabilityRequest)) {
            return false;
        }
        CreateCapabilityRequest other = (CreateCapabilityRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(configuration(), other.configuration())
                && hasInstructionsDocuments() == other.hasInstructionsDocuments()
                && Objects.equals(instructionsDocuments(), other.instructionsDocuments())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCapabilityRequest").add("Name", name()).add("Type", typeAsString())
                .add("Configuration", configuration())
                .add("InstructionsDocuments", hasInstructionsDocuments() ? instructionsDocuments() : null)
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "instructionsDocuments":
            return Optional.ofNullable(clazz.cast(instructionsDocuments()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("instructionsDocuments", INSTRUCTIONS_DOCUMENTS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCapabilityRequest, T> g) {
        return obj -> g.apply((CreateCapabilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCapabilityRequest> {
        /**
         * <p>
         * Specifies the name of the capability, used to identify it.
         * </p>
         * 
         * @param name
         *        Specifies the name of the capability, used to identify it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the type of the capability. Currently, only <code>edi</code> is supported.
         * </p>
         * 
         * @param type
         *        Specifies the type of the capability. Currently, only <code>edi</code> is supported.
         * @see CapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the type of the capability. Currently, only <code>edi</code> is supported.
         * </p>
         * 
         * @param type
         *        Specifies the type of the capability. Currently, only <code>edi</code> is supported.
         * @see CapabilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityType
         */
        Builder type(CapabilityType type);

        /**
         * <p>
         * Specifies a structure that contains the details for a capability.
         * </p>
         * 
         * @param configuration
         *        Specifies a structure that contains the details for a capability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(CapabilityConfiguration configuration);

        /**
         * <p>
         * Specifies a structure that contains the details for a capability.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapabilityConfiguration.Builder} avoiding
         * the need to create one manually via {@link CapabilityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapabilityConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(CapabilityConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link CapabilityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(CapabilityConfiguration)
         */
        default Builder configuration(Consumer<CapabilityConfiguration.Builder> configuration) {
            return configuration(CapabilityConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         * capability. Each item contains the name of the bucket and the key, to identify the document's location.
         * </p>
         * 
         * @param instructionsDocuments
         *        Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with
         *        this capability. Each item contains the name of the bucket and the key, to identify the document's
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructionsDocuments(Collection<S3Location> instructionsDocuments);

        /**
         * <p>
         * Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         * capability. Each item contains the name of the bucket and the key, to identify the document's location.
         * </p>
         * 
         * @param instructionsDocuments
         *        Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with
         *        this capability. Each item contains the name of the bucket and the key, to identify the document's
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instructionsDocuments(S3Location... instructionsDocuments);

        /**
         * <p>
         * Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this
         * capability. Each item contains the name of the bucket and the key, to identify the document's location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.b2bi.model.S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder#build()} is called immediately and its
         * result is passed to {@link #instructionsDocuments(List<S3Location>)}.
         * 
         * @param instructionsDocuments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.b2bi.model.S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instructionsDocuments(java.util.Collection<S3Location>)
         */
        Builder instructionsDocuments(Consumer<S3Location.Builder>... instructionsDocuments);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param clientToken
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
         *        type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any
         *        purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
         *        type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any
         *        purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.b2bi.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String name;

        private String type;

        private CapabilityConfiguration configuration;

        private List<S3Location> instructionsDocuments = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapabilityRequest model) {
            super(model);
            name(model.name);
            type(model.type);
            configuration(model.configuration);
            instructionsDocuments(model.instructionsDocuments);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CapabilityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CapabilityConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(CapabilityConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(CapabilityConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<S3Location.Builder> getInstructionsDocuments() {
            List<S3Location.Builder> result = InstructionsDocumentsCopier.copyToBuilder(this.instructionsDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstructionsDocuments(Collection<S3Location.BuilderImpl> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copyFromBuilder(instructionsDocuments);
        }

        @Override
        public final Builder instructionsDocuments(Collection<S3Location> instructionsDocuments) {
            this.instructionsDocuments = InstructionsDocumentsCopier.copy(instructionsDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(S3Location... instructionsDocuments) {
            instructionsDocuments(Arrays.asList(instructionsDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instructionsDocuments(Consumer<S3Location.Builder>... instructionsDocuments) {
            instructionsDocuments(Stream.of(instructionsDocuments).map(c -> S3Location.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCapabilityRequest build() {
            return new CreateCapabilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
