/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePartnershipResponse extends B2BiResponse implements
        ToCopyableBuilder<CreatePartnershipResponse.Builder, CreatePartnershipResponse> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileId").getter(getter(CreatePartnershipResponse::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()).build();

    private static final SdkField<String> PARTNERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partnershipId").getter(getter(CreatePartnershipResponse::partnershipId))
            .setter(setter(Builder::partnershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnershipId").build()).build();

    private static final SdkField<String> PARTNERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partnershipArn").getter(getter(CreatePartnershipResponse::partnershipArn))
            .setter(setter(Builder::partnershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partnershipArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreatePartnershipResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("email")
            .getter(getter(CreatePartnershipResponse::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<String> PHONE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("phone")
            .getter(getter(CreatePartnershipResponse::phone)).setter(setter(Builder::phone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phone").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(CreatePartnershipResponse::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CapabilityOptions> CAPABILITY_OPTIONS_FIELD = SdkField
            .<CapabilityOptions> builder(MarshallingType.SDK_POJO).memberName("capabilityOptions")
            .getter(getter(CreatePartnershipResponse::capabilityOptions)).setter(setter(Builder::capabilityOptions))
            .constructor(CapabilityOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityOptions").build()).build();

    private static final SdkField<String> TRADING_PARTNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tradingPartnerId").getter(getter(CreatePartnershipResponse::tradingPartnerId))
            .setter(setter(Builder::tradingPartnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tradingPartnerId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CreatePartnershipResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD,
            PARTNERSHIP_ID_FIELD, PARTNERSHIP_ARN_FIELD, NAME_FIELD, EMAIL_FIELD, PHONE_FIELD, CAPABILITIES_FIELD,
            CAPABILITY_OPTIONS_FIELD, TRADING_PARTNER_ID_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String profileId;

    private final String partnershipId;

    private final String partnershipArn;

    private final String name;

    private final String email;

    private final String phone;

    private final List<String> capabilities;

    private final CapabilityOptions capabilityOptions;

    private final String tradingPartnerId;

    private final Instant createdAt;

    private CreatePartnershipResponse(BuilderImpl builder) {
        super(builder);
        this.profileId = builder.profileId;
        this.partnershipId = builder.partnershipId;
        this.partnershipArn = builder.partnershipArn;
        this.name = builder.name;
        this.email = builder.email;
        this.phone = builder.phone;
        this.capabilities = builder.capabilities;
        this.capabilityOptions = builder.capabilityOptions;
        this.tradingPartnerId = builder.tradingPartnerId;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * Returns the unique, system-generated identifier for the profile connected to this partnership.
     * </p>
     * 
     * @return Returns the unique, system-generated identifier for the profile connected to this partnership.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * Returns the unique, system-generated identifier for a partnership.
     * </p>
     * 
     * @return Returns the unique, system-generated identifier for a partnership.
     */
    public final String partnershipId() {
        return partnershipId;
    }

    /**
     * <p>
     * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
     * partnership, profile, or transformer.
     * </p>
     * 
     * @return Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
     *         partnership, profile, or transformer.
     */
    public final String partnershipArn() {
        return partnershipArn;
    }

    /**
     * <p>
     * Returns a descriptive name for the partnership.
     * </p>
     * 
     * @return Returns a descriptive name for the partnership.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Returns the email address associated with this trading partner.
     * </p>
     * 
     * @return Returns the email address associated with this trading partner.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * Returns the phone number associated with the partnership.
     * </p>
     * 
     * @return Returns the phone number associated with the partnership.
     */
    public final String phone() {
        return phone;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns one or more capabilities associated with this partnership.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Returns one or more capabilities associated with this partnership.
     */
    public final List<String> capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * Returns the structure that contains the details for the associated capabilities.
     * </p>
     * 
     * @return Returns the structure that contains the details for the associated capabilities.
     */
    public final CapabilityOptions capabilityOptions() {
        return capabilityOptions;
    }

    /**
     * <p>
     * Returns the unique, system-generated identifier for a trading partner.
     * </p>
     * 
     * @return Returns the unique, system-generated identifier for a trading partner.
     */
    public final String tradingPartnerId() {
        return tradingPartnerId;
    }

    /**
     * <p>
     * Returns a timestamp for creation date and time of the partnership.
     * </p>
     * 
     * @return Returns a timestamp for creation date and time of the partnership.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(partnershipId());
        hashCode = 31 * hashCode + Objects.hashCode(partnershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(phone());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capabilityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(tradingPartnerId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePartnershipResponse)) {
            return false;
        }
        CreatePartnershipResponse other = (CreatePartnershipResponse) obj;
        return Objects.equals(profileId(), other.profileId()) && Objects.equals(partnershipId(), other.partnershipId())
                && Objects.equals(partnershipArn(), other.partnershipArn()) && Objects.equals(name(), other.name())
                && Objects.equals(email(), other.email()) && Objects.equals(phone(), other.phone())
                && hasCapabilities() == other.hasCapabilities() && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(capabilityOptions(), other.capabilityOptions())
                && Objects.equals(tradingPartnerId(), other.tradingPartnerId()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePartnershipResponse").add("ProfileId", profileId()).add("PartnershipId", partnershipId())
                .add("PartnershipArn", partnershipArn()).add("Name", name())
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Phone", phone() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Capabilities", hasCapabilities() ? capabilities() : null).add("CapabilityOptions", capabilityOptions())
                .add("TradingPartnerId", tradingPartnerId()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "profileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "partnershipId":
            return Optional.ofNullable(clazz.cast(partnershipId()));
        case "partnershipArn":
            return Optional.ofNullable(clazz.cast(partnershipArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "email":
            return Optional.ofNullable(clazz.cast(email()));
        case "phone":
            return Optional.ofNullable(clazz.cast(phone()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "capabilityOptions":
            return Optional.ofNullable(clazz.cast(capabilityOptions()));
        case "tradingPartnerId":
            return Optional.ofNullable(clazz.cast(tradingPartnerId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("profileId", PROFILE_ID_FIELD);
        map.put("partnershipId", PARTNERSHIP_ID_FIELD);
        map.put("partnershipArn", PARTNERSHIP_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("email", EMAIL_FIELD);
        map.put("phone", PHONE_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        map.put("capabilityOptions", CAPABILITY_OPTIONS_FIELD);
        map.put("tradingPartnerId", TRADING_PARTNER_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePartnershipResponse, T> g) {
        return obj -> g.apply((CreatePartnershipResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePartnershipResponse> {
        /**
         * <p>
         * Returns the unique, system-generated identifier for the profile connected to this partnership.
         * </p>
         * 
         * @param profileId
         *        Returns the unique, system-generated identifier for the profile connected to this partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * Returns the unique, system-generated identifier for a partnership.
         * </p>
         * 
         * @param partnershipId
         *        Returns the unique, system-generated identifier for a partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnershipId(String partnershipId);

        /**
         * <p>
         * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability,
         * partnership, profile, or transformer.
         * </p>
         * 
         * @param partnershipArn
         *        Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a
         *        capability, partnership, profile, or transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnershipArn(String partnershipArn);

        /**
         * <p>
         * Returns a descriptive name for the partnership.
         * </p>
         * 
         * @param name
         *        Returns a descriptive name for the partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Returns the email address associated with this trading partner.
         * </p>
         * 
         * @param email
         *        Returns the email address associated with this trading partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * Returns the phone number associated with the partnership.
         * </p>
         * 
         * @param phone
         *        Returns the phone number associated with the partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phone(String phone);

        /**
         * <p>
         * Returns one or more capabilities associated with this partnership.
         * </p>
         * 
         * @param capabilities
         *        Returns one or more capabilities associated with this partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * Returns one or more capabilities associated with this partnership.
         * </p>
         * 
         * @param capabilities
         *        Returns one or more capabilities associated with this partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * Returns the structure that contains the details for the associated capabilities.
         * </p>
         * 
         * @param capabilityOptions
         *        Returns the structure that contains the details for the associated capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilityOptions(CapabilityOptions capabilityOptions);

        /**
         * <p>
         * Returns the structure that contains the details for the associated capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapabilityOptions.Builder} avoiding the
         * need to create one manually via {@link CapabilityOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapabilityOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilityOptions(CapabilityOptions)}.
         * 
         * @param capabilityOptions
         *        a consumer that will call methods on {@link CapabilityOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilityOptions(CapabilityOptions)
         */
        default Builder capabilityOptions(Consumer<CapabilityOptions.Builder> capabilityOptions) {
            return capabilityOptions(CapabilityOptions.builder().applyMutation(capabilityOptions).build());
        }

        /**
         * <p>
         * Returns the unique, system-generated identifier for a trading partner.
         * </p>
         * 
         * @param tradingPartnerId
         *        Returns the unique, system-generated identifier for a trading partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tradingPartnerId(String tradingPartnerId);

        /**
         * <p>
         * Returns a timestamp for creation date and time of the partnership.
         * </p>
         * 
         * @param createdAt
         *        Returns a timestamp for creation date and time of the partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private String profileId;

        private String partnershipId;

        private String partnershipArn;

        private String name;

        private String email;

        private String phone;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private CapabilityOptions capabilityOptions;

        private String tradingPartnerId;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePartnershipResponse model) {
            super(model);
            profileId(model.profileId);
            partnershipId(model.partnershipId);
            partnershipArn(model.partnershipArn);
            name(model.name);
            email(model.email);
            phone(model.phone);
            capabilities(model.capabilities);
            capabilityOptions(model.capabilityOptions);
            tradingPartnerId(model.tradingPartnerId);
            createdAt(model.createdAt);
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getPartnershipId() {
            return partnershipId;
        }

        public final void setPartnershipId(String partnershipId) {
            this.partnershipId = partnershipId;
        }

        @Override
        public final Builder partnershipId(String partnershipId) {
            this.partnershipId = partnershipId;
            return this;
        }

        public final String getPartnershipArn() {
            return partnershipArn;
        }

        public final void setPartnershipArn(String partnershipArn) {
            this.partnershipArn = partnershipArn;
        }

        @Override
        public final Builder partnershipArn(String partnershipArn) {
            this.partnershipArn = partnershipArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getPhone() {
            return phone;
        }

        public final void setPhone(String phone) {
            this.phone = phone;
        }

        @Override
        public final Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = PartnershipCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final CapabilityOptions.Builder getCapabilityOptions() {
            return capabilityOptions != null ? capabilityOptions.toBuilder() : null;
        }

        public final void setCapabilityOptions(CapabilityOptions.BuilderImpl capabilityOptions) {
            this.capabilityOptions = capabilityOptions != null ? capabilityOptions.build() : null;
        }

        @Override
        public final Builder capabilityOptions(CapabilityOptions capabilityOptions) {
            this.capabilityOptions = capabilityOptions;
            return this;
        }

        public final String getTradingPartnerId() {
            return tradingPartnerId;
        }

        public final void setTradingPartnerId(String tradingPartnerId) {
            this.tradingPartnerId = tradingPartnerId;
        }

        @Override
        public final Builder tradingPartnerId(String tradingPartnerId) {
            this.tradingPartnerId = tradingPartnerId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreatePartnershipResponse build() {
            return new CreatePartnershipResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
