/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStarterMappingTemplateRequest extends B2BiRequest implements
        ToCopyableBuilder<CreateStarterMappingTemplateRequest.Builder, CreateStarterMappingTemplateRequest> {
    private static final SdkField<S3Location> OUTPUT_SAMPLE_LOCATION_FIELD = SdkField
            .<S3Location> builder(MarshallingType.SDK_POJO).memberName("outputSampleLocation")
            .getter(getter(CreateStarterMappingTemplateRequest::outputSampleLocation))
            .setter(setter(Builder::outputSampleLocation)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSampleLocation").build())
            .build();

    private static final SdkField<String> MAPPING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mappingType").getter(getter(CreateStarterMappingTemplateRequest::mappingTypeAsString))
            .setter(setter(Builder::mappingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingType").build()).build();

    private static final SdkField<TemplateDetails> TEMPLATE_DETAILS_FIELD = SdkField
            .<TemplateDetails> builder(MarshallingType.SDK_POJO).memberName("templateDetails")
            .getter(getter(CreateStarterMappingTemplateRequest::templateDetails)).setter(setter(Builder::templateDetails))
            .constructor(TemplateDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_SAMPLE_LOCATION_FIELD,
            MAPPING_TYPE_FIELD, TEMPLATE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final S3Location outputSampleLocation;

    private final String mappingType;

    private final TemplateDetails templateDetails;

    private CreateStarterMappingTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.outputSampleLocation = builder.outputSampleLocation;
        this.mappingType = builder.mappingType;
        this.templateDetails = builder.templateDetails;
    }

    /**
     * <p>
     * Specify the location of the sample EDI file that is used to generate the mapping template.
     * </p>
     * 
     * @return Specify the location of the sample EDI file that is used to generate the mapping template.
     */
    public final S3Location outputSampleLocation() {
        return outputSampleLocation;
    }

    /**
     * <p>
     * Specify the format for the mapping template: either JSONATA or XSLT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mappingType} will
     * return {@link MappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mappingTypeAsString}.
     * </p>
     * 
     * @return Specify the format for the mapping template: either JSONATA or XSLT.
     * @see MappingType
     */
    public final MappingType mappingType() {
        return MappingType.fromValue(mappingType);
    }

    /**
     * <p>
     * Specify the format for the mapping template: either JSONATA or XSLT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mappingType} will
     * return {@link MappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mappingTypeAsString}.
     * </p>
     * 
     * @return Specify the format for the mapping template: either JSONATA or XSLT.
     * @see MappingType
     */
    public final String mappingTypeAsString() {
        return mappingType;
    }

    /**
     * <p>
     * Describes the details needed for generating the template. Specify the X12 transaction set and version for which
     * the template is used: currently, we only support X12.
     * </p>
     * 
     * @return Describes the details needed for generating the template. Specify the X12 transaction set and version for
     *         which the template is used: currently, we only support X12.
     */
    public final TemplateDetails templateDetails() {
        return templateDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outputSampleLocation());
        hashCode = 31 * hashCode + Objects.hashCode(mappingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(templateDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStarterMappingTemplateRequest)) {
            return false;
        }
        CreateStarterMappingTemplateRequest other = (CreateStarterMappingTemplateRequest) obj;
        return Objects.equals(outputSampleLocation(), other.outputSampleLocation())
                && Objects.equals(mappingTypeAsString(), other.mappingTypeAsString())
                && Objects.equals(templateDetails(), other.templateDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStarterMappingTemplateRequest").add("OutputSampleLocation", outputSampleLocation())
                .add("MappingType", mappingTypeAsString()).add("TemplateDetails", templateDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputSampleLocation":
            return Optional.ofNullable(clazz.cast(outputSampleLocation()));
        case "mappingType":
            return Optional.ofNullable(clazz.cast(mappingTypeAsString()));
        case "templateDetails":
            return Optional.ofNullable(clazz.cast(templateDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("outputSampleLocation", OUTPUT_SAMPLE_LOCATION_FIELD);
        map.put("mappingType", MAPPING_TYPE_FIELD);
        map.put("templateDetails", TEMPLATE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStarterMappingTemplateRequest, T> g) {
        return obj -> g.apply((CreateStarterMappingTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStarterMappingTemplateRequest> {
        /**
         * <p>
         * Specify the location of the sample EDI file that is used to generate the mapping template.
         * </p>
         * 
         * @param outputSampleLocation
         *        Specify the location of the sample EDI file that is used to generate the mapping template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSampleLocation(S3Location outputSampleLocation);

        /**
         * <p>
         * Specify the location of the sample EDI file that is used to generate the mapping template.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #outputSampleLocation(S3Location)}.
         * 
         * @param outputSampleLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSampleLocation(S3Location)
         */
        default Builder outputSampleLocation(Consumer<S3Location.Builder> outputSampleLocation) {
            return outputSampleLocation(S3Location.builder().applyMutation(outputSampleLocation).build());
        }

        /**
         * <p>
         * Specify the format for the mapping template: either JSONATA or XSLT.
         * </p>
         * 
         * @param mappingType
         *        Specify the format for the mapping template: either JSONATA or XSLT.
         * @see MappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingType
         */
        Builder mappingType(String mappingType);

        /**
         * <p>
         * Specify the format for the mapping template: either JSONATA or XSLT.
         * </p>
         * 
         * @param mappingType
         *        Specify the format for the mapping template: either JSONATA or XSLT.
         * @see MappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MappingType
         */
        Builder mappingType(MappingType mappingType);

        /**
         * <p>
         * Describes the details needed for generating the template. Specify the X12 transaction set and version for
         * which the template is used: currently, we only support X12.
         * </p>
         * 
         * @param templateDetails
         *        Describes the details needed for generating the template. Specify the X12 transaction set and version
         *        for which the template is used: currently, we only support X12.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDetails(TemplateDetails templateDetails);

        /**
         * <p>
         * Describes the details needed for generating the template. Specify the X12 transaction set and version for
         * which the template is used: currently, we only support X12.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateDetails.Builder} avoiding the
         * need to create one manually via {@link TemplateDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #templateDetails(TemplateDetails)}.
         * 
         * @param templateDetails
         *        a consumer that will call methods on {@link TemplateDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateDetails(TemplateDetails)
         */
        default Builder templateDetails(Consumer<TemplateDetails.Builder> templateDetails) {
            return templateDetails(TemplateDetails.builder().applyMutation(templateDetails).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private S3Location outputSampleLocation;

        private String mappingType;

        private TemplateDetails templateDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStarterMappingTemplateRequest model) {
            super(model);
            outputSampleLocation(model.outputSampleLocation);
            mappingType(model.mappingType);
            templateDetails(model.templateDetails);
        }

        public final S3Location.Builder getOutputSampleLocation() {
            return outputSampleLocation != null ? outputSampleLocation.toBuilder() : null;
        }

        public final void setOutputSampleLocation(S3Location.BuilderImpl outputSampleLocation) {
            this.outputSampleLocation = outputSampleLocation != null ? outputSampleLocation.build() : null;
        }

        @Override
        public final Builder outputSampleLocation(S3Location outputSampleLocation) {
            this.outputSampleLocation = outputSampleLocation;
            return this;
        }

        public final String getMappingType() {
            return mappingType;
        }

        public final void setMappingType(String mappingType) {
            this.mappingType = mappingType;
        }

        @Override
        public final Builder mappingType(String mappingType) {
            this.mappingType = mappingType;
            return this;
        }

        @Override
        public final Builder mappingType(MappingType mappingType) {
            this.mappingType(mappingType == null ? null : mappingType.toString());
            return this;
        }

        public final TemplateDetails.Builder getTemplateDetails() {
            return templateDetails != null ? templateDetails.toBuilder() : null;
        }

        public final void setTemplateDetails(TemplateDetails.BuilderImpl templateDetails) {
            this.templateDetails = templateDetails != null ? templateDetails.build() : null;
        }

        @Override
        public final Builder templateDetails(TemplateDetails templateDetails) {
            this.templateDetails = templateDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStarterMappingTemplateRequest build() {
            return new CreateStarterMappingTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
