/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStarterMappingTemplateResponse extends B2BiResponse implements
        ToCopyableBuilder<CreateStarterMappingTemplateResponse.Builder, CreateStarterMappingTemplateResponse> {
    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mappingTemplate").getter(getter(CreateStarterMappingTemplateResponse::mappingTemplate))
            .setter(setter(Builder::mappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAPPING_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mappingTemplate;

    private CreateStarterMappingTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.mappingTemplate = builder.mappingTemplate;
    }

    /**
     * <p>
     * Returns a string that represents the mapping template.
     * </p>
     * 
     * @return Returns a string that represents the mapping template.
     */
    public final String mappingTemplate() {
        return mappingTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mappingTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStarterMappingTemplateResponse)) {
            return false;
        }
        CreateStarterMappingTemplateResponse other = (CreateStarterMappingTemplateResponse) obj;
        return Objects.equals(mappingTemplate(), other.mappingTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStarterMappingTemplateResponse").add("MappingTemplate", mappingTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mappingTemplate":
            return Optional.ofNullable(clazz.cast(mappingTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mappingTemplate", MAPPING_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStarterMappingTemplateResponse, T> g) {
        return obj -> g.apply((CreateStarterMappingTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStarterMappingTemplateResponse> {
        /**
         * <p>
         * Returns a string that represents the mapping template.
         * </p>
         * 
         * @param mappingTemplate
         *        Returns a string that represents the mapping template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingTemplate(String mappingTemplate);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private String mappingTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStarterMappingTemplateResponse model) {
            super(model);
            mappingTemplate(model.mappingTemplate);
        }

        public final String getMappingTemplate() {
            return mappingTemplate;
        }

        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        @Override
        public CreateStarterMappingTemplateResponse build() {
            return new CreateStarterMappingTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
