/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransformerRequest extends B2BiRequest implements
        ToCopyableBuilder<CreateTransformerRequest.Builder, CreateTransformerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateTransformerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateTransformerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateTransformerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(CreateTransformerRequest::fileFormatAsString))
            .setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mappingTemplate").getter(getter(CreateTransformerRequest::mappingTemplate))
            .setter(setter(Builder::mappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()).build();

    private static final SdkField<EdiType> EDI_TYPE_FIELD = SdkField.<EdiType> builder(MarshallingType.SDK_POJO)
            .memberName("ediType").getter(getter(CreateTransformerRequest::ediType)).setter(setter(Builder::ediType))
            .constructor(EdiType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ediType").build()).build();

    private static final SdkField<String> SAMPLE_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleDocument").getter(getter(CreateTransformerRequest::sampleDocument))
            .setter(setter(Builder::sampleDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocument").build()).build();

    private static final SdkField<InputConversion> INPUT_CONVERSION_FIELD = SdkField
            .<InputConversion> builder(MarshallingType.SDK_POJO).memberName("inputConversion")
            .getter(getter(CreateTransformerRequest::inputConversion)).setter(setter(Builder::inputConversion))
            .constructor(InputConversion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConversion").build()).build();

    private static final SdkField<Mapping> MAPPING_FIELD = SdkField.<Mapping> builder(MarshallingType.SDK_POJO)
            .memberName("mapping").getter(getter(CreateTransformerRequest::mapping)).setter(setter(Builder::mapping))
            .constructor(Mapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapping").build()).build();

    private static final SdkField<OutputConversion> OUTPUT_CONVERSION_FIELD = SdkField
            .<OutputConversion> builder(MarshallingType.SDK_POJO).memberName("outputConversion")
            .getter(getter(CreateTransformerRequest::outputConversion)).setter(setter(Builder::outputConversion))
            .constructor(OutputConversion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConversion").build()).build();

    private static final SdkField<SampleDocuments> SAMPLE_DOCUMENTS_FIELD = SdkField
            .<SampleDocuments> builder(MarshallingType.SDK_POJO).memberName("sampleDocuments")
            .getter(getter(CreateTransformerRequest::sampleDocuments)).setter(setter(Builder::sampleDocuments))
            .constructor(SampleDocuments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocuments").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CLIENT_TOKEN_FIELD, TAGS_FIELD, FILE_FORMAT_FIELD, MAPPING_TEMPLATE_FIELD, EDI_TYPE_FIELD, SAMPLE_DOCUMENT_FIELD,
            INPUT_CONVERSION_FIELD, MAPPING_FIELD, OUTPUT_CONVERSION_FIELD, SAMPLE_DOCUMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String clientToken;

    private final List<Tag> tags;

    private final String fileFormat;

    private final String mappingTemplate;

    private final EdiType ediType;

    private final String sampleDocument;

    private final InputConversion inputConversion;

    private final Mapping mapping;

    private final OutputConversion outputConversion;

    private final SampleDocuments sampleDocuments;

    private CreateTransformerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.fileFormat = builder.fileFormat;
        this.mappingTemplate = builder.mappingTemplate;
        this.ediType = builder.ediType;
        this.sampleDocument = builder.sampleDocument;
        this.inputConversion = builder.inputConversion;
        this.mapping = builder.mapping;
        this.outputConversion = builder.outputConversion;
        this.sampleDocuments = builder.sampleDocuments;
    }

    /**
     * <p>
     * Specifies the name of the transformer, used to identify it.
     * </p>
     * 
     * @return Specifies the name of the transformer, used to identify it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You
     * can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
     *         type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
     */
    @Deprecated
    public final FileFormat fileFormat() {
        return FileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
     */
    @Deprecated
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * Specifies the mapping template for the transformer. This template is used to map the parsed EDI file using
     * JSONata or XSLT.
     * </p>
     * <note>
     * <p>
     * This parameter is available for backwards compatibility. Use the <a
     * href="https://docs.aws.amazon.com/b2bi/latest/APIReference/API_Mapping.html">Mapping</a> data type instead.
     * </p>
     * </note>
     * 
     * @return Specifies the mapping template for the transformer. This template is used to map the parsed EDI file
     *         using JSONata or XSLT.</p> <note>
     *         <p>
     *         This parameter is available for backwards compatibility. Use the <a
     *         href="https://docs.aws.amazon.com/b2bi/latest/APIReference/API_Mapping.html">Mapping</a> data type
     *         instead.
     *         </p>
     * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
     */
    @Deprecated
    public final String mappingTemplate() {
        return mappingTemplate;
    }

    /**
     * <p>
     * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @return Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *         supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
     */
    @Deprecated
    public final EdiType ediType() {
        return ediType;
    }

    /**
     * <p>
     * Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * </p>
     * 
     * @return Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
     */
    @Deprecated
    public final String sampleDocument() {
        return sampleDocument;
    }

    /**
     * <p>
     * Specify the <code>InputConversion</code> object, which contains the format options for the inbound
     * transformation.
     * </p>
     * 
     * @return Specify the <code>InputConversion</code> object, which contains the format options for the inbound
     *         transformation.
     */
    public final InputConversion inputConversion() {
        return inputConversion;
    }

    /**
     * <p>
     * Specify the structure that contains the mapping template and its language (either XSLT or JSONATA).
     * </p>
     * 
     * @return Specify the structure that contains the mapping template and its language (either XSLT or JSONATA).
     */
    public final Mapping mapping() {
        return mapping;
    }

    /**
     * <p>
     * A structure that contains the <code>OutputConversion</code> object, which contains the format options for the
     * outbound transformation.
     * </p>
     * 
     * @return A structure that contains the <code>OutputConversion</code> object, which contains the format options for
     *         the outbound transformation.
     */
    public final OutputConversion outputConversion() {
        return outputConversion;
    }

    /**
     * <p>
     * Specify a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify
     * the location for your sample documents.
     * </p>
     * 
     * @return Specify a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to
     *         identify the location for your sample documents.
     */
    public final SampleDocuments sampleDocuments() {
        return sampleDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(ediType());
        hashCode = 31 * hashCode + Objects.hashCode(sampleDocument());
        hashCode = 31 * hashCode + Objects.hashCode(inputConversion());
        hashCode = 31 * hashCode + Objects.hashCode(mapping());
        hashCode = 31 * hashCode + Objects.hashCode(outputConversion());
        hashCode = 31 * hashCode + Objects.hashCode(sampleDocuments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransformerRequest)) {
            return false;
        }
        CreateTransformerRequest other = (CreateTransformerRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(mappingTemplate(), other.mappingTemplate()) && Objects.equals(ediType(), other.ediType())
                && Objects.equals(sampleDocument(), other.sampleDocument())
                && Objects.equals(inputConversion(), other.inputConversion()) && Objects.equals(mapping(), other.mapping())
                && Objects.equals(outputConversion(), other.outputConversion())
                && Objects.equals(sampleDocuments(), other.sampleDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransformerRequest").add("Name", name()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).add("FileFormat", fileFormatAsString())
                .add("MappingTemplate", mappingTemplate()).add("EdiType", ediType()).add("SampleDocument", sampleDocument())
                .add("InputConversion", inputConversion()).add("Mapping", mapping()).add("OutputConversion", outputConversion())
                .add("SampleDocuments", sampleDocuments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "mappingTemplate":
            return Optional.ofNullable(clazz.cast(mappingTemplate()));
        case "ediType":
            return Optional.ofNullable(clazz.cast(ediType()));
        case "sampleDocument":
            return Optional.ofNullable(clazz.cast(sampleDocument()));
        case "inputConversion":
            return Optional.ofNullable(clazz.cast(inputConversion()));
        case "mapping":
            return Optional.ofNullable(clazz.cast(mapping()));
        case "outputConversion":
            return Optional.ofNullable(clazz.cast(outputConversion()));
        case "sampleDocuments":
            return Optional.ofNullable(clazz.cast(sampleDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("fileFormat", FILE_FORMAT_FIELD);
        map.put("mappingTemplate", MAPPING_TEMPLATE_FIELD);
        map.put("ediType", EDI_TYPE_FIELD);
        map.put("sampleDocument", SAMPLE_DOCUMENT_FIELD);
        map.put("inputConversion", INPUT_CONVERSION_FIELD);
        map.put("mapping", MAPPING_FIELD);
        map.put("outputConversion", OUTPUT_CONVERSION_FIELD);
        map.put("sampleDocuments", SAMPLE_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTransformerRequest, T> g) {
        return obj -> g.apply((CreateTransformerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTransformerRequest> {
        /**
         * <p>
         * Specifies the name of the transformer, used to identify it.
         * </p>
         * 
         * @param name
         *        Specifies the name of the transformer, used to identify it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param clientToken
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
         *        type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any
         *        purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by
         *        type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any
         *        purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type.
         * You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.b2bi.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.b2bi.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         * <code>XML</code>.
         * </p>
         * 
         * @param fileFormat
         *        Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and
         *        <code>XML</code>.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        Builder fileFormat(FileFormat fileFormat);

        /**
         * <p>
         * Specifies the mapping template for the transformer. This template is used to map the parsed EDI file using
         * JSONata or XSLT.
         * </p>
         * <note>
         * <p>
         * This parameter is available for backwards compatibility. Use the <a
         * href="https://docs.aws.amazon.com/b2bi/latest/APIReference/API_Mapping.html">Mapping</a> data type instead.
         * </p>
         * </note>
         * 
         * @param mappingTemplate
         *        Specifies the mapping template for the transformer. This template is used to map the parsed EDI file
         *        using JSONata or XSLT.</p> <note>
         *        <p>
         *        This parameter is available for backwards compatibility. Use the <a
         *        href="https://docs.aws.amazon.com/b2bi/latest/APIReference/API_Mapping.html">Mapping</a> data type
         *        instead.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        Builder mappingTemplate(String mappingTemplate);

        /**
         * <p>
         * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * 
         * @param ediType
         *        Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12
         *        is supported. X12 is a set of standards and corresponding messages that define specific business
         *        documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        Builder ediType(EdiType ediType);

        /**
         * <p>
         * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdiType.Builder} avoiding the need to
         * create one manually via {@link EdiType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdiType.Builder#build()} is called immediately and its result is
         * passed to {@link #ediType(EdiType)}.
         * 
         * @param ediType
         *        a consumer that will call methods on {@link EdiType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ediType(EdiType)
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        default Builder ediType(Consumer<EdiType.Builder> ediType) {
            return ediType(EdiType.builder().applyMutation(ediType).build());
        }

        /**
         * <p>
         * Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
         * </p>
         * 
         * @param sampleDocument
         *        Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This is a legacy trait. Please use input-conversion or output-conversion.
         */
        @Deprecated
        Builder sampleDocument(String sampleDocument);

        /**
         * <p>
         * Specify the <code>InputConversion</code> object, which contains the format options for the inbound
         * transformation.
         * </p>
         * 
         * @param inputConversion
         *        Specify the <code>InputConversion</code> object, which contains the format options for the inbound
         *        transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConversion(InputConversion inputConversion);

        /**
         * <p>
         * Specify the <code>InputConversion</code> object, which contains the format options for the inbound
         * transformation.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputConversion.Builder} avoiding the
         * need to create one manually via {@link InputConversion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputConversion.Builder#build()} is called immediately and its
         * result is passed to {@link #inputConversion(InputConversion)}.
         * 
         * @param inputConversion
         *        a consumer that will call methods on {@link InputConversion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConversion(InputConversion)
         */
        default Builder inputConversion(Consumer<InputConversion.Builder> inputConversion) {
            return inputConversion(InputConversion.builder().applyMutation(inputConversion).build());
        }

        /**
         * <p>
         * Specify the structure that contains the mapping template and its language (either XSLT or JSONATA).
         * </p>
         * 
         * @param mapping
         *        Specify the structure that contains the mapping template and its language (either XSLT or JSONATA).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(Mapping mapping);

        /**
         * <p>
         * Specify the structure that contains the mapping template and its language (either XSLT or JSONATA).
         * </p>
         * This is a convenience method that creates an instance of the {@link Mapping.Builder} avoiding the need to
         * create one manually via {@link Mapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Mapping.Builder#build()} is called immediately and its result is
         * passed to {@link #mapping(Mapping)}.
         * 
         * @param mapping
         *        a consumer that will call methods on {@link Mapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapping(Mapping)
         */
        default Builder mapping(Consumer<Mapping.Builder> mapping) {
            return mapping(Mapping.builder().applyMutation(mapping).build());
        }

        /**
         * <p>
         * A structure that contains the <code>OutputConversion</code> object, which contains the format options for the
         * outbound transformation.
         * </p>
         * 
         * @param outputConversion
         *        A structure that contains the <code>OutputConversion</code> object, which contains the format options
         *        for the outbound transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConversion(OutputConversion outputConversion);

        /**
         * <p>
         * A structure that contains the <code>OutputConversion</code> object, which contains the format options for the
         * outbound transformation.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConversion.Builder} avoiding the
         * need to create one manually via {@link OutputConversion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConversion.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConversion(OutputConversion)}.
         * 
         * @param outputConversion
         *        a consumer that will call methods on {@link OutputConversion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConversion(OutputConversion)
         */
        default Builder outputConversion(Consumer<OutputConversion.Builder> outputConversion) {
            return outputConversion(OutputConversion.builder().applyMutation(outputConversion).build());
        }

        /**
         * <p>
         * Specify a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to
         * identify the location for your sample documents.
         * </p>
         * 
         * @param sampleDocuments
         *        Specify a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to
         *        identify the location for your sample documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleDocuments(SampleDocuments sampleDocuments);

        /**
         * <p>
         * Specify a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to
         * identify the location for your sample documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link SampleDocuments.Builder} avoiding the
         * need to create one manually via {@link SampleDocuments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SampleDocuments.Builder#build()} is called immediately and its
         * result is passed to {@link #sampleDocuments(SampleDocuments)}.
         * 
         * @param sampleDocuments
         *        a consumer that will call methods on {@link SampleDocuments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampleDocuments(SampleDocuments)
         */
        default Builder sampleDocuments(Consumer<SampleDocuments.Builder> sampleDocuments) {
            return sampleDocuments(SampleDocuments.builder().applyMutation(sampleDocuments).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String name;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String fileFormat;

        private String mappingTemplate;

        private EdiType ediType;

        private String sampleDocument;

        private InputConversion inputConversion;

        private Mapping mapping;

        private OutputConversion outputConversion;

        private SampleDocuments sampleDocuments;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransformerRequest model) {
            super(model);
            name(model.name);
            clientToken(model.clientToken);
            tags(model.tags);
            fileFormat(model.fileFormat);
            mappingTemplate(model.mappingTemplate);
            ediType(model.ediType);
            sampleDocument(model.sampleDocument);
            inputConversion(model.inputConversion);
            mapping(model.mapping);
            outputConversion(model.outputConversion);
            sampleDocuments(model.sampleDocuments);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final String getFileFormat() {
            return fileFormat;
        }

        @Deprecated
        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        @Deprecated
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        @Deprecated
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        @Deprecated
        public final String getMappingTemplate() {
            return mappingTemplate;
        }

        @Deprecated
        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        @Deprecated
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        @Deprecated
        public final EdiType.Builder getEdiType() {
            return ediType != null ? ediType.toBuilder() : null;
        }

        @Deprecated
        public final void setEdiType(EdiType.BuilderImpl ediType) {
            this.ediType = ediType != null ? ediType.build() : null;
        }

        @Override
        @Deprecated
        public final Builder ediType(EdiType ediType) {
            this.ediType = ediType;
            return this;
        }

        @Deprecated
        public final String getSampleDocument() {
            return sampleDocument;
        }

        @Deprecated
        public final void setSampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
        }

        @Override
        @Deprecated
        public final Builder sampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
            return this;
        }

        public final InputConversion.Builder getInputConversion() {
            return inputConversion != null ? inputConversion.toBuilder() : null;
        }

        public final void setInputConversion(InputConversion.BuilderImpl inputConversion) {
            this.inputConversion = inputConversion != null ? inputConversion.build() : null;
        }

        @Override
        public final Builder inputConversion(InputConversion inputConversion) {
            this.inputConversion = inputConversion;
            return this;
        }

        public final Mapping.Builder getMapping() {
            return mapping != null ? mapping.toBuilder() : null;
        }

        public final void setMapping(Mapping.BuilderImpl mapping) {
            this.mapping = mapping != null ? mapping.build() : null;
        }

        @Override
        public final Builder mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public final OutputConversion.Builder getOutputConversion() {
            return outputConversion != null ? outputConversion.toBuilder() : null;
        }

        public final void setOutputConversion(OutputConversion.BuilderImpl outputConversion) {
            this.outputConversion = outputConversion != null ? outputConversion.build() : null;
        }

        @Override
        public final Builder outputConversion(OutputConversion outputConversion) {
            this.outputConversion = outputConversion;
            return this;
        }

        public final SampleDocuments.Builder getSampleDocuments() {
            return sampleDocuments != null ? sampleDocuments.toBuilder() : null;
        }

        public final void setSampleDocuments(SampleDocuments.BuilderImpl sampleDocuments) {
            this.sampleDocuments = sampleDocuments != null ? sampleDocuments.build() : null;
        }

        @Override
        public final Builder sampleDocuments(SampleDocuments sampleDocuments) {
            this.sampleDocuments = sampleDocuments;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransformerRequest build() {
            return new CreateTransformerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
