/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported.
 * X12 is a set of standards and corresponding messages that define specific business documents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdiType implements SdkPojo, Serializable, ToCopyableBuilder<EdiType.Builder, EdiType> {
    private static final SdkField<X12Details> X12_DETAILS_FIELD = SdkField.<X12Details> builder(MarshallingType.SDK_POJO)
            .memberName("x12Details").getter(getter(EdiType::x12Details)).setter(setter(Builder::x12Details))
            .constructor(X12Details::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x12Details").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(X12_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final X12Details x12Details;

    private final Type type;

    private EdiType(BuilderImpl builder) {
        this.x12Details = builder.x12Details;
        this.type = builder.type;
    }

    /**
     * <p>
     * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @return Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *         supported. X12 is a set of standards and corresponding messages that define specific business documents.
     */
    public final X12Details x12Details() {
        return x12Details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(x12Details());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdiType)) {
            return false;
        }
        EdiType other = (EdiType) obj;
        return Objects.equals(x12Details(), other.x12Details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdiType").add("X12Details", x12Details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "x12Details":
            return Optional.ofNullable(clazz.cast(x12Details()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #x12Details()} initialized to the given value.
     *
     * <p>
     * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @param x12Details
     *        Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *        supported. X12 is a set of standards and corresponding messages that define specific business documents.
     */
    public static EdiType fromX12Details(X12Details x12Details) {
        return builder().x12Details(x12Details).build();
    }

    /**
     * Create an instance of this class with {@link #x12Details()} initialized to the given value.
     *
     * <p>
     * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @param x12Details
     *        Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *        supported. X12 is a set of standards and corresponding messages that define specific business documents.
     */
    public static EdiType fromX12Details(Consumer<X12Details.Builder> x12Details) {
        X12Details.Builder builder = X12Details.builder();
        x12Details.accept(builder);
        return fromX12Details(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x12Details", X12_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdiType, T> g) {
        return obj -> g.apply((EdiType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdiType> {
        /**
         * <p>
         * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * 
         * @param x12Details
         *        Returns the details for the EDI standard that is being used for the transformer. Currently, only X12
         *        is supported. X12 is a set of standards and corresponding messages that define specific business
         *        documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x12Details(X12Details x12Details);

        /**
         * <p>
         * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
         * supported. X12 is a set of standards and corresponding messages that define specific business documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link X12Details.Builder} avoiding the need to
         * create one manually via {@link X12Details#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link X12Details.Builder#build()} is called immediately and its result
         * is passed to {@link #x12Details(X12Details)}.
         * 
         * @param x12Details
         *        a consumer that will call methods on {@link X12Details.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #x12Details(X12Details)
         */
        default Builder x12Details(Consumer<X12Details.Builder> x12Details) {
            return x12Details(X12Details.builder().applyMutation(x12Details).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private X12Details x12Details;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EdiType model) {
            x12Details(model.x12Details);
        }

        public final X12Details.Builder getX12Details() {
            return x12Details != null ? x12Details.toBuilder() : null;
        }

        public final void setX12Details(X12Details.BuilderImpl x12Details) {
            Object oldValue = this.x12Details;
            this.x12Details = x12Details != null ? x12Details.build() : null;
            handleUnionValueChange(Type.X12_DETAILS, oldValue, this.x12Details);
        }

        @Override
        public final Builder x12Details(X12Details x12Details) {
            Object oldValue = this.x12Details;
            this.x12Details = x12Details;
            handleUnionValueChange(Type.X12_DETAILS, oldValue, this.x12Details);
            return this;
        }

        @Override
        public EdiType build() {
            return new EdiType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EdiType#type()
     */
    public enum Type {
        X12_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
