/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateMappingResponse extends B2BiResponse implements
        ToCopyableBuilder<GenerateMappingResponse.Builder, GenerateMappingResponse> {
    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mappingTemplate").getter(getter(GenerateMappingResponse::mappingTemplate))
            .setter(setter(Builder::mappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()).build();

    private static final SdkField<Float> MAPPING_ACCURACY_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("mappingAccuracy").getter(getter(GenerateMappingResponse::mappingAccuracy))
            .setter(setter(Builder::mappingAccuracy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingAccuracy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAPPING_TEMPLATE_FIELD,
            MAPPING_ACCURACY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mappingTemplate;

    private final Float mappingAccuracy;

    private GenerateMappingResponse(BuilderImpl builder) {
        super(builder);
        this.mappingTemplate = builder.mappingTemplate;
        this.mappingAccuracy = builder.mappingAccuracy;
    }

    /**
     * <p>
     * Returns a mapping template based on your inputs.
     * </p>
     * 
     * @return Returns a mapping template based on your inputs.
     */
    public final String mappingTemplate() {
        return mappingTemplate;
    }

    /**
     * <p>
     * Returns a percentage that estimates the accuracy of the generated mapping.
     * </p>
     * 
     * @return Returns a percentage that estimates the accuracy of the generated mapping.
     */
    public final Float mappingAccuracy() {
        return mappingAccuracy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(mappingAccuracy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMappingResponse)) {
            return false;
        }
        GenerateMappingResponse other = (GenerateMappingResponse) obj;
        return Objects.equals(mappingTemplate(), other.mappingTemplate())
                && Objects.equals(mappingAccuracy(), other.mappingAccuracy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateMappingResponse").add("MappingTemplate", mappingTemplate())
                .add("MappingAccuracy", mappingAccuracy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mappingTemplate":
            return Optional.ofNullable(clazz.cast(mappingTemplate()));
        case "mappingAccuracy":
            return Optional.ofNullable(clazz.cast(mappingAccuracy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mappingTemplate", MAPPING_TEMPLATE_FIELD);
        map.put("mappingAccuracy", MAPPING_ACCURACY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateMappingResponse, T> g) {
        return obj -> g.apply((GenerateMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, GenerateMappingResponse> {
        /**
         * <p>
         * Returns a mapping template based on your inputs.
         * </p>
         * 
         * @param mappingTemplate
         *        Returns a mapping template based on your inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingTemplate(String mappingTemplate);

        /**
         * <p>
         * Returns a percentage that estimates the accuracy of the generated mapping.
         * </p>
         * 
         * @param mappingAccuracy
         *        Returns a percentage that estimates the accuracy of the generated mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappingAccuracy(Float mappingAccuracy);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private String mappingTemplate;

        private Float mappingAccuracy;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMappingResponse model) {
            super(model);
            mappingTemplate(model.mappingTemplate);
            mappingAccuracy(model.mappingAccuracy);
        }

        public final String getMappingTemplate() {
            return mappingTemplate;
        }

        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        public final Float getMappingAccuracy() {
            return mappingAccuracy;
        }

        public final void setMappingAccuracy(Float mappingAccuracy) {
            this.mappingAccuracy = mappingAccuracy;
        }

        @Override
        public final Builder mappingAccuracy(Float mappingAccuracy) {
            this.mappingAccuracy = mappingAccuracy;
            return this;
        }

        @Override
        public GenerateMappingResponse build() {
            return new GenerateMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
