/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransformerJobRequest extends B2BiRequest implements
        ToCopyableBuilder<GetTransformerJobRequest.Builder, GetTransformerJobRequest> {
    private static final SdkField<String> TRANSFORMER_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformerJobId").getter(getter(GetTransformerJobRequest::transformerJobId))
            .setter(setter(Builder::transformerJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerJobId").build()).build();

    private static final SdkField<String> TRANSFORMER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transformerId").getter(getter(GetTransformerJobRequest::transformerId))
            .setter(setter(Builder::transformerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMER_JOB_ID_FIELD,
            TRANSFORMER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transformerJobId;

    private final String transformerId;

    private GetTransformerJobRequest(BuilderImpl builder) {
        super(builder);
        this.transformerJobId = builder.transformerJobId;
        this.transformerId = builder.transformerId;
    }

    /**
     * <p>
     * Specifies the unique, system-generated identifier for a transformer run.
     * </p>
     * 
     * @return Specifies the unique, system-generated identifier for a transformer run.
     */
    public final String transformerJobId() {
        return transformerJobId;
    }

    /**
     * <p>
     * Specifies the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @return Specifies the system-assigned unique identifier for the transformer.
     */
    public final String transformerId() {
        return transformerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformerJobId());
        hashCode = 31 * hashCode + Objects.hashCode(transformerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransformerJobRequest)) {
            return false;
        }
        GetTransformerJobRequest other = (GetTransformerJobRequest) obj;
        return Objects.equals(transformerJobId(), other.transformerJobId())
                && Objects.equals(transformerId(), other.transformerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTransformerJobRequest").add("TransformerJobId", transformerJobId())
                .add("TransformerId", transformerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transformerJobId":
            return Optional.ofNullable(clazz.cast(transformerJobId()));
        case "transformerId":
            return Optional.ofNullable(clazz.cast(transformerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transformerJobId", TRANSFORMER_JOB_ID_FIELD);
        map.put("transformerId", TRANSFORMER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTransformerJobRequest, T> g) {
        return obj -> g.apply((GetTransformerJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTransformerJobRequest> {
        /**
         * <p>
         * Specifies the unique, system-generated identifier for a transformer run.
         * </p>
         * 
         * @param transformerJobId
         *        Specifies the unique, system-generated identifier for a transformer run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerJobId(String transformerJobId);

        /**
         * <p>
         * Specifies the system-assigned unique identifier for the transformer.
         * </p>
         * 
         * @param transformerId
         *        Specifies the system-assigned unique identifier for the transformer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformerId(String transformerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends B2BiRequest.BuilderImpl implements Builder {
        private String transformerJobId;

        private String transformerId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransformerJobRequest model) {
            super(model);
            transformerJobId(model.transformerJobId);
            transformerId(model.transformerId);
        }

        public final String getTransformerJobId() {
            return transformerJobId;
        }

        public final void setTransformerJobId(String transformerJobId) {
            this.transformerJobId = transformerJobId;
        }

        @Override
        public final Builder transformerJobId(String transformerJobId) {
            this.transformerJobId = transformerJobId;
            return this;
        }

        public final String getTransformerId() {
            return transformerId;
        }

        public final void setTransformerId(String transformerId) {
            this.transformerId = transformerId;
        }

        @Override
        public final Builder transformerId(String transformerId) {
            this.transformerId = transformerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTransformerJobRequest build() {
            return new GetTransformerJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
