/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCapabilitiesResponse extends B2BiResponse implements
        ToCopyableBuilder<ListCapabilitiesResponse.Builder, ListCapabilitiesResponse> {
    private static final SdkField<List<CapabilitySummary>> CAPABILITIES_FIELD = SdkField
            .<List<CapabilitySummary>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(ListCapabilitiesResponse::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapabilitySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapabilitySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCapabilitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CapabilitySummary> capabilities;

    private final String nextToken;

    private ListCapabilitiesResponse(BuilderImpl builder) {
        super(builder);
        this.capabilities = builder.capabilities;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns one or more capabilities associated with this partnership.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return Returns one or more capabilities associated with this partnership.
     */
    public final List<CapabilitySummary> capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the
     * output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing
     * additional resources.
     * </p>
     * 
     * @return When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in
     *         the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue
     *         listing additional resources.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCapabilitiesResponse)) {
            return false;
        }
        ListCapabilitiesResponse other = (ListCapabilitiesResponse) obj;
        return hasCapabilities() == other.hasCapabilities() && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCapabilitiesResponse").add("Capabilities", hasCapabilities() ? capabilities() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("capabilities", CAPABILITIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCapabilitiesResponse, T> g) {
        return obj -> g.apply((ListCapabilitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends B2BiResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCapabilitiesResponse> {
        /**
         * <p>
         * Returns one or more capabilities associated with this partnership.
         * </p>
         * 
         * @param capabilities
         *        Returns one or more capabilities associated with this partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<CapabilitySummary> capabilities);

        /**
         * <p>
         * Returns one or more capabilities associated with this partnership.
         * </p>
         * 
         * @param capabilities
         *        Returns one or more capabilities associated with this partnership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(CapabilitySummary... capabilities);

        /**
         * <p>
         * Returns one or more capabilities associated with this partnership.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.b2bi.model.CapabilitySummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.b2bi.model.CapabilitySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.b2bi.model.CapabilitySummary.Builder#build()} is called immediately
         * and its result is passed to {@link #capabilities(List<CapabilitySummary>)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.b2bi.model.CapabilitySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(java.util.Collection<CapabilitySummary>)
         */
        Builder capabilities(Consumer<CapabilitySummary.Builder>... capabilities);

        /**
         * <p>
         * When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the
         * output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing
         * additional resources.
         * </p>
         * 
         * @param nextToken
         *        When additional results are obtained from the command, a <code>NextToken</code> parameter is returned
         *        in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to
         *        continue listing additional resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends B2BiResponse.BuilderImpl implements Builder {
        private List<CapabilitySummary> capabilities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCapabilitiesResponse model) {
            super(model);
            capabilities(model.capabilities);
            nextToken(model.nextToken);
        }

        public final List<CapabilitySummary.Builder> getCapabilities() {
            List<CapabilitySummary.Builder> result = CapabilityListCopier.copyToBuilder(this.capabilities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapabilities(Collection<CapabilitySummary.BuilderImpl> capabilities) {
            this.capabilities = CapabilityListCopier.copyFromBuilder(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<CapabilitySummary> capabilities) {
            this.capabilities = CapabilityListCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(CapabilitySummary... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Consumer<CapabilitySummary.Builder>... capabilities) {
            capabilities(Stream.of(capabilities).map(c -> CapabilitySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCapabilitiesResponse build() {
            return new ListCapabilitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
